/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.guncus.item.attachments;

import de.cas_ual_ty.guncus.item.ItemAttachment;
import de.cas_ual_ty.guncus.item.attachments.EnumAttachmentType;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class Optic
extends ItemAttachment {
    public static final Optic DEFAULT = new Optic();
    protected Supplier<ResourceLocation> overlay;
    protected EnumOpticType opticType;

    public Optic(Item.Properties properties) {
        super(properties);
        this.setExtraZoom(1.0f);
        this.overlay = this::getDefaultOverlay;
        this.opticType = EnumOpticType.NORMAL;
    }

    protected Optic() {
        this(new Item.Properties());
    }

    @Override
    public EnumAttachmentType getType() {
        return EnumAttachmentType.OPTIC;
    }

    public boolean isCompatibleWithMagnifiers() {
        return this.getZoom() <= 4.0f;
    }

    public boolean isCompatibleWithExtraZoom() {
        return !this.isCompatibleWithMagnifiers();
    }

    public boolean canAim() {
        return !this.isDefault() && this.getOverlay() != null;
    }

    public ResourceLocation getDefaultOverlay() {
        ResourceLocation rl = this.getRegistryName();
        return new ResourceLocation(rl.func_110624_b(), "textures/gui/sights/" + this.getRegistryName().func_110623_a() + ".png");
    }

    public ResourceLocation getOverlay() {
        return this.overlay.get();
    }

    public boolean getIsClosedScope() {
        return this.getZoom() >= 6.0f;
    }

    public float getZoom() {
        return this.getExtraZoom();
    }

    public EnumOpticType getOpticType() {
        return this.opticType;
    }

    public Optic setOverlay(Supplier<ResourceLocation> overlay) {
        this.overlay = overlay;
        return this;
    }

    public Optic setOpticType(EnumOpticType opticType) {
        this.opticType = opticType;
        return this;
    }

    @Override
    public ITextComponent getInformationString() {
        return new StringTextComponent(super.getInformationString().func_150254_d() + (this.isDefault() ? "" : " (" + this.getZoom() + ")"));
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        StringTextComponent value = new StringTextComponent("" + this.getZoom());
        ITextComponent zoom = new TranslationTextComponent("local.guncus.zoom", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GRAY));
        tooltip.add((ITextComponent)new StringTextComponent(value.func_150254_d() + " " + zoom.func_150254_d()));
    }

    public static enum EnumOpticType {
        NORMAL,
        NIGHT_VISION,
        THERMAL;

    }
}

