/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.guncus.util;

import com.google.common.collect.ImmutableSet;
import de.cas_ual_ty.guncus.item.ItemAttachment;
import de.cas_ual_ty.guncus.item.ItemGun;
import de.cas_ual_ty.guncus.item.attachments.EnumAttachmentType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class GunCusUtility {
    private static Method blockStatesInjector = ObfuscationReflectionHelper.findMethod(PointOfInterestType.class, (String)"func_221052_a", (Class[])new Class[]{PointOfInterestType.class});
    public static final Hand[] HANDS = Hand.values();

    public static Hand[] intToHands(int handsInt) {
        if (handsInt == 1) {
            return new Hand[]{Hand.MAIN_HAND};
        }
        if (handsInt == 2) {
            return new Hand[]{Hand.OFF_HAND};
        }
        if (handsInt == 3) {
            return new Hand[]{Hand.MAIN_HAND, Hand.OFF_HAND};
        }
        return new Hand[0];
    }

    public static AxisAlignedBB aabbFromVec3ds(Vec3d vec1, Vec3d vec2) {
        return new AxisAlignedBB(Math.min(vec1.field_72450_a, vec2.field_72450_a), Math.min(vec1.field_72448_b, vec2.field_72448_b), Math.min(vec1.field_72449_c, vec2.field_72449_c), Math.max(vec1.field_72450_a, vec2.field_72450_a), Math.max(vec1.field_72448_b, vec2.field_72448_b), Math.max(vec1.field_72449_c, vec2.field_72449_c));
    }

    public static ArrayList<ItemStack> createAllVariants(ItemGun gun) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        EnumAttachmentType.callForAll(gun, attachments -> itemStacks.add(gun.createVariant((ItemAttachment[])attachments)));
        return itemStacks;
    }

    public static Set<BlockState> getAllStates(Block block) {
        return ImmutableSet.copyOf((Collection)block.func_176194_O().func_177619_a());
    }

    public static void fixPOITypeBlockStates(PointOfInterestType poiType) {
        try {
            blockStatesInjector.invoke(null, poiType);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static PointOfInterestType pointOfInterestType(String p1, Set<BlockState> p2, int p3, int p4) {
        try {
            Constructor c = PointOfInterestType.class.getDeclaredConstructor(String.class, Set.class, Integer.TYPE, Integer.TYPE);
            c.setAccessible(true);
            return (PointOfInterestType)c.newInstance(p1, p2, p3, p4);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static VillagerProfession villagerProfession(String p1, PointOfInterestType p2, ImmutableSet<Item> p3, ImmutableSet<Block> p4, @Nullable SoundEvent p5) {
        try {
            Constructor c = VillagerProfession.class.getDeclaredConstructor(String.class, PointOfInterestType.class, ImmutableSet.class, ImmutableSet.class, SoundEvent.class);
            c.setAccessible(true);
            return (VillagerProfession)c.newInstance(p1, p2, p3, p4, p5);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }
}

