/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.guncus.util;

import java.util.ArrayList;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.IItemProvider;

public class RandomTradeBuilder {
    private static final ArrayList<ArrayList<RandomTradeBuilder>> TRADES_LIST = new ArrayList();
    protected Function<Random, ItemStack> price = null;
    protected Function<Random, ItemStack> price2 = random -> ItemStack.field_190927_a;
    protected Function<Random, ItemStack> forSale = null;
    protected final int maxTrades;
    protected final int xp;
    protected final float priceMult;
    protected boolean rare;

    private static ArrayList<RandomTradeBuilder> getList(int i) {
        return TRADES_LIST.get(i);
    }

    private static void register(int i, RandomTradeBuilder tradeBuilder) {
        RandomTradeBuilder.getList(i).add(tradeBuilder);
    }

    public static void forEachLevel(BiConsumer<Integer, RandomTradeBuilder> consumer) {
        for (int i = 1; i <= 5; ++i) {
            ArrayList<RandomTradeBuilder> list = TRADES_LIST.get(i - 1);
            for (RandomTradeBuilder tradeBuilder : list) {
                consumer.accept(i, tradeBuilder);
            }
        }
    }

    public static void forEachLevel(Consumer<RandomTradeBuilder> consumer) {
        RandomTradeBuilder.forEachLevel((Integer level, RandomTradeBuilder tradeBuilder) -> consumer.accept((RandomTradeBuilder)tradeBuilder));
    }

    public static void forEachWanderer(Consumer<RandomTradeBuilder> consumer) {
        ArrayList<RandomTradeBuilder> list = TRADES_LIST.get(5);
        for (RandomTradeBuilder tradeBuilder : list) {
            consumer.accept(tradeBuilder);
        }
    }

    public static void forEachWandererRare(Consumer<RandomTradeBuilder> consumer) {
        ArrayList<RandomTradeBuilder> list = TRADES_LIST.get(6);
        for (RandomTradeBuilder tradeBuilder : list) {
            consumer.accept(tradeBuilder);
        }
    }

    public RandomTradeBuilder(int maxTrades, int xp, float priceMult) {
        this.maxTrades = maxTrades;
        this.xp = xp;
        this.priceMult = priceMult;
        this.rare = false;
    }

    public RandomTradeBuilder setPrice(Function<Random, ItemStack> price) {
        this.price = price;
        return this;
    }

    public RandomTradeBuilder setPrice(Item item, int min, int max) {
        return this.setPrice(RandomTradeBuilder.createFunction(item, min, max));
    }

    public RandomTradeBuilder setPrice2(Function<Random, ItemStack> price2) {
        this.price2 = price2;
        return this;
    }

    public RandomTradeBuilder setPrice2(Item item, int min, int max) {
        return this.setPrice2(RandomTradeBuilder.createFunction(item, min, max));
    }

    public RandomTradeBuilder setForSale(Function<Random, ItemStack> forSale) {
        this.forSale = forSale;
        return this;
    }

    public RandomTradeBuilder setForSale(Item item, int min, int max) {
        return this.setForSale(RandomTradeBuilder.createFunction(item, min, max));
    }

    public RandomTradeBuilder setEmeraldPrice(int emeralds) {
        return this.setPrice(random -> new ItemStack((IItemProvider)Items.field_151166_bC, emeralds));
    }

    public RandomTradeBuilder setEmeraldPriceFor(int emeralds, Item item, int amt) {
        this.setEmeraldPrice(emeralds);
        return this.setForSale(random -> new ItemStack((IItemProvider)item, amt));
    }

    public RandomTradeBuilder setEmeraldPriceFor(int emeralds, Item item) {
        return this.setEmeraldPriceFor(emeralds, item, 1);
    }

    public RandomTradeBuilder setEmeraldPrice(int min, int max) {
        return this.setPrice(Items.field_151166_bC, min, max);
    }

    public RandomTradeBuilder setEmeraldPriceFor(int min, int max, Item item, int amt) {
        this.setEmeraldPrice(min, max);
        return this.setForSale(random -> new ItemStack((IItemProvider)item, amt));
    }

    public RandomTradeBuilder setEmeraldPriceFor(int min, int max, Item item) {
        return this.setEmeraldPriceFor(min, max, item, 1);
    }

    public RandomTradeBuilder setRare() {
        this.rare = true;
        return this;
    }

    public boolean canBuild() {
        return this.price != null && this.forSale != null;
    }

    public VillagerTrades.ITrade build() {
        return (entity, random) -> !this.canBuild() ? null : new MerchantOffer(this.price.apply(random), this.price2.apply(random), this.forSale.apply(random), this.maxTrades, this.xp, this.priceMult);
    }

    public static Function<Random, ItemStack> createFunction(Item item, int min, int max) {
        return random -> new ItemStack((IItemProvider)item, random.nextInt(max) + min);
    }

    protected RandomTradeBuilder register(int index) {
        RandomTradeBuilder.register(index, this);
        return this;
    }

    public RandomTradeBuilder registerLevel(int level) {
        return this.register(level - 1);
    }

    public RandomTradeBuilder registerWanderer(boolean rare) {
        return this.register(rare ? 6 : 5);
    }

    static {
        for (int i = 0; i <= 6; ++i) {
            TRADES_LIST.add(new ArrayList());
        }
    }
}

