/*
 * Decompiled with CFR 0.152.
 */
package tv.mongotheelder.harvestsprites.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import tv.mongotheelder.harvestsprites.Config;
import tv.mongotheelder.harvestsprites.blocks.SpriteHoardBlock;
import tv.mongotheelder.harvestsprites.blocks.SpriteHoardTile;
import tv.mongotheelder.harvestsprites.blocks.SpriteLampBlock;
import tv.mongotheelder.harvestsprites.blocks.SpriteLampContainer;
import tv.mongotheelder.harvestsprites.setup.Registration;

public class SpriteLampTile
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private LazyOptional<IItemHandler> handler = LazyOptional.of(this::createHandler);
    private long foodCounter;
    private long foodMaxValue = 1L;
    private float harvestLimit;
    private boolean done;
    private int tickCount = 0;
    private boolean needToReplant;
    private int lampRedstoneLevel;

    public SpriteLampTile() {
        super((TileEntityType)Registration.SPRITE_LAMP_TILE.get());
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    private void updatePoweredState() {
        boolean active;
        BlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        boolean bl = active = this.foodCounter > 0L;
        if (active != (Boolean)blockState.func_177229_b((Property)BlockStateProperties.field_208194_u)) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)blockState.func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(active)), 3);
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.tickCount++ < (Integer)Config.TICKS_PER_CYCLE.get()) {
            return;
        }
        this.tickCount = 0;
        this.updatePoweredState();
        this.done = false;
        if (this.foodCounter <= 0L) {
            this.handler.ifPresent(h -> {
                ItemStack stack = h.getStackInSlot(0);
                this.done = stack.func_190926_b();
            });
        }
        if (this.done) {
            return;
        }
        this.harvestBlocks();
        this.consumeFood();
        this.func_70296_d();
    }

    private void harvestBlocks() {
        int harvestCost;
        ArrayList<BlockPos> harvestableCropPositions = this.getHarvestableCropPositions();
        ArrayList<BlockPos> hoardList = this.locateHoards();
        if (((Boolean)Config.RANDOMIZE_HOARDS.get()).booleanValue()) {
            Collections.shuffle(hoardList);
        }
        int n = harvestCost = ((Boolean)Config.CONSUME_ONLY_ON_HARVEST.get() == false || !harvestableCropPositions.isEmpty()) && (Long)Config.FOOD_CONSUMPTION_RATE.get() != 0L ? 1 : 0;
        if (this.foodCounter > 0L) {
            this.foodCounter -= (long)harvestCost;
            Collections.shuffle(harvestableCropPositions);
            this.doHarvest(harvestableCropPositions, hoardList);
        }
    }

    public void foodChanged() {
        if (this.field_145850_b == null) {
            return;
        }
        SpriteLampBlock block = (SpriteLampBlock)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        block.notifyNeighbors(this.field_145850_b, this.field_174879_c);
    }

    private void consumeFood() {
        if (this.foodCounter <= 0L) {
            this.handler.ifPresent(h -> {
                ItemStack stack = h.getStackInSlot(0);
                if (stack.func_77973_b().func_219971_r()) {
                    Food food = stack.func_77973_b().func_219967_s();
                    if ((Long)Config.FOOD_CONSUMPTION_RATE.get() > 0L) {
                        h.extractItem(0, 1, false);
                    }
                    this.foodCounter = this.foodMaxValue = (long)food.func_221466_a() * Math.max((Long)Config.FOOD_CONSUMPTION_RATE.get(), 1L);
                    this.harvestLimit = food.func_221469_b() * (float)((Integer)Config.HARVEST_RATE.get()).intValue();
                    this.foodChanged();
                }
            });
        }
    }

    public int getLampRedstoneLevel() {
        this.lampRedstoneLevel = 0;
        this.handler.ifPresent(h -> {
            ItemStack stack = h.getStackInSlot(0);
            this.lampRedstoneLevel = stack.func_190916_E() == 0 ? 0 : (int)Math.floor((float)(stack.func_190916_E() - 1) * 15.0f / (float)stack.func_77976_d()) + 1;
        });
        return this.lampRedstoneLevel;
    }

    private boolean isSeedy(ItemStack itemStack) {
        ResourceLocation tag = new ResourceLocation("forge", "seeds");
        return itemStack.func_77973_b().getTags().contains(tag);
    }

    private boolean isCropSeed(BlockState blockState, ItemStack itemStack) {
        CropsBlock blk = (CropsBlock)blockState.func_177230_c();
        Item cropSeed = blk.func_185473_a((IBlockReader)this.field_145850_b, this.field_174879_c, blockState).func_77973_b();
        return this.isSeedy(itemStack) || cropSeed == itemStack.func_77973_b();
    }

    private boolean isValidCropBlock(BlockPos pos) {
        return this.field_145850_b.func_195588_v(pos) && this.field_145850_b.func_180495_p(pos).func_177230_c() instanceof CropsBlock;
    }

    private boolean isValidHoardBlock(BlockPos pos) {
        return this.field_145850_b.func_195588_v(pos) && this.field_145850_b.func_180495_p(pos).func_177230_c() instanceof SpriteHoardBlock;
    }

    private void doHarvest(ArrayList<BlockPos> harvestableBlocks, ArrayList<BlockPos> hoardList) {
        int harvestCount = 0;
        for (BlockPos pos : harvestableBlocks) {
            int n = harvestCount++;
            if ((float)n > this.harvestLimit && (double)this.harvestLimit != 0.0 || !this.isValidCropBlock(pos)) {
                return;
            }
            BlockState blockState = this.field_145850_b.func_180495_p(pos);
            CropsBlock blk = (CropsBlock)blockState.func_177230_c();
            Item cropSeed = blk.func_185473_a((IBlockReader)this.field_145850_b, pos, blockState).func_77973_b();
            this.needToReplant = true;
            Block.func_220070_a((BlockState)blockState, (ServerWorld)((ServerWorld)this.field_145850_b), (BlockPos)pos, (TileEntity)null).forEach(itemStack -> {
                if (this.isCropSeed(blockState, (ItemStack)itemStack) && this.needToReplant) {
                    this.needToReplant = false;
                    if (!((Boolean)Config.SUPPRESS_SEED_DROPS.get()).booleanValue() || cropSeed.func_219971_r()) {
                        itemStack.func_190918_g(1);
                    }
                }
                if (!(((Boolean)Config.SUPPRESS_SEED_DROPS.get()).booleanValue() && itemStack.func_77973_b() == cropSeed && !cropSeed.func_219971_r() || itemStack.func_190926_b())) {
                    SpriteHoardTile spriteHordeTile;
                    BlockPos p;
                    Iterator iterator = hoardList.iterator();
                    while (!(!iterator.hasNext() || this.isValidHoardBlock(p = (BlockPos)iterator.next()) && (spriteHordeTile = (SpriteHoardTile)this.field_145850_b.func_175625_s(p)) != null && (itemStack = SpriteLampTile.putStackInInventoryAllSlots((IInventory)spriteHordeTile, itemStack)).func_190926_b())) {
                    }
                    if (!itemStack.func_190926_b()) {
                        Block.func_180635_a((World)this.field_145850_b, (BlockPos)pos, (ItemStack)itemStack);
                    }
                }
            });
            this.field_145850_b.func_175656_a(pos, blk.func_185528_e(0));
        }
    }

    private ArrayList<BlockPos> getHarvestableCropPositions() {
        int range = (Integer)Config.HARVEST_RANGE.get();
        int vRange = (Integer)Config.HARVEST_HEIGHT.get();
        BlockPos minCorner = this.field_174879_c.func_177982_a(-range, -vRange, -range);
        BlockPos maxCorner = this.field_174879_c.func_177982_a(range, vRange, range);
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        if (this.field_145850_b != null && this.field_145850_b.isAreaLoaded(this.field_174879_c, range)) {
            for (int x = minCorner.func_177958_n(); x <= maxCorner.func_177958_n(); ++x) {
                block1: for (int z = minCorner.func_177952_p(); z <= maxCorner.func_177952_p(); ++z) {
                    for (int y = minCorner.func_177956_o(); y <= maxCorner.func_177956_o(); ++y) {
                        BlockPos target = new BlockPos(x, y, z);
                        BlockState blockState = this.field_145850_b.func_180495_p(target);
                        if (!(blockState.func_177230_c() instanceof CropsBlock) || !((CropsBlock)blockState.func_177230_c()).func_185525_y(blockState)) continue;
                        blocks.add(target);
                        continue block1;
                    }
                }
            }
        }
        return blocks;
    }

    private ArrayList<BlockPos> locateHoards() {
        int range = (Integer)Config.HOARD_RANGE.get();
        int vRange = (Integer)Config.HOARD_HEIGHT.get();
        BlockPos minCorner = this.field_174879_c.func_177982_a(-range, -vRange, -range);
        BlockPos maxCorner = this.field_174879_c.func_177982_a(range, vRange, range);
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        if (this.field_145850_b != null && this.field_145850_b.isAreaLoaded(this.field_174879_c, range)) {
            for (int x = minCorner.func_177958_n(); x <= maxCorner.func_177958_n(); ++x) {
                for (int z = minCorner.func_177952_p(); z <= maxCorner.func_177952_p(); ++z) {
                    for (int y = minCorner.func_177956_o(); y <= maxCorner.func_177956_o(); ++y) {
                        BlockPos target = new BlockPos(x, y, z);
                        BlockState blockState = this.field_145850_b.func_180495_p(target);
                        if (blockState.func_177230_c() != Registration.SPRITE_HOARD.get()) continue;
                        blocks.add(target);
                    }
                }
            }
        }
        return blocks;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        CompoundNBT invTag = tag.func_74775_l("inventory");
        this.handler.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)invTag));
        this.foodCounter = tag.func_74763_f("food_counter");
        this.foodMaxValue = tag.func_74763_f("food_max_value");
        this.harvestLimit = tag.func_74760_g("harvest_limit");
        super.func_230337_a_(state, tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        this.handler.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("inventory", (INBT)compound);
        });
        tag.func_74772_a("food_counter", this.foodCounter);
        tag.func_74772_a("food_max_value", this.foodMaxValue);
        tag.func_74776_a("harvest_limit", this.harvestLimit);
        return super.func_189515_b(tag);
    }

    private IItemHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                SpriteLampTile.this.foodChanged();
                SpriteLampTile.this.func_70296_d();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.func_77973_b().func_219971_r();
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!stack.func_77973_b().func_219971_r()) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new SpriteLampContainer(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public static ItemStack putStackInInventoryAllSlots(IInventory destination, ItemStack stack) {
        int i = destination.func_70302_i_();
        for (int j = 0; j < i && !stack.func_190926_b(); ++j) {
            stack = SpriteLampTile.insertStack(destination, stack, j);
        }
        return stack;
    }

    private static ItemStack insertStack(IInventory destination, ItemStack stack, int index) {
        ItemStack itemstack = destination.func_70301_a(index);
        if (SpriteLampTile.canInsertItemInSlot(destination, stack, index)) {
            boolean flag = false;
            if (itemstack.func_190926_b()) {
                destination.func_70299_a(index, stack);
                stack = ItemStack.field_190927_a;
                flag = true;
            } else if (SpriteLampTile.canCombine(itemstack, stack)) {
                int i = stack.func_77976_d() - itemstack.func_190916_E();
                int j = Math.min(stack.func_190916_E(), i);
                stack.func_190918_g(j);
                itemstack.func_190917_f(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                destination.func_70296_d();
            }
        }
        return stack;
    }

    private static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        if (stack1.func_77952_i() != stack2.func_77952_i()) {
            return false;
        }
        if (stack1.func_190916_E() > stack1.func_77976_d()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    private static boolean canInsertItemInSlot(IInventory inventoryIn, ItemStack stack, int index) {
        return inventoryIn.func_94041_b(index, stack);
    }
}

