/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.hungerstrike.network;

import com.jaquadro.minecraft.hungerstrike.ConfigManager;
import com.jaquadro.minecraft.hungerstrike.HungerStrike;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class SyncConfigMessage
implements IMessage {
    public static final int MESSAGE_ID = 1;
    private NBTTagCompound data = new NBTTagCompound();

    public SyncConfigMessage() {
        this.data.func_74782_a("mode", (NBTBase)new NBTTagString(HungerStrike.config.getMode().toString()));
    }

    public void fromBytes(ByteBuf buf) {
        this.data = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.data);
    }

    public static class HandlerStub
    implements IMessageHandler<SyncConfigMessage, IMessage> {
        public IMessage onMessage(SyncConfigMessage message, MessageContext ctx) {
            FMLLog.log((String)"hungerstrike", (Level)Level.WARN, (String)"SyncConfigMessage stub handler called.", (Object[])new Object[0]);
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Handler
    implements IMessageHandler<SyncConfigMessage, IMessage> {
        public IMessage onMessage(SyncConfigMessage message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT && message.data.func_74764_b("mode")) {
                String mode = message.data.func_74779_i("mode");
                HungerStrike.config.setModeSoft(ConfigManager.Mode.valueOf(mode));
            }
            return null;
        }
    }
}

