/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.hungerstrike.proxy;

import com.jaquadro.minecraft.hungerstrike.ExtendedPlayer;
import com.jaquadro.minecraft.hungerstrike.ExtendedPlayerProvider;
import com.jaquadro.minecraft.hungerstrike.HungerStrike;
import com.jaquadro.minecraft.hungerstrike.PlayerHandler;
import com.jaquadro.minecraft.hungerstrike.network.RequestSyncMessage;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class CommonProxy {
    public PlayerHandler playerHandler = new PlayerHandler();

    public void registerNetworkHandlers() {
        HungerStrike.network.registerMessage(RequestSyncMessage.Handler.class, RequestSyncMessage.class, 2, Side.SERVER);
    }

    @SubscribeEvent
    public void tick(TickEvent.PlayerTickEvent event) {
        this.playerHandler.tick(event.player, event.phase, event.side);
    }

    @SubscribeEvent
    public void attachCapabilites(AttachCapabilitiesEvent event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(ExtendedPlayer.EXTENDED_PLAYER_KEY, (ICapabilityProvider)new ExtendedPlayerProvider((EntityPlayer)event.getObject()));
        }
    }

    @SubscribeEvent
    public void livingDeath(LivingDeathEvent event) {
        Entity entity = event.getEntity();
        if (!entity.func_130014_f_().field_72995_K && entity instanceof EntityPlayerMP) {
            this.playerHandler.storeData((EntityPlayer)entity);
        }
    }

    @SubscribeEvent
    public void entityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (!entity.func_130014_f_().field_72995_K && entity instanceof EntityPlayerMP) {
            this.playerHandler.restoreData((EntityPlayer)entity);
        } else if (entity.func_130014_f_().field_72995_K && entity instanceof EntityPlayerSP) {
            HungerStrike.network.sendToServer((IMessage)new RequestSyncMessage());
        }
    }
}

