/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.hungerstrike.network;

import com.jaquadro.minecraft.hungerstrike.ExtendedPlayer;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSyncExtendedPlayer {
    private boolean hungerStrikeEnabled;

    public static void encode(PacketSyncExtendedPlayer msg, PacketBuffer buf) {
        buf.writeBoolean(msg.hungerStrikeEnabled);
    }

    public static PacketSyncExtendedPlayer decode(PacketBuffer buf) {
        return new PacketSyncExtendedPlayer(buf.readBoolean());
    }

    private PacketSyncExtendedPlayer(boolean hungerStrikeEnabled) {
        this.hungerStrikeEnabled = hungerStrikeEnabled;
    }

    public PacketSyncExtendedPlayer(PlayerEntity player) {
        this(PacketSyncExtendedPlayer.getHungerStrikeFromPlayer(player));
    }

    private static boolean getHungerStrikeFromPlayer(PlayerEntity player) {
        ExtendedPlayer ep = ExtendedPlayer.get(player);
        return ep != null && ep.isOnHungerStrike();
    }

    public static void handle(PacketSyncExtendedPlayer message, Supplier<NetworkEvent.Context> ctx) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> PacketSyncExtendedPlayer.lambda$null$0(message, (Supplier)ctx));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handle(PacketSyncExtendedPlayer message, ServerPlayerEntity mp) {
        ExtendedPlayer ep = ExtendedPlayer.get((PlayerEntity)mp);
        if (ep != null) {
            ep.loadState(message.hungerStrikeEnabled);
        }
    }

    private static /* synthetic */ void lambda$null$0(PacketSyncExtendedPlayer message, Supplier ctx) {
        PacketSyncExtendedPlayer.handle(message, ((NetworkEvent.Context)ctx.get()).getSender());
    }
}

