/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.hungerstrike;

import com.jaquadro.minecraft.hungerstrike.ExtendedPlayer;
import com.jaquadro.minecraft.hungerstrike.ExtendedPlayerHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;

public class ExtendedPlayerProvider
implements ICapabilityProvider,
INBTSerializable<NBTTagCompound> {
    private final ExtendedPlayer extendedPlayer;

    public ExtendedPlayerProvider(EntityPlayer player) {
        this.extendedPlayer = new ExtendedPlayer(player);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == ExtendedPlayerHandler.EXTENDED_PLAYER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == ExtendedPlayerHandler.EXTENDED_PLAYER_CAPABILITY ? this.extendedPlayer : null);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        this.extendedPlayer.saveNBTData(compound);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.extendedPlayer.loadNBTData(nbt);
    }
}

