/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.block;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.block.IDragonProof;
import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityDragonforge;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityDragonforgeBrick;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockDragonforgeBricks
extends ContainerBlock
implements IDragonProof {
    public static final BooleanProperty GRILL = BooleanProperty.func_177716_a((String)"grill");
    private final int isFire;

    public BlockDragonforgeBricks(int isFire) {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_208770_d().func_200948_a(40.0f, 500.0f).func_200947_a(SoundType.field_185852_e));
        this.setRegistryName("iceandfire", "dragonforge_" + DragonType.getNameFromInt(isFire) + "_brick");
        this.isFire = isFire;
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)GRILL, (Comparable)Boolean.valueOf(false)));
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult resultIn) {
        if (this.getConnectedTileEntity(worldIn, resultIn.func_216350_a()) != null) {
            TileEntityDragonforge forge = this.getConnectedTileEntity(worldIn, resultIn.func_216350_a());
            if (forge.isFire == this.isFire) {
                if (worldIn.field_72995_K) {
                    IceAndFire.PROXY.setRefrencedTE(worldIn.func_175625_s(forge.func_174877_v()));
                } else {
                    INamedContainerProvider inamedcontainerprovider = this.func_220052_b(forge.func_195044_w(), worldIn, forge.func_174877_v());
                    if (inamedcontainerprovider != null) {
                        player.func_213829_a(inamedcontainerprovider);
                    }
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.FAIL;
    }

    public void updateTick(World worldIn, BlockPos pos, BlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            this.checkGrill(worldIn, pos);
        }
    }

    public int tickRate(World worldIn) {
        return 3;
    }

    private void checkGrill(World worldIn, BlockPos pos) {
        BlockState state = worldIn.func_180495_p(pos);
        boolean missingFurnace = this.getConnectedTileEntity(worldIn, pos) == null;
        worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)GRILL, (Comparable)Boolean.valueOf(!missingFurnace)));
    }

    private TileEntityDragonforge getConnectedTileEntity(World worldIn, BlockPos pos) {
        for (Direction facing : Direction.values()) {
            TileEntityDragonforge forge;
            if (worldIn.func_175625_s(pos.func_177972_a(facing)) == null || !(worldIn.func_175625_s(pos.func_177972_a(facing)) instanceof TileEntityDragonforge) || (forge = (TileEntityDragonforge)worldIn.func_175625_s(pos.func_177972_a(facing))) == null || !forge.assembled()) continue;
            return forge;
        }
        return null;
    }

    public BlockState getStateFromMeta(int meta) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)GRILL, (Comparable)Boolean.valueOf(meta > 0));
    }

    public int getMetaFromState(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)GRILL) != false ? 1 : 0;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{GRILL});
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityDragonforgeBrick();
    }
}

