/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.block;

import com.github.alexthe666.iceandfire.block.IDragonProof;
import com.github.alexthe666.iceandfire.block.IDreadBlock;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockDreadWoodLock
extends Block
implements IDragonProof,
IDreadBlock {
    public static final BooleanProperty PLAYER_PLACED = BooleanProperty.func_177716_a((String)"player_placed");

    public BlockDreadWoodLock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(4.0f, 1000000.0f).func_200947_a(SoundType.field_185848_a));
        this.setRegistryName("iceandfire", "dreadwood_planks_lock");
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)PLAYER_PLACED, (Comparable)Boolean.valueOf(false)));
    }

    public float func_176195_g(BlockState blockState, IBlockReader worldIn, BlockPos pos) {
        return (Boolean)blockState.func_177229_b((IProperty)PLAYER_PLACED) != false ? super.func_176195_g(blockState, worldIn, pos) : -1.0f;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult resultIn) {
        ItemStack stack = player.func_184586_b(handIn);
        if (stack.func_77973_b() == IafItemRegistry.DREAD_KEY) {
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            this.deleteNearbyWood(worldIn, pos, pos);
            worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187928_hb, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187657_V, SoundCategory.BLOCKS, 1.0f, 2.0f, false);
        }
        return ActionResultType.SUCCESS;
    }

    private void deleteNearbyWood(World worldIn, BlockPos pos, BlockPos startPos) {
        if (pos.func_177951_i((Vec3i)startPos) < 32.0 && (worldIn.func_180495_p(pos).func_177230_c() == IafBlockRegistry.DREADWOOD_PLANKS || worldIn.func_180495_p(pos).func_177230_c() == IafBlockRegistry.DREADWOOD_PLANKS_LOCK)) {
            worldIn.func_175655_b(pos, false);
            for (Direction facing : Direction.values()) {
                this.deleteNearbyWood(worldIn, pos.func_177972_a(facing), startPos);
            }
        }
    }

    public BlockState getStateFromMeta(int meta) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)PLAYER_PLACED, (Comparable)Boolean.valueOf(meta > 0));
    }

    public int getMetaFromState(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)PLAYER_PLACED) != false ? 1 : 0;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{PLAYER_PLACED});
    }

    public BlockState getStateForPlacement(World worldIn, BlockPos pos, Direction facing, float hitX, float hitY, float hitZ, int meta, LivingEntity placer) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)PLAYER_PLACED, (Comparable)Boolean.valueOf(true));
    }
}

