/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.gui;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.client.StatCollector;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.inventory.ContainerDragon;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiDragon
extends ContainerScreen<ContainerDragon> {
    private static final ResourceLocation texture = new ResourceLocation("iceandfire:textures/gui/dragon.png");
    private PlayerInventory playerInventory;
    private ContainerDragon dragonInv;
    private float mousePosx;
    private float mousePosY;

    public GuiDragon(ContainerDragon dragonInv, PlayerInventory playerInv, ITextComponent name) {
        super((Container)dragonInv, playerInv, name);
        this.playerInventory = playerInv;
        this.dragonInv = dragonInv;
        this.field_147000_g = 214;
    }

    public static void drawEntityOnScreen(int x, int y, float scale, float yaw, float pitch, LivingEntity entity) {
        float f = (float)Math.atan(yaw / 40.0f);
        float f1 = (float)Math.atan(pitch / 40.0f);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixstack.func_227862_a_(scale, scale, scale);
        Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        Quaternion quaternion1 = Vector3f.field_229179_b_.func_229187_a_(f1 * 20.0f);
        quaternion.func_195890_a(quaternion1);
        matrixstack.func_227863_a_(quaternion);
        float f2 = entity.field_70761_aq;
        float f3 = entity.field_70177_z;
        float f4 = entity.field_70125_A;
        float f5 = entity.field_70758_at;
        float f6 = entity.field_70759_as;
        entity.field_70761_aq = 180.0f + f * 20.0f;
        entity.field_70177_z = 180.0f + f * 40.0f;
        entity.field_70125_A = -f1 * 20.0f;
        entity.field_70759_as = entity.field_70177_z;
        entity.field_70758_at = entity.field_70177_z;
        EntityRendererManager entityrenderermanager = Minecraft.func_71410_x().func_175598_ae();
        quaternion1.func_195892_e();
        entityrenderermanager.func_229089_a_(quaternion1);
        entityrenderermanager.func_178633_a(false);
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        entityrenderermanager.func_229084_a_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixstack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0);
        irendertypebuffer$impl.func_228461_a_();
        entityrenderermanager.func_178633_a(true);
        entity.field_70761_aq = f2;
        entity.field_70177_z = f3;
        entity.field_70125_A = f4;
        entity.field_70758_at = f5;
        entity.field_70759_as = f6;
        RenderSystem.popMatrix();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        Entity entity = IceAndFire.PROXY.getReferencedMob();
        if (entity instanceof EntityDragonBase) {
            EntityDragonBase dragon = (EntityDragonBase)entity;
            String s1 = dragon.func_200200_C_().func_150254_d();
            this.font.func_211126_b(s1, (float)(this.field_146999_f / 2 - this.font.func_78256_a(s1) / 2), 6.0f, 0x404040);
            String s3 = dragon.func_200201_e() == null ? StatCollector.translateToLocal("dragon.unnamed") : StatCollector.translateToLocal("dragon.name") + " " + dragon.func_200201_e().func_150254_d();
            this.font.func_211126_b(s3, (float)(this.field_146999_f / 2 - this.font.func_78256_a(s3) / 2), 75.0f, 0xFFFFFF);
            String s2 = StatCollector.translateToLocal("dragon.health") + " " + Math.floor(Math.min(dragon.func_110143_aJ(), dragon.func_110138_aP())) + " / " + dragon.func_110138_aP();
            this.font.func_211126_b(s2, (float)(this.field_146999_f / 2 - this.font.func_78256_a(s2) / 2), 84.0f, 0xFFFFFF);
            String s5 = StatCollector.translateToLocal("dragon.gender") + StatCollector.translateToLocal(dragon.isMale() ? "dragon.gender.male" : "dragon.gender.female");
            this.font.func_211126_b(s5, (float)(this.field_146999_f / 2 - this.font.func_78256_a(s5) / 2), 93.0f, 0xFFFFFF);
            String s6 = StatCollector.translateToLocal("dragon.hunger") + dragon.getHunger() + "/100";
            this.font.func_211126_b(s6, (float)(this.field_146999_f / 2 - this.font.func_78256_a(s6) / 2), 102.0f, 0xFFFFFF);
            String s4 = StatCollector.translateToLocal("dragon.stage") + " " + dragon.getDragonStage() + " " + StatCollector.translateToLocal("dragon.days.front") + dragon.getAgeInDays() + " " + StatCollector.translateToLocal("dragon.days.back");
            this.font.func_211126_b(s4, (float)(this.field_146999_f / 2 - this.font.func_78256_a(s4) / 2), 111.0f, 0xFFFFFF);
            String s7 = dragon.func_70902_q() != null ? StatCollector.translateToLocal("dragon.owner") + dragon.func_70902_q().func_200200_C_().func_150254_d() : StatCollector.translateToLocal("dragon.untamed");
            this.font.func_211126_b(s7, (float)(this.field_146999_f / 2 - this.font.func_78256_a(s7) / 2), 120.0f, 0xFFFFFF);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(texture);
        int k = (this.width - this.field_146999_f) / 2;
        int l = (this.height - this.field_147000_g) / 2;
        this.blit(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        Entity entity = IceAndFire.PROXY.getReferencedMob();
        if (entity instanceof EntityDragonBase) {
            EntityDragonBase dragon = (EntityDragonBase)entity;
            float dragonScale = 1.0f / Math.max(1.0E-4f, dragon.func_213355_cm());
            GuiDragon.drawEntityOnScreen(k + 88, l + (int)(0.5f * dragon.flyProgress) + 55, dragonScale * 23.0f, (float)(k + 51) - this.mousePosx, (float)(l + 75 - 50) - this.mousePosY, (LivingEntity)dragon);
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.mousePosx = mouseX;
        this.mousePosY = mouseY;
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }
}

