/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.gui;

import com.github.alexthe666.iceandfire.ClientProxy;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.client.gui.MyrmexDeleteButton;
import com.github.alexthe666.iceandfire.client.gui.bestiary.ChangePageButton;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.message.MessageGetMyrmexHive;
import com.github.alexthe666.iceandfire.world.gen.WorldGenMyrmexHive;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiMyrmexStaff
extends Screen {
    private static final ResourceLocation JUNGLE_TEXTURE = new ResourceLocation("iceandfire:textures/gui/myrmex_staff_jungle.png");
    private static final ResourceLocation DESERT_TEXTURE = new ResourceLocation("iceandfire:textures/gui/myrmex_staff_desert.png");
    private static final WorldGenMyrmexHive.RoomType[] ROOMS = new WorldGenMyrmexHive.RoomType[]{WorldGenMyrmexHive.RoomType.FOOD, WorldGenMyrmexHive.RoomType.NURSERY, WorldGenMyrmexHive.RoomType.EMPTY};
    private static final int ROOMS_PER_PAGE = 5;
    private final List<Room> allRoomPos = Lists.newArrayList();
    private final List<MyrmexDeleteButton> allRoomButtonPos = Lists.newArrayList();
    public ChangePageButton previousPage;
    public ChangePageButton nextPage;
    int ticksSinceDeleted = 0;
    int currentPage = 0;
    private ItemStack staff;
    private boolean jungle;
    private int hiveCount;

    public GuiMyrmexStaff(ItemStack staff) {
        super((ITextComponent)new TranslationTextComponent("myrmex_staff_screen", new Object[0]));
        this.staff = staff;
        this.jungle = staff.func_77973_b() == IafItemRegistry.MYRMEX_JUNGLE_STAFF;
        this.init();
    }

    public void init() {
        super.init();
        this.buttons.clear();
        this.allRoomButtonPos.clear();
        int i = (this.width - 248) / 2;
        int j = (this.height - 166) / 2;
        int x_translate = 193;
        int y_translate = 37;
        if (ClientProxy.getReferedClientHive() == null) {
            return;
        }
        this.populateRoomMap();
        this.addButton((Widget)new Button(i + 124, j + 15, 120, 20, ClientProxy.getReferedClientHive().reproduces ? I18n.func_135052_a((String)"myrmex.message.disablebreeding", (Object[])new Object[0]) : I18n.func_135052_a((String)"myrmex.message.enablebreeding", (Object[])new Object[0]), p_214132_1_ -> {
            boolean opposite;
            ClientProxy.getReferedClientHive().reproduces = opposite = !ClientProxy.getReferedClientHive().reproduces;
        }));
        this.previousPage = new ChangePageButton(i + 5, j + 150, false, 0, this.jungle ? 2 : 1, p_214132_1_ -> {
            if (this.currentPage > 0) {
                --this.currentPage;
            }
        });
        this.addButton((Widget)this.previousPage);
        this.nextPage = new ChangePageButton(i + 225, j + 150, true, 0, this.jungle ? 2 : 1, p_214132_1_ -> {
            if (this.currentPage < this.allRoomButtonPos.size() / 5) {
                ++this.currentPage;
            }
        });
        this.addButton((Widget)this.nextPage);
        int totalRooms = this.allRoomPos.size();
        for (int rooms = 0; rooms < this.allRoomPos.size(); ++rooms) {
            int yIndex = rooms % 5;
            BlockPos pos = this.allRoomPos.get((int)rooms).pos;
            MyrmexDeleteButton button = new MyrmexDeleteButton(i + x_translate, j + y_translate + yIndex * 22, pos, I18n.func_135052_a((String)"myrmex.message.delete", (Object[])new Object[0]), p_214132_1_ -> {
                if (this.ticksSinceDeleted <= 0) {
                    ClientProxy.getReferedClientHive().removeRoom(pos);
                    this.ticksSinceDeleted = 5;
                }
            });
            button.visible = rooms < 5 * (this.currentPage + 1) && rooms >= 5 * this.currentPage;
            this.addButton((Widget)button);
            this.allRoomButtonPos.add(button);
        }
        if (totalRooms <= 5 * this.currentPage && this.currentPage > 0) {
            --this.currentPage;
        }
    }

    private void populateRoomMap() {
        this.allRoomPos.clear();
        for (WorldGenMyrmexHive.RoomType type : ROOMS) {
            List<BlockPos> roomPos = ClientProxy.getReferedClientHive().getRooms(type);
            for (BlockPos pos : roomPos) {
                String name = type == WorldGenMyrmexHive.RoomType.FOOD ? "food" : (type == WorldGenMyrmexHive.RoomType.NURSERY ? "nursery" : "misc");
                this.allRoomPos.add(new Room(pos, name));
            }
        }
        for (BlockPos pos : ClientProxy.getReferedClientHive().getEntrances().keySet()) {
            this.allRoomPos.add(new Room(pos, "enterance_surface"));
        }
        for (BlockPos pos : ClientProxy.getReferedClientHive().getEntranceBottoms().keySet()) {
            this.allRoomPos.add(new Room(pos, "enterance_bottom"));
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void renderBackground() {
        super.renderBackground();
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(this.jungle ? JUNGLE_TEXTURE : DESERT_TEXTURE);
        int i = (this.width - 248) / 2;
        int j = (this.height - 166) / 2;
        this.blit(i, j, 0, 0, 248, 166);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        if (this.ticksSinceDeleted > 0) {
            --this.ticksSinceDeleted;
        }
        this.init();
        int i = (this.width - 248) / 2 + 10;
        int j = (this.height - 166) / 2 + 8;
        super.render(mouseX, mouseY, partialTicks);
        int color = this.jungle ? 3533333 : 0xFFBF00;
        this.hiveCount = 0;
        for (int rooms = 0; rooms < this.allRoomButtonPos.size(); ++rooms) {
            if (rooms >= 5 * (this.currentPage + 1) || rooms < 5 * this.currentPage) continue;
            this.drawRoomInfo(this.allRoomPos.get((int)rooms).string, this.allRoomPos.get((int)rooms).pos, i, j, color);
        }
        if (ClientProxy.getReferedClientHive() != null) {
            if (!ClientProxy.getReferedClientHive().colonyName.isEmpty()) {
                String title = I18n.func_135052_a((String)"myrmex.message.colony_named", (Object[])new Object[]{ClientProxy.getReferedClientHive().colonyName});
                this.font.func_175063_a(title, (float)(i + 40 - title.length() / 2), (float)(j - 3), color);
            } else {
                this.font.func_175063_a(I18n.func_135052_a((String)"myrmex.message.colony", (Object[])new Object[0]), (float)(i + 80), (float)(j - 3), color);
            }
            int opinion = ClientProxy.getReferedClientHive().getPlayerReputation(Minecraft.func_71410_x().field_71439_g.func_110124_au());
            this.font.func_175063_a(I18n.func_135052_a((String)"myrmex.message.hive_opinion", (Object[])new Object[]{opinion}), (float)i, (float)(j + 12), color);
            this.font.func_175063_a(I18n.func_135052_a((String)"myrmex.message.rooms", (Object[])new Object[0]), (float)i, (float)(j + 25), color);
        }
    }

    public void onClose() {
        IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageGetMyrmexHive(ClientProxy.getReferedClientHive().toNBT()));
        super.onClose();
    }

    private void drawRoomInfo(String type, BlockPos pos, int i, int j, int color) {
        String translate = "myrmex.message.room." + type;
        this.font.func_175063_a(I18n.func_135052_a((String)translate, (Object[])new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}), (float)i, (float)(j + 36 + this.hiveCount * 22), color);
        ++this.hiveCount;
    }

    private class Room {
        public BlockPos pos;
        public String string;

        public Room(BlockPos pos, String string) {
            this.pos = pos;
            this.string = string;
        }
    }
}

