/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.model.animator;

import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.TabulaModel;
import com.github.alexthe666.iceandfire.util.IAFMath;
import net.minecraft.util.math.MathHelper;

public class IceAndFireTabulaModelAnimator {
    protected TabulaModel baseModel;

    public IceAndFireTabulaModelAnimator(TabulaModel baseModel) {
        this.baseModel = baseModel;
    }

    public void setRotateAngle(AdvancedModelBox model, float limbSwingAmount, float x, float y, float z) {
        model.field_78795_f += limbSwingAmount * this.distance(model.field_78795_f, x);
        model.field_78796_g += limbSwingAmount * this.distance(model.field_78796_g, y);
        model.field_78808_h += limbSwingAmount * this.distance(model.field_78808_h, z);
    }

    public void addToRotateAngle(AdvancedModelBox model, float limbSwingAmount, float x, float y, float z) {
        model.field_78795_f += Math.min(limbSwingAmount * 2.0f, 1.0f) * this.distance(model.defaultRotationX, x);
        model.field_78796_g += Math.min(limbSwingAmount * 2.0f, 1.0f) * this.distance(model.defaultRotationY, y);
        model.field_78808_h += Math.min(limbSwingAmount * 2.0f, 1.0f) * this.distance(model.defaultRotationZ, z);
    }

    public boolean isPartEqual(AdvancedModelBox original, AdvancedModelBox pose) {
        return pose != null && pose.field_78795_f == original.defaultRotationX && pose.field_78796_g == original.defaultRotationY && pose.field_78808_h == original.defaultRotationZ;
    }

    public boolean isPositionEqual(AdvancedModelBox original, AdvancedModelBox pose) {
        return pose.field_78800_c == original.defaultPositionX && pose.field_78797_d == original.defaultPositionY && pose.field_78798_e == original.defaultPositionZ;
    }

    public void transitionTo(AdvancedModelBox from, AdvancedModelBox to, float timer, float maxTime, boolean oldFashioned) {
        if (oldFashioned) {
            from.field_78795_f += (to.field_78795_f - from.field_78795_f) / maxTime * timer;
            from.field_78796_g += (to.field_78796_g - from.field_78796_g) / maxTime * timer;
            from.field_78808_h += (to.field_78808_h - from.field_78808_h) / maxTime * timer;
        } else {
            this.transitionAngles(from, to, timer, maxTime);
        }
        from.field_78800_c += (to.field_78800_c - from.field_78800_c) / maxTime * timer;
        from.field_78797_d += (to.field_78797_d - from.field_78797_d) / maxTime * timer;
        from.field_78798_e += (to.field_78798_e - from.field_78798_e) / maxTime * timer;
    }

    public void transitionAngles(AdvancedModelBox from, AdvancedModelBox to, float timer, float maxTime) {
        from.field_78795_f += this.distance(from.field_78795_f, to.field_78795_f) / maxTime * timer;
        from.field_78796_g += this.distance(from.field_78796_g, to.field_78796_g) / maxTime * timer;
        from.field_78808_h += this.distance(from.field_78808_h, to.field_78808_h) / maxTime * timer;
    }

    public float distance(float rotateAngleFrom, float rotateAngleTo) {
        return (float)IAFMath.atan2_accurate(MathHelper.func_76126_a((float)(rotateAngleTo - rotateAngleFrom)), MathHelper.func_76134_b((float)(rotateAngleTo - rotateAngleFrom)));
    }

    public void rotate(ModelAnimator animator, AdvancedModelBox model, float x, float y, float z) {
        animator.rotate(model, (float)Math.toRadians(x), (float)Math.toRadians(y), (float)Math.toRadians(z));
    }

    public void moveToPose(TabulaModel model, TabulaModel modelTo) {
        for (AdvancedModelBox cube : model.getCubes().values()) {
            float toZ;
            float toY;
            float toX;
            if (!this.isPartEqual(this.baseModel.getCube(cube.boxName), modelTo.getCube(cube.boxName))) {
                toX = modelTo.getCube((String)cube.boxName).field_78795_f;
                toY = modelTo.getCube((String)cube.boxName).field_78796_g;
                toZ = modelTo.getCube((String)cube.boxName).field_78808_h;
                model.llibAnimator.rotate(cube, this.distance(cube.field_78795_f, toX), this.distance(cube.field_78796_g, toY), this.distance(cube.field_78808_h, toZ));
            }
            if (this.isPositionEqual(this.baseModel.getCube(cube.boxName), modelTo.getCube(cube.boxName))) continue;
            toX = modelTo.getCube((String)cube.boxName).field_78800_c;
            toY = modelTo.getCube((String)cube.boxName).field_78797_d;
            toZ = modelTo.getCube((String)cube.boxName).field_78798_e;
            model.llibAnimator.move(cube, this.distance(cube.field_78800_c, toX), this.distance(cube.field_78797_d, toY), this.distance(cube.field_78798_e, toZ));
        }
    }
}

