/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.model.util;

import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class LegSolver {
    public final Leg[] legs;

    public LegSolver(Leg ... legs) {
        this.legs = legs;
    }

    public final void update(EntityDragonBase entity, float scale) {
        this.update(entity, entity.field_70761_aq, scale);
    }

    public final void update(EntityDragonBase entity, float yaw, float scale) {
        double sideTheta = (double)yaw / 57.29577951308232;
        double sideX = Math.cos(sideTheta) * (double)scale;
        double sideZ = Math.sin(sideTheta) * (double)scale;
        double forwardTheta = sideTheta + 1.5707963267948966;
        double forwardX = Math.cos(forwardTheta) * (double)scale;
        double forwardZ = Math.sin(forwardTheta) * (double)scale;
        for (Leg leg : this.legs) {
            leg.update(entity, sideX, sideZ, forwardX, forwardZ, scale);
        }
    }

    public static final class Leg {
        public final float forward;
        public final float side;
        private final float range;
        private float height;
        private float prevHeight;
        private boolean isWing;

        public Leg(float forward, float side, float range, boolean isWing) {
            this.forward = forward;
            this.side = side;
            this.range = range;
            this.isWing = isWing;
        }

        public final float getHeight(float delta) {
            return this.prevHeight + (this.height - this.prevHeight) * delta;
        }

        public void update(EntityDragonBase entity, double sideX, double sideZ, double forwardX, double forwardZ, float scale) {
            this.prevHeight = this.height;
            double posY = entity.func_226278_cu_();
            float settledHeight = this.settle(entity, entity.func_226277_ct_() + sideX * (double)this.side + forwardX * (double)this.forward, posY, entity.func_226281_cx_() + sideZ * (double)this.side + forwardZ * (double)this.forward, this.height);
            this.height = MathHelper.func_76131_a((float)settledHeight, (float)(-this.range * scale), (float)(this.range * scale));
        }

        private float settle(EntityDragonBase entity, double x, double y, double z, float height) {
            BlockPos pos = new BlockPos(x, y + 0.001, z);
            float dist = this.getDistance(entity.field_70170_p, pos);
            dist = (double)(1.0f - dist) < 0.001 ? this.getDistance(entity.field_70170_p, pos.func_177977_b()) + (float)y % 1.0f : (float)((double)dist - (1.0 - y % 1.0));
            if (entity.field_70122_E && height <= dist) {
                return height == dist ? height : Math.min(height + this.getFallSpeed(), dist);
            }
            if (height > 0.0f) {
                return Math.max(height - this.getRiseSpeed(), dist);
            }
            return height;
        }

        private float getDistance(World world, BlockPos pos) {
            BlockState state = world.func_180495_p(pos);
            VoxelShape aabb = state.func_196952_d((IBlockReader)world, pos);
            return aabb.func_197766_b() ? 1.0f : 1.0f - Math.min((float)aabb.func_197760_b(Direction.Axis.Y, 0.5, 0.5), 1.0f);
        }

        protected float getFallSpeed() {
            return 0.25f;
        }

        protected float getRiseSpeed() {
            return 0.25f;
        }
    }
}

