/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.particle;

import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ParticleDragonFlame
extends SpriteTexturedParticle {
    private static final ResourceLocation DRAGONFLAME = new ResourceLocation("iceandfire:textures/particles/dragon_flame.png");
    private float dragonSize;
    private double initialX;
    private double initialY;
    private double initialZ;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int touchedTime = 0;
    private float speedBonus;
    @Nullable
    private EntityDragonBase dragon;

    @OnlyIn(value=Dist.CLIENT)
    public ParticleDragonFlame(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, float dragonSize) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
        this.initialX = xCoordIn;
        this.initialY = yCoordIn;
        this.initialZ = zCoordIn;
        this.targetX = xCoordIn + (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 1.75f * dragonSize);
        this.targetY = yCoordIn + (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 1.75f * dragonSize);
        this.targetZ = zCoordIn + (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 1.75f * dragonSize);
        this.func_187109_b(this.field_187126_f, this.field_187127_g, this.field_187128_h);
        this.dragonSize = dragonSize;
        this.speedBonus = this.field_187136_p.nextFloat() * 0.015f;
    }

    public ParticleDragonFlame(World world, double x, double y, double z, double motX, double motY, double motZ, EntityDragonBase entityDragonBase, int startingAge) {
        this(world, x, y, z, motX, motY, motZ, MathHelper.func_76131_a((float)(entityDragonBase.getRenderSize() * 0.08f), (float)0.55f, (float)3.0f));
        this.dragon = entityDragonBase;
        this.targetX = this.dragon.burnParticleX + (double)(this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 3.5;
        this.targetY = this.dragon.burnParticleY + (double)(this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 3.5;
        this.targetZ = this.dragon.burnParticleZ + (double)(this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 3.5;
        this.field_187126_f = x;
        this.field_187127_g = y;
        this.field_187128_h = z;
        this.field_70546_d = startingAge;
    }

    public int func_206254_h() {
        return this.dragon == null ? 10 : 30;
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        Quaternion quaternion;
        Vec3d inerp = renderInfo.func_216785_c();
        if (this.field_70546_d > this.func_206254_h()) {
            this.func_187112_i();
        }
        Vec3d vec3d = renderInfo.func_216785_c();
        float f = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187123_c, (double)this.field_187126_f) - vec3d.func_82615_a());
        float f1 = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187124_d, (double)this.field_187127_g) - vec3d.func_82617_b());
        float f2 = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187125_e, (double)this.field_187128_h) - vec3d.func_82616_c());
        if (this.field_190014_F == 0.0f) {
            quaternion = renderInfo.func_227995_f_();
        } else {
            quaternion = new Quaternion(renderInfo.func_227995_f_());
            float f3 = MathHelper.func_219799_g((float)partialTicks, (float)this.field_190015_G, (float)this.field_190014_F);
            quaternion.func_195890_a(Vector3f.field_229183_f_.func_229193_c_(f3));
        }
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1.func_214905_a(quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.func_217561_b(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.func_214905_a(quaternion);
            vector3f.func_195898_a(f4);
            vector3f.func_195904_b(f, f1, f2);
        }
        float f7 = 0.0f;
        float f8 = 1.0f;
        float f5 = 0.0f;
        float f6 = 1.0f;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(DRAGONFLAME);
        int j = this.func_189214_a(partialTicks);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
        vertexbuffer.func_225582_a_((double)avector3f[0].func_195899_a(), (double)avector3f[0].func_195900_b(), (double)avector3f[0].func_195902_c()).func_225583_a_(f8, f6).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
        vertexbuffer.func_225582_a_((double)avector3f[1].func_195899_a(), (double)avector3f[1].func_195900_b(), (double)avector3f[1].func_195902_c()).func_225583_a_(f8, f5).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
        vertexbuffer.func_225582_a_((double)avector3f[2].func_195899_a(), (double)avector3f[2].func_195900_b(), (double)avector3f[2].func_195902_c()).func_225583_a_(f7, f5).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
        vertexbuffer.func_225582_a_((double)avector3f[3].func_195899_a(), (double)avector3f[3].func_195900_b(), (double)avector3f[3].func_195902_c()).func_225583_a_(f7, f6).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public int func_189214_a(float partialTick) {
        return 240;
    }

    public void func_189213_a() {
        super.func_189213_a();
        if (this.dragon == null) {
            float distX = (float)(this.initialX - this.field_187126_f);
            float distZ = (float)(this.initialZ - this.field_187128_h);
            this.field_187129_i += (double)(distX * -0.01f * this.dragonSize * this.field_187136_p.nextFloat());
            this.field_187131_k += (double)(distZ * -0.01f * this.dragonSize * this.field_187136_p.nextFloat());
            this.field_187130_j += (double)(0.015f * this.field_187136_p.nextFloat());
        } else {
            double d2 = this.targetX - this.initialX;
            double d3 = this.targetY - this.initialY;
            double d4 = this.targetZ - this.initialZ;
            double dist = MathHelper.func_76133_a((double)(d2 * d2 + d3 * d3 + d4 * d4));
            float speed = 0.015f + this.speedBonus;
            this.field_187129_i += d2 * (double)speed;
            this.field_187130_j += d3 * (double)speed;
            this.field_187131_k += d4 * (double)speed;
            if (this.touchedTime > 3) {
                this.func_187112_i();
            }
        }
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217605_e;
    }
}

