/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.github.alexthe666.iceandfire.client.render.entity.layer.LayerDragonArmor;
import com.github.alexthe666.iceandfire.client.render.entity.layer.LayerDragonBanner;
import com.github.alexthe666.iceandfire.client.render.entity.layer.LayerDragonEyes;
import com.github.alexthe666.iceandfire.client.render.entity.layer.LayerDragonRider;
import com.github.alexthe666.iceandfire.client.texture.ArrayLayeredTexture;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.enums.EnumDragonTextures;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderDragonBase
extends MobRenderer<EntityDragonBase, SegmentedModel<EntityDragonBase>> {
    private Map<String, ResourceLocation> LAYERED_TEXTURE_CACHE = Maps.newHashMap();
    private int dragonType;

    public RenderDragonBase(EntityRendererManager manager, SegmentedModel model, int dragonType) {
        super(manager, (EntityModel)model, 0.15f);
        this.func_177094_a(new LayerDragonEyes(this));
        this.func_177094_a(new LayerDragonRider(this, false));
        this.func_177094_a(new LayerDragonBanner(this));
        this.func_177094_a(new LayerDragonArmor(this, dragonType));
        this.dragonType = dragonType;
    }

    private Vec3d getPosition(LivingEntity LivingEntityIn, double p_177110_2_, float p_177110_4_) {
        double d0 = LivingEntityIn.field_70142_S + (LivingEntityIn.func_226277_ct_() - LivingEntityIn.field_70142_S) * (double)p_177110_4_;
        double d1 = p_177110_2_ + LivingEntityIn.field_70137_T + (LivingEntityIn.func_226278_cu_() - LivingEntityIn.field_70137_T) * (double)p_177110_4_;
        double d2 = LivingEntityIn.field_70136_U + (LivingEntityIn.func_226281_cx_() - LivingEntityIn.field_70136_U) * (double)p_177110_4_;
        return new Vec3d(d0, d1, d2);
    }

    protected void preRenderCallback(EntityDragonBase entity, MatrixStack matrixStackIn, float partialTickTime) {
        this.field_76989_e = entity.getRenderSize() / 3.0f;
        matrixStackIn.func_227862_a_(this.field_76989_e, this.field_76989_e, this.field_76989_e);
        float f7 = entity.prevDragonPitch + (entity.getDragonPitch() - entity.prevDragonPitch) * partialTickTime;
        matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, f7, true));
    }

    public ResourceLocation getEntityTexture(EntityDragonBase entity) {
        String baseTexture = entity.getVariantName(entity.getVariant()) + entity.getDragonStage() + entity.isModelDead() + entity.isMale() + entity.isSkeletal() + entity.func_70608_bn() + entity.isBlinking();
        ResourceLocation resourcelocation = this.LAYERED_TEXTURE_CACHE.get(baseTexture);
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation("iceandfire:dragon_texture_" + baseTexture);
            ArrayList<String> tex = new ArrayList<String>();
            tex.add(EnumDragonTextures.getTextureFromDragon(entity).toString());
            if (entity.isMale() && !entity.isSkeletal()) {
                if (this.dragonType == 0) {
                    tex.add(EnumDragonTextures.getDragonEnum((EntityDragonBase)entity).FIRE_MALE_OVERLAY.toString());
                } else if (this.dragonType == 1) {
                    tex.add(EnumDragonTextures.getDragonEnum((EntityDragonBase)entity).ICE_MALE_OVERLAY.toString());
                } else if (this.dragonType == 2) {
                    tex.add(EnumDragonTextures.getDragonEnum((EntityDragonBase)entity).LIGHTNING_MALE_OVERLAY.toString());
                }
            } else {
                tex.add(EnumDragonTextures.Armor.EMPTY.FIRETEXTURE.toString());
            }
            ArrayLayeredTexture layeredBase = new ArrayLayeredTexture(tex);
            Minecraft.func_71410_x().func_110434_K().func_229263_a_(resourcelocation, (Texture)layeredBase);
            this.LAYERED_TEXTURE_CACHE.put(baseTexture, resourcelocation);
        }
        return resourcelocation;
    }

    private String simplifyBoolean(boolean bool) {
        return bool ? "1" : "0";
    }
}

