/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.github.alexthe666.iceandfire.client.particle.LightningBoltData;
import com.github.alexthe666.iceandfire.client.particle.LightningRender;
import com.github.alexthe666.iceandfire.client.render.entity.RenderDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityLightningDragon;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.culling.ClippingHelperImpl;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public class RenderLightningDragon
extends RenderDragonBase {
    private LightningRender lightningRender = new LightningRender();

    public RenderLightningDragon(EntityRendererManager manager, SegmentedModel model, int dragonType) {
        super(manager, model, dragonType);
    }

    public boolean shouldRender(EntityDragonBase livingEntityIn, ClippingHelperImpl camera, double camX, double camY, double camZ) {
        if (super.func_225626_a_((MobEntity)livingEntityIn, camera, camX, camY, camZ)) {
            return true;
        }
        EntityLightningDragon lightningDragon = (EntityLightningDragon)livingEntityIn;
        if (lightningDragon.hasLightningTarget()) {
            Vec3d vec3d1 = lightningDragon.getHeadPosition();
            Vec3d vec3d = new Vec3d((double)lightningDragon.getLightningTargetX(), (double)lightningDragon.getLightningTargetY(), (double)lightningDragon.getLightningTargetZ());
            return camera.func_228957_a_(new AxisAlignedBB(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c));
        }
        return false;
    }

    public void render(EntityDragonBase entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        double dist;
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        EntityLightningDragon lightningDragon = (EntityLightningDragon)entityIn;
        matrixStackIn.func_227860_a_();
        if (lightningDragon.hasLightningTarget() && (dist = (double)Minecraft.func_71410_x().field_71439_g.func_70032_d((Entity)lightningDragon)) <= (double)Math.max(256.0f, (float)Minecraft.func_71410_x().field_71474_y.field_151451_c * 16.0f)) {
            Vec3d vec3d1 = lightningDragon.getHeadPosition();
            Vec3d vec3d = new Vec3d((double)lightningDragon.getLightningTargetX(), (double)lightningDragon.getLightningTargetY(), (double)lightningDragon.getLightningTargetZ());
            float energyScale = 0.4f * lightningDragon.func_213355_cm();
            LightningBoltData bolt = new LightningBoltData(LightningBoltData.BoltRenderInfo.ELECTRICITY, vec3d1, vec3d, 15).size(0.05f * RenderLightningDragon.getBoundedScale(energyScale, 0.5f, 2.0f)).lifespan(4).spawn(LightningBoltData.SpawnFunction.NO_DELAY);
            this.lightningRender.update(null, bolt, partialTicks);
            matrixStackIn.func_227861_a_(-lightningDragon.func_226277_ct_(), -lightningDragon.func_226278_cu_(), -lightningDragon.func_226281_cx_());
            this.lightningRender.render(partialTicks, matrixStackIn, bufferIn);
        }
        matrixStackIn.func_227865_b_();
    }

    private static float getBoundedScale(float scale, float min, float max) {
        return min + scale * (max - min);
    }
}

