/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity.layer;

import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.iceandfire.client.model.ModelHydraBody;
import com.github.alexthe666.iceandfire.client.model.ModelHydraHead;
import com.github.alexthe666.iceandfire.client.render.entity.RenderHydra;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.github.alexthe666.iceandfire.entity.EntityHydra;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LayerHydraHead
extends LayerRenderer<EntityHydra, ModelHydraBody> {
    public static final ResourceLocation TEXTURE_STONE = new ResourceLocation("iceandfire:textures/models/hydra/stone.png");
    private static final float[][] TRANSLATE = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.15f, 0.15f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.3f, 0.0f, 0.3f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.4f, -0.1f, 0.1f, 0.4f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.5f, -0.2f, 0.0f, 0.2f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.7f, -0.4f, -0.2f, 0.2f, 0.4f, 0.7f, 0.0f, 0.0f, 0.0f}, {-0.7f, -0.4f, -0.2f, 0.0f, 0.2f, 0.4f, 0.7f, 0.0f, 0.0f}, {-0.6f, -0.4f, -0.2f, -0.1f, 0.1f, 0.2f, 0.4f, 0.6f, 0.0f}, {-0.6f, -0.4f, -0.2f, -0.1f, 0.0f, 0.1f, 0.2f, 0.4f, 0.6f}};
    private static final float[][] ROTATE = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {10.0f, -10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {10.0f, 0.0f, -10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {25.0f, 10.0f, -10.0f, -25.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {30.0f, 15.0f, 0.0f, -15.0f, -30.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {40.0f, 25.0f, 5.0f, -5.0f, -25.0f, -40.0f, 0.0f, 0.0f, 0.0f}, {40.0f, 30.0f, 15.0f, 0.0f, -15.0f, -30.0f, -40.0f, 0.0f, 0.0f}, {45.0f, 30.0f, 20.0f, 5.0f, -5.0f, -20.0f, -30.0f, -45.0f, 0.0f}, {50.0f, 37.0f, 25.0f, 15.0f, 0.0f, -15.0f, -25.0f, -37.0f, -50.0f}};
    private final RenderHydra renderer;
    private ModelHydraHead[] modelArr;

    public LayerHydraHead(RenderHydra renderer) {
        super((IEntityRenderer)renderer);
        this.renderer = renderer;
        this.modelArr = new ModelHydraHead[9];
        for (int i = 0; i < this.modelArr.length; ++i) {
            this.modelArr[i] = new ModelHydraHead(i);
        }
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, EntityHydra entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        int heads = entity.getHeadCount();
        boolean stone = EntityGorgon.isStoneMob((LivingEntity)entity);
        if (entity.func_82150_aj() && !stone) {
            return;
        }
        matrixStackIn.func_227860_a_();
        this.translateToBody(matrixStackIn);
        for (int head = 1; head <= heads; ++head) {
            matrixStackIn.func_227860_a_();
            float bodyWidth = 0.5f;
            matrixStackIn.func_227861_a_((double)(TRANSLATE[heads - 1][head - 1] * bodyWidth), 0.0, 0.0);
            matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, ROTATE[heads - 1][head - 1], true));
            ResourceLocation tex = stone ? TEXTURE_STONE : this.getEntityTexture(entity);
            this.modelArr[head - 1].setRotationAngles(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            this.modelArr[head - 1].func_225598_a_(matrixStackIn, bufferIn.getBuffer(RenderType.func_228638_b_((ResourceLocation)tex)), packedLightIn, LivingRenderer.func_229117_c_((LivingEntity)entity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStackIn.func_227865_b_();
        }
        matrixStackIn.func_227865_b_();
    }

    public ResourceLocation getEntityTexture(EntityHydra gorgon) {
        switch (gorgon.getVariant()) {
            default: {
                return RenderHydra.TEXUTURE_0;
            }
            case 1: {
                return RenderHydra.TEXUTURE_1;
            }
            case 2: 
        }
        return RenderHydra.TEXUTURE_2;
    }

    protected void translateToBody(MatrixStack stack) {
        this.postRender(((ModelHydraBody)this.renderer.func_217764_d()).BodyUpper, stack, 0.0625f);
    }

    protected void postRender(AdvancedModelBox renderer, MatrixStack matrixStackIn, float scale) {
        if (renderer.field_78795_f == 0.0f && renderer.field_78796_g == 0.0f && renderer.field_78808_h == 0.0f) {
            if (renderer.field_78800_c != 0.0f || renderer.field_78797_d != 0.0f || renderer.field_78798_e != 0.0f) {
                matrixStackIn.func_227861_a_((double)(renderer.field_78800_c * scale), (double)(renderer.field_78797_d * scale), (double)(renderer.field_78798_e * scale));
            }
        } else {
            matrixStackIn.func_227861_a_((double)(renderer.field_78800_c * scale), (double)(renderer.field_78797_d * scale), (double)(renderer.field_78798_e * scale));
            if (renderer.field_78808_h != 0.0f) {
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(renderer.field_78808_h));
            }
            if (renderer.field_78796_g != 0.0f) {
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(renderer.field_78796_g));
            }
            if (renderer.field_78795_f != 0.0f) {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(renderer.field_78795_f));
            }
        }
    }
}

