/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.tile;

import com.github.alexthe666.iceandfire.client.model.ModelPixie;
import com.github.alexthe666.iceandfire.client.render.entity.RenderPixie;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityJar;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;

public class RenderJar<T extends TileEntityJar>
extends TileEntityRenderer<T> {
    public static final RenderType TEXTURE_0 = RenderType.func_230167_a_((ResourceLocation)RenderPixie.TEXTURE_0, (boolean)false);
    public static final RenderType TEXTURE_1 = RenderType.func_230167_a_((ResourceLocation)RenderPixie.TEXTURE_1, (boolean)false);
    public static final RenderType TEXTURE_2 = RenderType.func_230167_a_((ResourceLocation)RenderPixie.TEXTURE_2, (boolean)false);
    public static final RenderType TEXTURE_3 = RenderType.func_230167_a_((ResourceLocation)RenderPixie.TEXTURE_3, (boolean)false);
    public static final RenderType TEXTURE_4 = RenderType.func_230167_a_((ResourceLocation)RenderPixie.TEXTURE_4, (boolean)false);
    public static final RenderType TEXTURE_5 = RenderType.func_230167_a_((ResourceLocation)RenderPixie.TEXTURE_5, (boolean)false);
    public static final RenderType TEXTURE_0_GLO = RenderType.func_228652_i_((ResourceLocation)RenderPixie.TEXTURE_0);
    public static final RenderType TEXTURE_1_GLO = RenderType.func_228652_i_((ResourceLocation)RenderPixie.TEXTURE_1);
    public static final RenderType TEXTURE_2_GLO = RenderType.func_228652_i_((ResourceLocation)RenderPixie.TEXTURE_2);
    public static final RenderType TEXTURE_3_GLO = RenderType.func_228652_i_((ResourceLocation)RenderPixie.TEXTURE_3);
    public static final RenderType TEXTURE_4_GLO = RenderType.func_228652_i_((ResourceLocation)RenderPixie.TEXTURE_4);
    public static final RenderType TEXTURE_5_GLO = RenderType.func_228652_i_((ResourceLocation)RenderPixie.TEXTURE_5);
    private static ModelPixie MODEL_PIXIE;

    public RenderJar(TileEntityRendererDispatcher p_i226016_1_) {
        super(p_i226016_1_);
    }

    public void render(T entity, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        int meta = 0;
        boolean hasPixie = false;
        if (MODEL_PIXIE == null) {
            MODEL_PIXIE = new ModelPixie();
        }
        if (entity != null && entity.func_145831_w() != null) {
            meta = ((TileEntityJar)((Object)entity)).pixieType;
            hasPixie = ((TileEntityJar)((Object)entity)).hasPixie;
        }
        if (hasPixie) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.5, (double)1.501f, 0.5);
            matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, 180.0f, true));
            matrixStackIn.func_227860_a_();
            RenderType type = TEXTURE_0;
            RenderType typeGlow = TEXTURE_0_GLO;
            switch (meta) {
                default: {
                    type = TEXTURE_0;
                    typeGlow = TEXTURE_0_GLO;
                    break;
                }
                case 1: {
                    type = TEXTURE_1;
                    typeGlow = TEXTURE_1_GLO;
                    break;
                }
                case 2: {
                    type = TEXTURE_2;
                    typeGlow = TEXTURE_2_GLO;
                    break;
                }
                case 3: {
                    type = TEXTURE_3;
                    typeGlow = TEXTURE_3_GLO;
                    break;
                }
                case 4: {
                    type = TEXTURE_4;
                    typeGlow = TEXTURE_4_GLO;
                }
            }
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(type);
            if (entity != null && entity.func_145831_w() != null) {
                if (((TileEntityJar)((Object)entity)).hasProduced) {
                    matrixStackIn.func_227861_a_(0.0, (double)0.9f, 0.0);
                } else {
                    matrixStackIn.func_227861_a_(0.0, (double)0.6f, 0.0);
                }
                matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, this.interpolateRotation(((TileEntityJar)((Object)entity)).prevRotationYaw, ((TileEntityJar)((Object)entity)).rotationYaw, partialTicks), true));
                matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
                MODEL_PIXIE.animateInJar(((TileEntityJar)((Object)entity)).hasProduced, (TileEntityJar)((Object)entity), 0.0f);
                MODEL_PIXIE.func_225598_a_(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
                MODEL_PIXIE.func_225598_a_(matrixStackIn, bufferIn.getBuffer(typeGlow), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            matrixStackIn.func_227865_b_();
            matrixStackIn.func_227865_b_();
        }
    }

    protected float interpolateRotation(float prevYawOffset, float yawOffset, float partialTicks) {
        float f;
        for (f = yawOffset - prevYawOffset; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return prevYawOffset + partialTicks * f;
    }
}

