/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.tile;

import com.github.alexthe666.iceandfire.block.BlockPixieHouse;
import com.github.alexthe666.iceandfire.client.model.ModelPixie;
import com.github.alexthe666.iceandfire.client.model.ModelPixieHouse;
import com.github.alexthe666.iceandfire.client.render.tile.RenderJar;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityPixieHouse;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class RenderPixieHouse<T extends TileEntityPixieHouse>
extends TileEntityRenderer<T> {
    private static final ModelPixieHouse MODEL = new ModelPixieHouse();
    private static ModelPixie MODEL_PIXIE;
    private static final RenderType TEXTURE_0;
    private static final RenderType TEXTURE_1;
    private static final RenderType TEXTURE_2;
    private static final RenderType TEXTURE_3;
    private static final RenderType TEXTURE_4;
    private static final RenderType TEXTURE_5;
    public BlockItem metaOverride;

    public RenderPixieHouse(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(T entity, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        int rotation = 0;
        int meta = 0;
        if (MODEL_PIXIE == null) {
            MODEL_PIXIE = new ModelPixie();
        }
        if (entity != null && entity.func_145831_w() != null && entity.func_145831_w().func_180495_p(entity.func_174877_v()).func_177230_c() instanceof BlockPixieHouse) {
            meta = TileEntityPixieHouse.getHouseTypeFromBlock(entity.func_145831_w().func_180495_p(entity.func_174877_v()).func_177230_c());
            if (entity.func_145831_w().func_180495_p(entity.func_174877_v()).func_177229_b((IProperty)BlockPixieHouse.FACING) == Direction.NORTH) {
                rotation = 180;
            }
            if (entity.func_145831_w().func_180495_p(entity.func_174877_v()).func_177229_b((IProperty)BlockPixieHouse.FACING) == Direction.EAST) {
                rotation = -90;
            }
            if (entity.func_145831_w().func_180495_p(entity.func_174877_v()).func_177229_b((IProperty)BlockPixieHouse.FACING) == Direction.WEST) {
                rotation = 90;
            }
        }
        if (entity == null) {
            meta = TileEntityPixieHouse.getHouseTypeFromBlock(this.metaOverride.func_179223_d());
        }
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, (double)1.501f, 0.5);
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)rotation));
        if (entity != null && entity.func_145831_w() != null && ((TileEntityPixieHouse)((Object)entity)).hasPixie) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, (double)0.95f, 0.0);
            matrixStackIn.func_227862_a_(0.55f, 0.55f, 0.55f);
            matrixStackIn.func_227860_a_();
            RenderType type = RenderJar.TEXTURE_0;
            RenderType type2 = RenderJar.TEXTURE_0_GLO;
            switch (((TileEntityPixieHouse)((Object)entity)).pixieType) {
                default: {
                    type = RenderJar.TEXTURE_0;
                    type2 = RenderJar.TEXTURE_0_GLO;
                    break;
                }
                case 1: {
                    type = RenderJar.TEXTURE_1;
                    type2 = RenderJar.TEXTURE_1_GLO;
                    break;
                }
                case 2: {
                    type = RenderJar.TEXTURE_2;
                    type2 = RenderJar.TEXTURE_2_GLO;
                    break;
                }
                case 3: {
                    type = RenderJar.TEXTURE_3;
                    type2 = RenderJar.TEXTURE_3_GLO;
                    break;
                }
                case 4: {
                    type = RenderJar.TEXTURE_4;
                    type2 = RenderJar.TEXTURE_4_GLO;
                    break;
                }
                case 5: {
                    type = RenderJar.TEXTURE_5;
                    type2 = RenderJar.TEXTURE_5_GLO;
                }
            }
            matrixStackIn.func_227860_a_();
            MODEL_PIXIE.animateInHouse((TileEntityPixieHouse)((Object)entity));
            MODEL_PIXIE.func_225598_a_(matrixStackIn, bufferIn.getBuffer(type), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
            MODEL_PIXIE.func_225598_a_(matrixStackIn, bufferIn.getBuffer(type2), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStackIn.func_227865_b_();
            matrixStackIn.func_227865_b_();
            matrixStackIn.func_227865_b_();
        }
        RenderType pixieType = TEXTURE_0;
        switch (meta) {
            case 0: {
                pixieType = TEXTURE_0;
                break;
            }
            case 1: {
                pixieType = TEXTURE_1;
                break;
            }
            case 2: {
                pixieType = TEXTURE_2;
                break;
            }
            case 3: {
                pixieType = TEXTURE_3;
                break;
            }
            case 4: {
                pixieType = TEXTURE_4;
                break;
            }
            case 5: {
                pixieType = TEXTURE_5;
            }
        }
        matrixStackIn.func_227860_a_();
        MODEL.func_225598_a_(matrixStackIn, bufferIn.getBuffer(pixieType), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227865_b_();
    }

    static {
        TEXTURE_0 = RenderType.func_230167_a_((ResourceLocation)new ResourceLocation("iceandfire:textures/models/pixie/house/pixie_house_0.png"), (boolean)false);
        TEXTURE_1 = RenderType.func_230167_a_((ResourceLocation)new ResourceLocation("iceandfire:textures/models/pixie/house/pixie_house_1.png"), (boolean)false);
        TEXTURE_2 = RenderType.func_230167_a_((ResourceLocation)new ResourceLocation("iceandfire:textures/models/pixie/house/pixie_house_2.png"), (boolean)false);
        TEXTURE_3 = RenderType.func_230167_a_((ResourceLocation)new ResourceLocation("iceandfire:textures/models/pixie/house/pixie_house_3.png"), (boolean)false);
        TEXTURE_4 = RenderType.func_230167_a_((ResourceLocation)new ResourceLocation("iceandfire:textures/models/pixie/house/pixie_house_4.png"), (boolean)false);
        TEXTURE_5 = RenderType.func_230167_a_((ResourceLocation)new ResourceLocation("iceandfire:textures/models/pixie/house/pixie_house_5.png"), (boolean)false);
    }
}

