/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.MinecraftForgeClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ArrayLayeredTexture
extends Texture {
    private static final Logger LOGGER = LogManager.getLogger();
    public final List<String> layeredTextureNames;

    public ArrayLayeredTexture(List<String> textureNames) {
        this.layeredTextureNames = textureNames;
    }

    public void func_195413_a(IResourceManager manager) {
        Iterator<String> iterator = this.layeredTextureNames.iterator();
        String s = iterator.next();
        try (IResource iresource = manager.func_199002_a(new ResourceLocation(s));){
            NativeImage nativeimage = MinecraftForgeClient.getImageLayer((ResourceLocation)new ResourceLocation(s), (IResourceManager)manager);
            while (iterator.hasNext()) {
                String s1 = iterator.next();
                if (s1 == null) continue;
                IResource iresource1 = manager.func_199002_a(new ResourceLocation(s1));
                Throwable throwable = null;
                try {
                    NativeImage nativeimage1 = NativeImage.func_195713_a((InputStream)iresource1.func_199027_b());
                    Throwable throwable2 = null;
                    try {
                        for (int i = 0; i < Math.min(nativeimage1.func_195714_b(), nativeimage.func_195714_b()); ++i) {
                            for (int j = 0; j < Math.min(nativeimage1.func_195702_a(), nativeimage.func_195702_a()); ++j) {
                                nativeimage.func_195718_b(j, i, nativeimage1.func_195709_a(j, i));
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (nativeimage1 == null) continue;
                        if (throwable2 != null) {
                            try {
                                nativeimage1.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        nativeimage1.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (iresource1 == null) continue;
                    if (throwable != null) {
                        try {
                            iresource1.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    iresource1.close();
                }
            }
            if (!RenderSystem.isOnRenderThreadOrInit()) {
                RenderSystem.recordRenderCall(() -> this.loadImage(nativeimage));
            } else {
                this.loadImage(nativeimage);
            }
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't load layered image", (Throwable)ioexception);
        }
    }

    private void loadImage(NativeImage imageIn) {
        TextureUtil.func_225680_a_((int)this.func_110552_b(), (int)imageIn.func_195702_a(), (int)imageIn.func_195714_b());
        imageIn.func_195697_a(0, 0, 0, true);
    }
}

