/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.IafDragonDestructionManager;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.util.IDragonProjectile;
import com.github.alexthe666.iceandfire.misc.IafDamageRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.projectile.AbstractFireballEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityDragonFireCharge
extends AbstractFireballEntity
implements IDragonProjectile {
    public int field_70234_an;

    public EntityDragonFireCharge(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    public EntityDragonFireCharge(FMLPlayMessages.SpawnEntity spawnEntity, World worldIn) {
        this(IafEntityRegistry.FIRE_DRAGON_CHARGE, worldIn);
    }

    public EntityDragonFireCharge(EntityType type, World worldIn, double posX, double posY, double posZ, double accelX, double accelY, double accelZ) {
        super(type, posX, posY, posZ, accelX, accelY, accelZ, worldIn);
        double d0 = MathHelper.func_76133_a((double)(accelX * accelX + accelY * accelY + accelZ * accelZ));
        this.field_70232_b = accelX / d0 * 0.07;
        this.field_70233_c = accelY / d0 * 0.07;
        this.field_70230_d = accelZ / d0 * 0.07;
    }

    public EntityDragonFireCharge(EntityType type, World worldIn, EntityDragonBase shooter, double accelX, double accelY, double accelZ) {
        super(type, (LivingEntity)shooter, accelX, accelY, accelZ, worldIn);
        double d0 = MathHelper.func_76133_a((double)(accelX * accelX + accelY * accelY + accelZ * accelZ));
        this.field_70232_b = accelX / d0 * 0.07;
        this.field_70233_c = accelY / d0 * 0.07;
        this.field_70230_d = accelZ / d0 * 0.07;
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70071_h_() {
        for (int i = 0; i < 4; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
        }
        if (this.func_70090_H()) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K || (this.field_70235_a == null || this.field_70235_a.func_70089_S()) && this.field_70170_p.func_175667_e(new BlockPos((Entity)this))) {
            super.func_70071_h_();
            if (this.func_184564_k()) {
                this.func_70015_d(1);
            }
            ++this.field_70234_an;
            Vec3d vec3d = this.func_213322_ci();
            RayTraceResult raytraceresult = ProjectileHelper.func_221267_a((Entity)this, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(vec3d).func_186662_g(1.0), p_213879_1_ -> !p_213879_1_.func_175149_v() && p_213879_1_ != this.field_70235_a, (RayTraceContext.BlockMode)RayTraceContext.BlockMode.OUTLINE, (boolean)true);
            if (raytraceresult != null) {
                this.func_70227_a(raytraceresult);
            }
            double d0 = this.func_226277_ct_() + vec3d.field_72450_a;
            double d1 = this.func_226278_cu_() + vec3d.field_72448_b;
            double d2 = this.func_226281_cx_() + vec3d.field_72449_c;
            float f = MathHelper.func_76133_a((double)EntityDragonFireCharge.func_213296_b((Vec3d)vec3d));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
            this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
            float f1 = 0.99f;
            float f2 = 0.06f;
            if (this.func_70090_H()) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() - this.func_213322_ci().field_72450_a * 0.25, this.func_226278_cu_() - this.func_213322_ci().field_72448_b * 0.25, this.func_226281_cx_() - this.func_213322_ci().field_72449_c * 0.25, this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c);
                }
                f = 0.8f;
            }
            this.func_70107_b(d0, d1, d2);
            this.field_70170_p.func_195594_a(this.func_195057_f(), this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), 0.0, 0.0, 0.0);
            this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        } else {
            this.func_70106_y();
        }
    }

    protected void func_70227_a(RayTraceResult movingObject) {
        boolean flag = this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b);
        if (!this.field_70170_p.field_72995_K && movingObject.func_216346_c() == RayTraceResult.Type.ENTITY) {
            EntityDragonBase dragon;
            Entity entity = ((EntityRayTraceResult)movingObject).func_216348_a();
            if (entity != null && entity instanceof IDragonProjectile) {
                return;
            }
            if (entity != null && this.field_70235_a != null && this.field_70235_a instanceof EntityDragonBase && entity != null && ((dragon = (EntityDragonBase)this.field_70235_a).func_184191_r(entity) || dragon.func_70028_i(entity) || dragon.isPart(entity))) {
                return;
            }
            if (entity == null || !(entity instanceof IDragonProjectile) && entity != this.field_70235_a && this.field_70235_a instanceof EntityDragonBase) {
                dragon = (EntityDragonBase)this.field_70235_a;
                if (this.field_70235_a != null && (entity == this.field_70235_a || entity instanceof TameableEntity && ((EntityDragonBase)this.field_70235_a).func_152114_e(((EntityDragonBase)this.field_70235_a).func_70902_q()))) {
                    return;
                }
                if (dragon != null) {
                    dragon.randomizeAttacks();
                }
                this.func_70106_y();
            }
            if (entity != null && !(entity instanceof IDragonProjectile) && !entity.func_70028_i((Entity)this.field_70235_a)) {
                if (this.field_70235_a != null && (entity.func_70028_i((Entity)this.field_70235_a) || this.field_70235_a instanceof EntityDragonBase & entity instanceof TameableEntity && ((EntityDragonBase)this.field_70235_a).func_70902_q() == ((TameableEntity)entity).func_70902_q())) {
                    return;
                }
                if (this.field_70235_a != null && this.field_70235_a instanceof EntityDragonBase) {
                    entity.func_70097_a(IafDamageRegistry.DRAGON_FIRE, 10.0f);
                    if (entity instanceof LivingEntity && ((LivingEntity)entity).func_110143_aJ() == 0.0f) {
                        ((EntityDragonBase)this.field_70235_a).randomizeAttacks();
                    }
                }
                entity.func_70015_d(5);
                this.func_174815_a(this.field_70235_a, entity);
                this.func_70106_y();
            }
        }
        if (movingObject.func_216346_c() != RayTraceResult.Type.MISS) {
            if (this.field_70235_a instanceof EntityDragonBase && IafConfig.dragonGriefing != 2) {
                IafDragonDestructionManager.destroyAreaFireCharge(this.field_70170_p, this.func_180425_c(), (EntityDragonBase)this.field_70235_a);
            }
            this.func_70106_y();
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

