/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.server.entity.EntityPropertiesHandler;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.client.IafKeybindRegistry;
import com.github.alexthe666.iceandfire.client.model.IFChainBuffer;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.IafDragonFlightManager;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIRide;
import com.github.alexthe666.iceandfire.entity.ai.HippogryphAIAirTarget;
import com.github.alexthe666.iceandfire.entity.ai.HippogryphAIMate;
import com.github.alexthe666.iceandfire.entity.ai.HippogryphAITarget;
import com.github.alexthe666.iceandfire.entity.ai.HippogryphAITargetItems;
import com.github.alexthe666.iceandfire.entity.ai.HippogryphAIWander;
import com.github.alexthe666.iceandfire.entity.props.StoneEntityProperties;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.util.IDragonFlute;
import com.github.alexthe666.iceandfire.entity.util.IDropArmor;
import com.github.alexthe666.iceandfire.entity.util.IFlyingMount;
import com.github.alexthe666.iceandfire.entity.util.ISyncMount;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.github.alexthe666.iceandfire.enums.EnumHippogryphTypes;
import com.github.alexthe666.iceandfire.inventory.ContainerHippogryph;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.message.MessageDragonControl;
import com.github.alexthe666.iceandfire.message.MessageHippogryphArmor;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.github.alexthe666.iceandfire.pathfinding.PathNavigateFlyingCreature;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityHippogryph
extends TameableEntity
implements ISyncMount,
IAnimatedEntity,
IDragonFlute,
IVillagerFear,
IAnimalFear,
IDropArmor,
IFlyingMount {
    private static final int FLIGHT_CHANCE_PER_TICK = 1200;
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityHippogryph.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SADDLE = EntityDataManager.func_187226_a(EntityHippogryph.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ARMOR = EntityDataManager.func_187226_a(EntityHippogryph.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> CHESTED = EntityDataManager.func_187226_a(EntityHippogryph.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HOVERING = EntityDataManager.func_187226_a(EntityHippogryph.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(EntityHippogryph.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> CONTROL_STATE = EntityDataManager.func_187226_a(EntityHippogryph.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> COMMAND = EntityDataManager.func_187226_a(EntityHippogryph.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static Animation ANIMATION_EAT;
    public static Animation ANIMATION_SPEAK;
    public static Animation ANIMATION_SCRATCH;
    public static Animation ANIMATION_BITE;
    public Inventory hippogryphInventory;
    @OnlyIn(value=Dist.CLIENT)
    public IFChainBuffer roll_buffer;
    public float sitProgress;
    public float hoverProgress;
    public float flyProgress;
    public int spacebarTicks;
    public BlockPos airTarget;
    public int airBorneCounter;
    public BlockPos homePos;
    public boolean hasHomePosition = false;
    public int feedings = 0;
    private boolean isSitting;
    private boolean isHovering;
    private boolean isFlying;
    private int animationTick;
    private Animation currentAnimation;
    private int flyTicks;
    private int hoverTicks;
    private boolean hasChestVarChanged = false;
    private int navigatorType = -1;
    private boolean isOverAir;

    public EntityHippogryph(EntityType type, World worldIn) {
        super(type, worldIn);
        ANIMATION_EAT = Animation.create((int)25);
        ANIMATION_SPEAK = Animation.create((int)15);
        ANIMATION_SCRATCH = Animation.create((int)25);
        ANIMATION_BITE = Animation.create((int)20);
        this.initHippogryphInv();
        if (worldIn.field_72995_K) {
            this.roll_buffer = new IFChainBuffer();
        }
        this.field_70138_W = 1.0f;
    }

    protected void switchNavigator() {
        if (this.func_184207_aI() && this.isOverAir() && this.navigatorType != 1) {
            this.field_70765_h = new IafDragonFlightManager.PlayerFlightMoveHelper<EntityHippogryph>(this);
            this.field_70699_by = new PathNavigateFlyingCreature((MobEntity)this, this.field_70170_p);
            this.navigatorType = 1;
        }
        if (!(this.func_184207_aI() && this.isOverAir() || this.navigatorType == 0)) {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new GroundPathNavigator((MobEntity)this, this.field_70170_p);
            this.navigatorType = 0;
        }
    }

    protected boolean isOverAir() {
        return this.isOverAir;
    }

    private boolean isOverAirLogic() {
        return this.field_70170_p.func_175623_d(new BlockPos(this.func_226277_ct_(), this.func_174813_aQ().field_72338_b - 1.0, this.func_226281_cx_()));
    }

    protected int func_70693_a(PlayerEntity player) {
        return 10;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, new DragonAIRide<EntityHippogryph>(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70911_d = new SitGoal((TameableEntity)this);
        this.field_70714_bg.func_75776_a(2, (Goal)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.5, true));
        this.field_70714_bg.func_75776_a(4, (Goal)new HippogryphAIMate(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new TemptGoal((CreatureEntity)this, 1.0, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_179558_bo, Items.field_179559_bp}), false));
        this.field_70714_bg.func_75776_a(6, (Goal)new HippogryphAIAirTarget(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new HippogryphAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, new HippogryphAITargetItems((MobEntity)this, false));
        this.field_70715_bh.func_75776_a(5, new HippogryphAITarget<LivingEntity>(this, LivingEntity.class, false, (Predicate<LivingEntity>)new com.google.common.base.Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity instanceof LivingEntity && !(entity instanceof AbstractHorseEntity) && DragonUtils.isAlive((LivingEntity)entity);
            }
        }));
        this.field_70715_bh.func_75776_a(5, new HippogryphAITarget<PlayerEntity>(this, PlayerEntity.class, 350, false, (Predicate<LivingEntity>)new com.google.common.base.Predicate<PlayerEntity>(){

            public boolean apply(@Nullable PlayerEntity entity) {
                return !entity.func_184812_l_();
            }
        }));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(ARMOR, (Object)0);
        this.field_70180_af.func_187214_a(SADDLE, (Object)false);
        this.field_70180_af.func_187214_a(CHESTED, (Object)false);
        this.field_70180_af.func_187214_a(HOVERING, (Object)false);
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
        this.field_70180_af.func_187214_a(CONTROL_STATE, (Object)0);
        this.field_70180_af.func_187214_a(COMMAND, (Object)0);
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean func_184186_bw() {
        return false;
    }

    public boolean func_82171_bF() {
        return true;
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger)) {
            this.field_70761_aq = this.field_70177_z;
            this.field_70177_z = passenger.field_70177_z;
        }
        passenger.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)1.05f, this.func_226281_cx_());
    }

    private void initHippogryphInv() {
        Inventory animalchest = this.hippogryphInventory;
        this.hippogryphInventory = new Inventory(18);
        if (animalchest != null) {
            int i = Math.min(animalchest.func_70302_i_(), this.hippogryphInventory.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = animalchest.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.hippogryphInventory.func_70299_a(j, itemstack.func_77946_l());
            }
            if (this.field_70170_p.field_72995_K) {
                ItemStack saddle = animalchest.func_70301_a(0);
                ItemStack chest = animalchest.func_70301_a(1);
                IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageHippogryphArmor(this.func_145782_y(), 0, saddle != null && saddle.func_77973_b() == Items.field_151141_av && !saddle.func_190926_b() ? 1 : 0));
                IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageHippogryphArmor(this.func_145782_y(), 1, chest != null && chest.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae) && !chest.func_190926_b() ? 1 : 0));
                IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageHippogryphArmor(this.func_145782_y(), 2, EntityHippogryph.getIntFromArmor(animalchest.func_70301_a(2))));
            }
        }
    }

    @Nullable
    public Entity func_184179_bs() {
        for (Entity passenger : this.func_184188_bt()) {
            if (!(passenger instanceof PlayerEntity) || this.func_70638_az() == passenger) continue;
            PlayerEntity player = (PlayerEntity)passenger;
            if (!this.func_70909_n() || this.func_184753_b() == null || !this.func_184753_b().equals(player.func_110124_au())) continue;
            return player;
        }
        return null;
    }

    public static int getIntFromArmor(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() != null && stack.func_77973_b() == IafItemRegistry.IRON_HIPPOGRYPH_ARMOR) {
            return 1;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() != null && stack.func_77973_b() == IafItemRegistry.GOLD_HIPPOGRYPH_ARMOR) {
            return 2;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() != null && stack.func_77973_b() == IafItemRegistry.DIAMOND_HIPPOGRYPH_ARMOR) {
            return 3;
        }
        return 0;
    }

    public boolean isBlinking() {
        return this.field_70173_aa % 50 > 43;
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        boolean isDev;
        ItemStack itemstack = player.func_184586_b(hand);
        String s = TextFormatting.func_110646_a((String)player.func_200200_C_().func_150261_e());
        boolean bl = isDev = s.equals("Alexthe666") || s.equals("Raptorfarian");
        if (this.func_70909_n() && this.func_152114_e((LivingEntity)player)) {
            if (itemstack != null && itemstack.func_77973_b() == Items.field_222078_li && this.getEnumVariant() != EnumHippogryphTypes.ALEX && isDev) {
                this.setEnumVariant(EnumHippogryphTypes.ALEX);
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                this.func_184185_a(SoundEvents.field_187945_hs, 1.0f, 1.0f);
                for (int i = 0; i < 20; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
                }
                return true;
            }
            if (itemstack != null && itemstack.func_77973_b() == Items.field_196122_bk && this.getEnumVariant() != EnumHippogryphTypes.RAPTOR && isDev) {
                this.setEnumVariant(EnumHippogryphTypes.RAPTOR);
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                this.func_184185_a(SoundEvents.field_187945_hs, 1.0f, 1.0f);
                for (int i = 0; i < 20; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
                }
                return true;
            }
            if (itemstack != null && itemstack.func_77973_b() == Items.field_179560_bq && this.func_70874_b() == 0 && !this.func_70880_s()) {
                this.func_146082_f(player);
                this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                return true;
            }
            if (itemstack != null && itemstack.func_77973_b() == Items.field_151055_y) {
                if (player.func_225608_bj_()) {
                    BlockPos pos;
                    if (this.hasHomePosition) {
                        this.hasHomePosition = false;
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("hippogryph.command.remove_home", new Object[0]), true);
                        return true;
                    }
                    this.homePos = pos = new BlockPos((Entity)this);
                    this.hasHomePosition = true;
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("hippogryph.command.new_home", new Object[]{this.homePos.func_177958_n(), this.homePos.func_177956_o(), this.homePos.func_177952_p()}), true);
                    return true;
                }
                this.setCommand(this.getCommand() + 1);
                if (this.getCommand() > 1) {
                    this.setCommand(0);
                }
                player.func_146105_b((ITextComponent)new TranslationTextComponent("hippogryph.command." + (this.getCommand() == 1 ? "sit" : "stand"), new Object[0]), true);
                return true;
            }
            if (itemstack != null && itemstack.func_77973_b() == Items.field_151060_bw && this.getEnumVariant() != EnumHippogryphTypes.DODO) {
                this.setEnumVariant(EnumHippogryphTypes.DODO);
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                this.func_184185_a(SoundEvents.field_187945_hs, 1.0f, 1.0f);
                for (int i = 0; i < 20; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197623_p, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
                }
                return true;
            }
            if (itemstack != null && itemstack.func_77973_b().func_219971_r() && itemstack.func_77973_b().func_219967_s() != null && itemstack.func_77973_b().func_219967_s().func_221467_c() && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70691_i(5.0f);
                this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                for (int i = 0; i < 3; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, itemstack), this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
                }
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                return true;
            }
            if (itemstack.func_190926_b()) {
                if (player.func_225608_bj_()) {
                    this.openGUI(player);
                    return true;
                }
                if (this.isSaddled() && !this.func_70631_g_() && !player.func_184218_aH()) {
                    player.func_184205_a((Entity)this, true);
                    return true;
                }
            }
        }
        return super.func_184645_a(player, hand);
    }

    public void openGUI(PlayerEntity playerEntity) {
        if (!(this.field_70170_p.field_72995_K || this.func_184207_aI() && !this.func_184196_w((Entity)playerEntity))) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerEntity), (INamedContainerProvider)new INamedContainerProvider(){

                public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
                    return new ContainerHippogryph(p_createMenu_1_, (IInventory)EntityHippogryph.this.hippogryphInventory, p_createMenu_2_, EntityHippogryph.this);
                }

                public ITextComponent func_145748_c_() {
                    return new TranslationTextComponent("entity.rats.rat", new Object[0]);
                }
            });
        }
        IceAndFire.PROXY.setReferencedMob((Entity)this);
    }

    @Override
    public boolean up() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) & 1) == 1;
    }

    @Override
    public boolean down() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 1 & 1) == 1;
    }

    public boolean attack() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 2 & 1) == 1;
    }

    public boolean dismount() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 3 & 1) == 1;
    }

    public void up(boolean up) {
        this.setStateField(0, up);
    }

    public void down(boolean down) {
        this.setStateField(1, down);
    }

    public void attack(boolean attack) {
        this.setStateField(2, attack);
    }

    public void dismount(boolean dismount) {
        this.setStateField(3, dismount);
    }

    private void setStateField(int i, boolean newState) {
        byte prevState = (Byte)this.field_70180_af.func_187225_a(CONTROL_STATE);
        if (newState) {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState | 1 << i)));
        } else {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState & ~(1 << i))));
        }
    }

    public byte getControlState() {
        return (Byte)this.field_70180_af.func_187225_a(CONTROL_STATE);
    }

    public void setControlState(byte state) {
        this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)state);
    }

    public int getCommand() {
        return (Integer)this.field_70180_af.func_187225_a(COMMAND);
    }

    public void setCommand(int command) {
        this.field_70180_af.func_187227_b(COMMAND, (Object)command);
        if (command == 1) {
            this.func_70904_g(true);
        } else {
            this.func_70904_g(false);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74757_a("Chested", this.isChested());
        compound.func_74757_a("Saddled", this.isSaddled());
        compound.func_74757_a("Hovering", this.isHovering());
        compound.func_74757_a("Flying", this.isFlying());
        compound.func_74768_a("Armor", this.getArmor());
        compound.func_74768_a("Feedings", this.feedings);
        if (this.hippogryphInventory != null) {
            ListNBT nbttaglist = new ListNBT();
            for (int i = 0; i < this.hippogryphInventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.hippogryphInventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                CompoundNBT CompoundNBT2 = new CompoundNBT();
                CompoundNBT2.func_74774_a("Slot", (byte)i);
                itemstack.func_77955_b(CompoundNBT2);
                nbttaglist.add((Object)CompoundNBT2);
            }
            compound.func_218657_a("Items", (INBT)nbttaglist);
        }
        compound.func_74757_a("HasHomePosition", this.hasHomePosition);
        if (this.homePos != null && this.hasHomePosition) {
            compound.func_74768_a("HomeAreaX", this.homePos.func_177958_n());
            compound.func_74768_a("HomeAreaY", this.homePos.func_177956_o());
            compound.func_74768_a("HomeAreaZ", this.homePos.func_177952_p());
        }
        compound.func_74768_a("Command", this.getCommand());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.setChested(compound.func_74767_n("Chested"));
        this.setSaddled(compound.func_74767_n("Saddled"));
        this.setHovering(compound.func_74767_n("Hovering"));
        this.setFlying(compound.func_74767_n("Flying"));
        this.setArmor(compound.func_74762_e("Armor"));
        this.feedings = compound.func_74762_e("Feedings");
        if (this.hippogryphInventory != null) {
            ListNBT nbttaglist = compound.func_150295_c("Items", 10);
            this.initHippogryphInv();
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundNBT CompoundNBT2 = nbttaglist.func_150305_b(i);
                int j = CompoundNBT2.func_74771_c("Slot") & 0xFF;
                this.hippogryphInventory.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)CompoundNBT2));
            }
        } else {
            ListNBT nbttaglist = compound.func_150295_c("Items", 10);
            this.initHippogryphInv();
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundNBT CompoundNBT3 = nbttaglist.func_150305_b(i);
                int j = CompoundNBT3.func_74771_c("Slot") & 0xFF;
                this.initHippogryphInv();
                this.hippogryphInventory.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)CompoundNBT3));
                ItemStack saddle = this.hippogryphInventory.func_70301_a(0);
                ItemStack chest = this.hippogryphInventory.func_70301_a(1);
                if (!this.field_70170_p.field_72995_K) continue;
                IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageHippogryphArmor(this.func_145782_y(), 0, saddle != null && saddle.func_77973_b() == Items.field_151141_av && !saddle.func_190926_b() ? 1 : 0));
                IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageHippogryphArmor(this.func_145782_y(), 1, chest != null && chest.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae) && !chest.func_190926_b() ? 1 : 0));
                IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageHippogryphArmor(this.func_145782_y(), 2, EntityHippogryph.getIntFromArmor(this.hippogryphInventory.func_70301_a(2))));
            }
        }
        this.hasHomePosition = compound.func_74767_n("HasHomePosition");
        if (this.hasHomePosition && compound.func_74762_e("HomeAreaX") != 0 && compound.func_74762_e("HomeAreaY") != 0 && compound.func_74762_e("HomeAreaZ") != 0) {
            this.homePos = new BlockPos(compound.func_74762_e("HomeAreaX"), compound.func_74762_e("HomeAreaY"), compound.func_74762_e("HomeAreaZ"));
        }
        this.setCommand(compound.func_74762_e("Command"));
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public EnumHippogryphTypes getEnumVariant() {
        return EnumHippogryphTypes.values()[this.getVariant()];
    }

    public void setEnumVariant(EnumHippogryphTypes variant) {
        this.setVariant(variant.ordinal());
    }

    public boolean isSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLE);
    }

    public void setSaddled(boolean saddle) {
        this.field_70180_af.func_187227_b(SADDLE, (Object)saddle);
    }

    public boolean isChested() {
        return (Boolean)this.field_70180_af.func_187225_a(CHESTED);
    }

    public void setChested(boolean chested) {
        this.field_70180_af.func_187227_b(CHESTED, (Object)chested);
        this.hasChestVarChanged = true;
    }

    public boolean func_70906_o() {
        if (this.field_70170_p.field_72995_K) {
            boolean isSitting;
            this.isSitting = isSitting = ((Byte)this.field_70180_af.func_187225_a(field_184755_bv) & 1) != 0;
            return isSitting;
        }
        return this.isSitting;
    }

    public void func_70904_g(boolean sitting) {
        if (!this.field_70170_p.field_72995_K) {
            this.isSitting = sitting;
        }
        byte b0 = (Byte)this.field_70180_af.func_187225_a(field_184755_bv);
        if (sitting) {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    @Override
    public boolean isHovering() {
        if (this.field_70170_p.field_72995_K) {
            this.isHovering = (Boolean)this.field_70180_af.func_187225_a(HOVERING);
            return this.isHovering;
        }
        return this.isHovering;
    }

    public void setHovering(boolean hovering) {
        this.field_70180_af.func_187227_b(HOVERING, (Object)hovering);
        if (!this.field_70170_p.field_72995_K) {
            this.isHovering = hovering;
        }
    }

    public boolean isRidingPlayer(PlayerEntity player) {
        return this.getRidingPlayer() != null && player != null && this.getRidingPlayer().func_110124_au().equals(player.func_110124_au());
    }

    @Override
    @Nullable
    public PlayerEntity getRidingPlayer() {
        if (this.func_184179_bs() instanceof PlayerEntity) {
            return (PlayerEntity)this.func_184179_bs();
        }
        return null;
    }

    @Override
    public double getFlightSpeedModifier() {
        return 1.0;
    }

    @Override
    public boolean isFlying() {
        if (this.field_70170_p.field_72995_K) {
            this.isFlying = (Boolean)this.field_70180_af.func_187225_a(FLYING);
            return this.isFlying;
        }
        return this.isFlying;
    }

    public void setFlying(boolean flying) {
        this.field_70180_af.func_187227_b(FLYING, (Object)flying);
        if (!this.field_70170_p.field_72995_K) {
            this.isFlying = flying;
        }
    }

    public int getArmor() {
        return (Integer)this.field_70180_af.func_187225_a(ARMOR);
    }

    public void setArmor(int armorType) {
        this.field_70180_af.func_187227_b(ARMOR, (Object)armorType);
        double armorValue = 0.0;
        switch (armorType) {
            case 1: {
                armorValue = 10.0;
                break;
            }
            case 2: {
                armorValue = 20.0;
                break;
            }
            case 3: {
                armorValue = 30.0;
            }
        }
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(armorValue);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    public boolean canMove() {
        StoneEntityProperties properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)this, StoneEntityProperties.class);
        if (properties != null && properties.isStone()) {
            return false;
        }
        return !this.func_70906_o() && this.func_184179_bs() == null && this.sitProgress == 0.0f;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setEnumVariant(EnumHippogryphTypes.getBiomeType(this.field_70170_p.func_226691_t_(this.func_180425_c())));
        return data;
    }

    public boolean func_70097_a(DamageSource dmg, float i) {
        if (this.func_184207_aI() && dmg.func_76346_g() != null && this.func_184179_bs() != null && dmg.func_76346_g() == this.func_184179_bs()) {
            return false;
        }
        return super.func_70097_a(dmg, i);
    }

    @Nullable
    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        return null;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public void func_70642_aH() {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_70642_aH();
    }

    protected void func_184581_c(DamageSource source) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_184581_c(source);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return IafSoundRegistry.HIPPOGRYPH_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return IafSoundRegistry.HIPPOGRYPH_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return IafSoundRegistry.HIPPOGRYPH_DIE;
    }

    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, ANIMATION_EAT, ANIMATION_BITE, ANIMATION_SPEAK, ANIMATION_SCRATCH};
    }

    public boolean shouldDismountInWater(Entity rider) {
        return true;
    }

    public boolean isDirectPathBetweenPoints(Vec3d vec1, Vec3d vec2) {
        BlockRayTraceResult movingobjectposition = this.field_70170_p.func_217299_a(new RayTraceContext(vec1, new Vec3d(vec2.field_72450_a, vec2.field_72448_b + (double)this.func_213302_cg() * 0.5, vec2.field_72449_c), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
        return movingobjectposition == null || movingobjectposition.func_216346_c() != RayTraceResult.Type.BLOCK;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void updateClientControls() {
        byte controlState;
        byte previousState;
        Minecraft mc = Minecraft.func_71410_x();
        if (this.isRidingPlayer((PlayerEntity)mc.field_71439_g)) {
            previousState = this.getControlState();
            this.up(mc.field_71474_y.field_74314_A.func_151470_d());
            this.down(IafKeybindRegistry.dragon_down.func_151470_d());
            this.attack(IafKeybindRegistry.dragon_strike.func_151470_d());
            this.dismount(mc.field_71474_y.field_228046_af_.func_151470_d());
            controlState = this.getControlState();
            if (controlState != previousState) {
                IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageDragonControl(this.func_145782_y(), controlState, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()));
            }
        }
        if (this.func_184187_bx() != null && this.func_184187_bx() == mc.field_71439_g) {
            previousState = this.getControlState();
            this.dismount(mc.field_71474_y.field_228046_af_.func_151470_d());
            controlState = this.getControlState();
            if (controlState != previousState) {
                IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageDragonControl(this.func_145782_y(), controlState, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()));
            }
        }
    }

    public void func_213352_e(Vec3d move) {
        if (!this.canMove() && !this.func_184207_aI()) {
            super.func_213352_e(Vec3d.field_186680_a);
            return;
        }
        super.func_213352_e(move);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() == ANIMATION_SCRATCH || this.getAnimation() == ANIMATION_BITE) {
            return true;
        }
        this.setAnimation(this.func_70681_au().nextBoolean() ? ANIMATION_SCRATCH : ANIMATION_BITE);
        return false;
    }

    public ItemEntity createEgg(EntityHippogryph partner) {
        int i = MathHelper.func_76128_c((double)this.func_226277_ct_());
        int j = MathHelper.func_76128_c((double)this.func_226278_cu_());
        int k = MathHelper.func_76128_c((double)this.func_226281_cx_());
        ItemStack stack = new ItemStack((IItemProvider)IafItemRegistry.HIPPOGRYPH_EGG);
        ItemEntity egg = new ItemEntity(this.field_70170_p, (double)i, (double)j, (double)k, stack);
        return egg;
    }

    public void fall(float distance, float damageMultiplier) {
    }

    public void func_70636_d() {
        boolean flying;
        boolean sitting;
        StoneEntityProperties properties;
        double dist;
        double dist2;
        super.func_70636_d();
        this.switchNavigator();
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && this.func_70638_az() instanceof PlayerEntity) {
            this.func_70624_b(null);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70906_o() && (this.getCommand() != 1 || this.func_184179_bs() != null)) {
                this.func_70904_g(false);
            }
            if (!this.func_70906_o() && this.getCommand() == 1 && this.func_184179_bs() == null) {
                this.func_70904_g(true);
            }
            if (this.func_70906_o()) {
                this.func_70661_as().func_75499_g();
            }
            if (this.field_70146_Z.nextInt(900) == 0 && this.field_70725_aQ == 0) {
                this.func_70691_i(1.0f);
            }
        }
        if (this.getAnimation() == ANIMATION_BITE && this.func_70638_az() != null && this.getAnimationTick() == 6 && (dist2 = this.func_70068_e((Entity)this.func_70638_az())) < 8.0) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        }
        LivingEntity attackTarget = this.func_70638_az();
        if (this.getAnimation() == ANIMATION_SCRATCH && attackTarget != null && this.getAnimationTick() == 6 && (dist = this.func_70068_e((Entity)this.func_70638_az())) < 8.0) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
            this.func_70638_az().field_70160_al = true;
            float f = MathHelper.func_76133_a((double)0.5);
            attackTarget.func_213317_d(attackTarget.func_213322_ci().func_72441_c(-0.5 / (double)f, 1.0, -0.5 / (double)f));
            attackTarget.func_213317_d(attackTarget.func_213322_ci().func_216372_d(0.5, 1.0, 0.5));
            if (this.func_70638_az().field_70122_E) {
                attackTarget.func_213317_d(attackTarget.func_213322_ci().func_72441_c(0.0, 0.3, 0.0));
            }
        }
        if (!this.field_70170_p.field_72995_K && !this.isOverAir() && this.func_70661_as().func_75500_f() && this.func_70638_az() != null && this.func_70638_az().func_226278_cu_() - 3.0 > this.func_226278_cu_() && this.func_70681_au().nextInt(15) == 0 && this.canMove() && !this.isHovering() && !this.isFlying()) {
            this.setHovering(true);
            this.hoverTicks = 0;
            this.flyTicks = 0;
        }
        if ((properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)this, StoneEntityProperties.class)) != null && properties.isStone()) {
            this.setFlying(false);
            this.setHovering(false);
        }
        this.airBorneCounter = this.isOverAir() ? ++this.airBorneCounter : 0;
        if (this.hasChestVarChanged && this.hippogryphInventory != null && !this.isChested()) {
            for (int i = 3; i < 18; ++i) {
                if (this.hippogryphInventory.func_70301_a(i).func_190926_b()) continue;
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70099_a(this.hippogryphInventory.func_70301_a(i), 1.0f);
                }
                this.hippogryphInventory.func_70304_b(i);
            }
            this.hasChestVarChanged = false;
        }
        if (this.isOverAir() && this.airTarget != null) {
            this.setFlying(true);
        }
        if (this.isFlying() && this.field_70173_aa % 40 == 0 || this.isFlying() && this.func_70906_o()) {
            this.setFlying(true);
        }
        if (!this.canMove() && this.func_70638_az() != null) {
            this.func_70624_b(null);
        }
        if (!this.canMove()) {
            this.func_70661_as().func_75499_g();
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        boolean bl = sitting = this.func_70906_o() && !this.isHovering() && !this.isFlying();
        if (sitting && this.sitProgress < 20.0f) {
            this.sitProgress += 0.5f;
        } else if (!sitting && this.sitProgress > 0.0f) {
            this.sitProgress -= 0.5f;
        }
        boolean hovering = this.isHovering();
        if (hovering && this.hoverProgress < 20.0f) {
            this.hoverProgress += 0.5f;
        } else if (!hovering && this.hoverProgress > 0.0f) {
            this.hoverProgress -= 0.5f;
        }
        boolean bl2 = flying = this.isFlying() || !this.isHovering() && this.airBorneCounter > 10;
        if (flying && this.flyProgress < 20.0f) {
            this.flyProgress += 0.5f;
        } else if (!flying && this.flyProgress > 0.0f) {
            this.flyProgress -= 0.5f;
        }
        if ((flying || hovering) && this.field_70173_aa % 20 == 0 && this.isOverAir()) {
            this.func_184185_a(SoundEvents.field_187524_aN, this.func_70599_aP() * (float)(IafConfig.dragonFlapNoiseDistance / 2), 0.6f + this.field_70146_Z.nextFloat() * 0.6f * this.func_70647_i());
        }
        if (!this.isOverAir() && this.doesWantToLand() && (this.isFlying() || this.isHovering())) {
            this.setFlying(false);
            this.setHovering(false);
        }
        if (this.isHovering()) {
            if (this.func_70906_o()) {
                this.setHovering(false);
            }
            ++this.hoverTicks;
            if (this.doesWantToLand()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.25, 0.0));
            } else {
                if (this.func_184179_bs() == null) {
                    this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.08, 0.0));
                }
                if (this.hoverTicks > 40) {
                    if (!this.func_70631_g_()) {
                        this.setFlying(true);
                    }
                    this.setHovering(false);
                    this.hoverTicks = 0;
                    this.flyTicks = 0;
                }
            }
        }
        if (this.func_70906_o()) {
            this.func_70661_as().func_75499_g();
        }
        if (!(this.isFlying() || this.isHovering() || this.airTarget == null || this.isOverAir())) {
            this.airTarget = null;
        }
        if (this.isFlying() && this.airTarget == null && !this.isOverAir() && this.func_184179_bs() == null) {
            this.setFlying(false);
        }
        if (this.isFlying() && this.func_70638_az() == null) {
            this.flyAround();
        } else if (this.func_70638_az() != null) {
            this.flyTowardsTarget();
        }
        if (!this.isOverAir() && this.flyTicks != 0) {
            this.flyTicks = 0;
        }
        if (this.isFlying() && this.doesWantToLand() && this.func_184179_bs() == null) {
            this.setFlying(false);
            this.setHovering(false);
            if (!this.isOverAir()) {
                this.flyTicks = 0;
                this.setFlying(false);
            }
        }
        if (this.isFlying()) {
            ++this.flyTicks;
        }
        if ((this.isHovering() || this.isFlying()) && this.func_70906_o()) {
            this.setFlying(false);
            this.setHovering(false);
        }
        if (!(properties != null && (properties == null || properties.isStone()) || (this.field_70170_p.field_72995_K || this.func_70681_au().nextInt(1200) != 0 || this.func_70906_o() || this.isFlying() || !this.func_184188_bt().isEmpty() || this.func_70631_g_() || this.isHovering() || this.func_70906_o() || !this.canMove() || this.isOverAir()) && !(this.func_226278_cu_() < -1.0))) {
            this.setHovering(true);
            this.hoverTicks = 0;
            this.flyTicks = 0;
        }
        if (this.func_70638_az() != null && !this.func_184188_bt().isEmpty() && this.func_70902_q() != null && this.func_184188_bt().contains(this.func_70902_q())) {
            this.func_70624_b(null);
        }
    }

    public boolean doesWantToLand() {
        return this.flyTicks > 2000 || this.down() || this.flyTicks > 40 && this.flyProgress == 0.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.isOverAir = this.isOverAirLogic();
        if (this.field_70170_p.field_72995_K) {
            this.updateClientControls();
        }
        if (this.up()) {
            if (this.airBorneCounter == 0) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 1.0, 0.0));
            }
            if (!this.isFlying() && !this.isHovering()) {
                this.spacebarTicks += 2;
            }
        } else if (this.dismount() && (this.isFlying() || this.isHovering())) {
            this.setFlying(false);
            this.setHovering(false);
        }
        if (this.attack() && this.func_184179_bs() != null && this.func_184179_bs() instanceof PlayerEntity) {
            LivingEntity target = DragonUtils.riderLookingAtEntity((LivingEntity)this, (LivingEntity)((PlayerEntity)this.func_184179_bs()), 3.0);
            if (this.getAnimation() != ANIMATION_BITE && this.getAnimation() != ANIMATION_SCRATCH) {
                this.setAnimation(this.func_70681_au().nextBoolean() ? ANIMATION_SCRATCH : ANIMATION_BITE);
            }
            if (target != null && this.getAnimationTick() >= 10 && this.getAnimationTick() < 13) {
                target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
            }
        }
        if (this.func_184179_bs() != null && this.func_184179_bs().func_225608_bj_()) {
            this.func_184179_bs().func_184210_p();
        }
        if (this.isFlying() && !this.isHovering() && this.func_184179_bs() != null && this.isOverAir() && Math.max(Math.abs(this.func_213322_ci().field_72450_a), Math.abs(this.func_213322_ci().field_72449_c)) < (double)0.1f) {
            this.setHovering(true);
            this.setFlying(false);
        }
        if (this.isHovering() && !this.isFlying() && this.func_184179_bs() != null && this.isOverAir() && Math.max(Math.abs(this.func_213322_ci().field_72450_a), Math.abs(this.func_213322_ci().field_72449_c)) > (double)0.1f) {
            this.setFlying(true);
            this.setHovering(false);
        }
        if (this.spacebarTicks > 0) {
            --this.spacebarTicks;
        }
        if (this.spacebarTicks > 10 && this.func_70902_q() != null && this.func_184188_bt().contains(this.func_70902_q()) && !this.isFlying() && !this.isHovering()) {
            this.setHovering(true);
        }
        if (this.field_70170_p.field_72995_K) {
            this.roll_buffer.calculateChainFlapBuffer(35.0f, 8, 6.0f, (LivingEntity)this);
        }
        if (this.func_70638_az() != null && this.func_184187_bx() == null && !this.func_70638_az().func_70089_S() || this.func_70638_az() != null && this.func_70638_az() instanceof EntityDragonBase && !this.func_70638_az().func_70089_S()) {
            this.func_70624_b(null);
        }
    }

    public void flyAround() {
        if (this.airTarget != null && this.isFlying()) {
            if (!this.isTargetInAir() || this.flyTicks > 6000 || !this.isFlying()) {
                this.airTarget = null;
            }
            this.flyTowardsTarget();
        }
    }

    public boolean isTargetBlocked(Vec3d target) {
        BlockRayTraceResult rayTrace;
        if (target != null && (rayTrace = this.field_70170_p.func_217299_a(new RayTraceContext(this.func_174824_e(1.0f), target, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this))) != null && rayTrace.func_216347_e() != null) {
            BlockPos pos = new BlockPos(rayTrace.func_216347_e());
            return !this.field_70170_p.func_175623_d(pos);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void flyTowardsTarget() {
        if (this.airTarget == null || !this.isTargetInAir() || !this.isFlying()) ** GOTO lbl-1000
        v0 = new Vec3d((double)this.airTarget.func_177958_n(), this.func_226278_cu_(), (double)this.airTarget.func_177952_p());
        if (this.getDistanceSquared(v0) > 3.0f) {
            targetX = (double)this.airTarget.func_177958_n() + 0.5 - this.func_226277_ct_();
            targetY = (double)Math.min(this.airTarget.func_177956_o(), 256) + 1.0 - this.func_226278_cu_();
            targetZ = (double)this.airTarget.func_177952_p() + 0.5 - this.func_226281_cx_();
            motionX = (Math.signum(targetX) * 0.5 - this.func_213322_ci().field_72450_a) * 0.100000000372529 * 2.0;
            motionY = (Math.signum(targetY) * 0.5 - this.func_213322_ci().field_72448_b) * 0.100000000372529 * 2.0;
            motionZ = (Math.signum(targetZ) * 0.5 - this.func_213322_ci().field_72449_c) * 0.100000000372529 * 2.0;
            this.func_213317_d(this.func_213322_ci().func_72441_c(motionX, motionY, motionZ));
            angle = (float)(Math.atan2(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72449_c) * 180.0 / 3.141592653589793) - 90.0f;
            rotation = MathHelper.func_76142_g((float)(angle - this.field_70177_z));
            this.field_191988_bg = 0.5f;
            this.field_70126_B = this.field_70177_z;
            this.field_70177_z += rotation;
            if (!this.isFlying()) {
                this.setFlying(true);
            }
        } else lbl-1000:
        // 2 sources

        {
            this.airTarget = null;
        }
        if (this.airTarget != null && this.isFlying() && this.doesWantToLand()) {
            this.setFlying(false);
            this.setHovering(false);
        }
    }

    protected boolean isTargetInAir() {
        return this.airTarget != null && (this.field_70170_p.func_180495_p(this.airTarget).func_185904_a() == Material.field_151579_a || this.field_70170_p.func_180495_p(this.airTarget).func_185904_a() == Material.field_151579_a);
    }

    public float getDistanceSquared(Vec3d vec3d) {
        float f = (float)(this.func_226277_ct_() - vec3d.field_72450_a);
        float f1 = (float)(this.func_226278_cu_() - vec3d.field_72448_b);
        float f2 = (float)(this.func_226281_cx_() - vec3d.field_72449_c);
        return f * f + f1 * f1 + f2 * f2;
    }

    public boolean func_174820_d(int inventorySlot, @Nullable ItemStack itemStackIn) {
        int j = inventorySlot - 500 + 2;
        if (j >= 0 && j < this.hippogryphInventory.func_70302_i_()) {
            this.hippogryphInventory.func_70299_a(j, itemStackIn);
            return true;
        }
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (this.hippogryphInventory != null && !this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.hippogryphInventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.hippogryphInventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                this.func_70099_a(itemstack, 0.0f);
            }
        }
    }

    public void refreshInventory() {
        ItemStack saddle = this.hippogryphInventory.func_70301_a(0);
        ItemStack chest = this.hippogryphInventory.func_70301_a(1);
        this.setSaddled(saddle != null && saddle.func_77973_b() == Items.field_151141_av && !saddle.func_190926_b());
        this.setChested(chest != null && chest.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae) && !chest.func_190926_b());
        this.setArmor(EntityHippogryph.getIntFromArmor(this.hippogryphInventory.func_70301_a(2)));
        if (this.field_70170_p.field_72995_K) {
            IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageHippogryphArmor(this.func_145782_y(), 0, saddle != null && saddle.func_77973_b() == Items.field_151141_av && !saddle.func_190926_b() ? 1 : 0));
            IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageHippogryphArmor(this.func_145782_y(), 1, chest != null && chest.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae) && !chest.func_190926_b() ? 1 : 0));
            IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageHippogryphArmor(this.func_145782_y(), 2, EntityHippogryph.getIntFromArmor(this.hippogryphInventory.func_70301_a(2))));
        }
    }

    @Override
    public void onHearFlute(PlayerEntity player) {
        if (this.func_70909_n() && this.func_152114_e((LivingEntity)player) && (this.isFlying() || this.isHovering())) {
            this.airTarget = null;
            this.setFlying(false);
            this.setHovering(false);
        }
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return DragonUtils.canTameDragonAttack(this, entity);
    }

    @Override
    public void dropArmor() {
        if (this.hippogryphInventory != null && !this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.hippogryphInventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.hippogryphInventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                this.func_70099_a(itemstack, 0.0f);
            }
        }
    }

    public boolean func_104002_bU() {
        return true;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }
}

