/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.server.entity.EntityPropertiesHandler;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.EntityHydraBreath;
import com.github.alexthe666.iceandfire.entity.EntityHydraHead;
import com.github.alexthe666.iceandfire.entity.EntityMutlipartPart;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.props.StoneEntityProperties;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.util.IBlacklistedFromStatues;
import com.github.alexthe666.iceandfire.entity.util.IMultipartEntity;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityHydra
extends MonsterEntity
implements IAnimatedEntity,
IMultipartEntity,
IVillagerFear,
IAnimalFear {
    public static final int HEADS = 9;
    public static final double HEAD_HEALTH_THRESHOLD = 20.0;
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityHydra.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HEAD_COUNT = EntityDataManager.func_187226_a(EntityHydra.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SEVERED_HEAD = EntityDataManager.func_187226_a(EntityHydra.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final float[][] ROTATE = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {10.0f, -10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {10.0f, 0.0f, -10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {25.0f, 10.0f, -10.0f, -25.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {30.0f, 15.0f, 0.0f, -15.0f, -30.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {40.0f, 25.0f, 5.0f, -5.0f, -25.0f, -40.0f, 0.0f, 0.0f, 0.0f}, {40.0f, 30.0f, 15.0f, 0.0f, -15.0f, -30.0f, -40.0f, 0.0f, 0.0f}, {45.0f, 30.0f, 20.0f, 5.0f, -5.0f, -20.0f, -30.0f, -45.0f, 0.0f}, {50.0f, 37.0f, 25.0f, 15.0f, 0.0f, -15.0f, -25.0f, -37.0f, -50.0f}};
    public boolean[] isStriking = new boolean[9];
    public float[] strikingProgress = new float[9];
    public float[] prevStrikeProgress = new float[9];
    public boolean[] isBreathing = new boolean[9];
    public float[] speakingProgress = new float[9];
    public float[] prevSpeakingProgress = new float[9];
    public float[] breathProgress = new float[9];
    public float[] prevBreathProgress = new float[9];
    public int[] breathTicks = new int[9];
    public float[] headDamageTracker = new float[9];
    private int animationTick;
    private Animation currentAnimation;
    private EntityHydraHead[] headBoxes = new EntityHydraHead[81];
    private int strikeCooldown = 0;
    private int breathCooldown = 0;
    private int lastHitHead = 0;
    private int prevHeadCount = -1;
    private int regrowHeadCooldown = 0;
    private boolean onlyRegrowOneHeadNotTwo = false;
    private float headDamageThreshold = 20.0f;

    public EntityHydra(EntityType type, World worldIn) {
        super(type, worldIn);
        this.resetParts();
        this.headDamageThreshold = Math.max(5.0f, (float)IafConfig.hydraMaxHealth * 0.08f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 0, true, false, (Predicate)new com.google.common.base.Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity.func_70089_S();
            }
        }));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 0, true, false, (Predicate)new com.google.common.base.Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                StoneEntityProperties properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties(entity, StoneEntityProperties.class);
                return entity instanceof LivingEntity && DragonUtils.isAlive((LivingEntity)entity) && !(entity instanceof EntityMutlipartPart) && !(entity instanceof IMob) && (properties == null || properties != null && !properties.isStone()) || entity instanceof IBlacklistedFromStatues && ((IBlacklistedFromStatues)entity).canBeTurnedToStone();
            }
        }));
    }

    public boolean func_70652_k(Entity entityIn) {
        return false;
    }

    public void func_70636_d() {
        int index;
        super.func_70636_d();
        if (this.func_70638_az() != null && this.func_70685_l((Entity)this.func_70638_az()) && !this.isBreathing[index = this.field_70146_Z.nextInt(this.getHeadCount())] && !this.isStriking[index]) {
            if (this.func_70032_d((Entity)this.func_70638_az()) < 6.0f) {
                if (this.strikeCooldown == 0 && this.strikingProgress[index] == 0.0f) {
                    this.isBreathing[index] = false;
                    this.isStriking[index] = true;
                    this.field_70170_p.func_72960_a((Entity)this, (byte)(40 + index));
                    this.strikeCooldown = 3;
                }
            } else if (this.field_70146_Z.nextBoolean() && this.breathCooldown == 0) {
                this.isBreathing[index] = true;
                this.isStriking[index] = false;
                this.field_70170_p.func_72960_a((Entity)this, (byte)(50 + index));
                this.breathCooldown = 15;
            }
        }
        for (int i = 0; i < 9; ++i) {
            boolean striking = this.isStriking[i];
            boolean breathing = this.isBreathing[i];
            this.prevStrikeProgress[i] = this.strikingProgress[i];
            if (striking && this.strikingProgress[i] > 9.0f) {
                this.isStriking[i] = false;
                if (this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) < 6.0f) {
                    this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                    this.func_70638_az().func_195064_c(new EffectInstance(Effects.field_76436_u, 100, 3, false, false));
                    this.func_70638_az().func_70653_a((Entity)this.func_70638_az(), 0.25f, this.func_226277_ct_() - this.func_70638_az().func_226277_ct_(), this.func_226281_cx_() - this.func_70638_az().func_226281_cx_());
                }
            }
            if (breathing) {
                LivingEntity entity = this.func_70638_az();
                if (this.field_70173_aa % 7 == 0 && entity != null && i < this.getHeadCount()) {
                    Vec3d vec3d = this.func_70676_i(1.0f);
                    if (this.field_70146_Z.nextFloat() < 0.2f) {
                        this.func_184185_a(IafSoundRegistry.HYDRA_SPIT, this.func_70599_aP(), this.func_70647_i());
                    }
                    double headPosX = this.headBoxes[i].func_226277_ct_() + vec3d.field_72450_a * 1.0;
                    double headPosY = this.headBoxes[i].func_226278_cu_() + (double)1.3f;
                    double headPosZ = this.headBoxes[i].func_226281_cx_() + vec3d.field_72449_c * 1.0;
                    double d2 = entity.func_226277_ct_() - headPosX + this.field_70146_Z.nextGaussian() * 0.4;
                    double d3 = entity.func_226278_cu_() + (double)entity.func_70047_e() - headPosY + this.field_70146_Z.nextGaussian() * 0.4;
                    double d4 = entity.func_226281_cx_() - headPosZ + this.field_70146_Z.nextGaussian() * 0.4;
                    EntityHydraBreath entitylargefireball = new EntityHydraBreath(IafEntityRegistry.HYDRA_BREATH, this.field_70170_p, this, d2, d3, d4);
                    entitylargefireball.func_70107_b(headPosX, headPosY, headPosZ);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_217376_c((Entity)entitylargefireball);
                    }
                }
                if (!(!this.isBreathing[i] || entity != null && entity.func_70089_S() && this.breathTicks[i] <= 60 || this.field_70170_p.field_72995_K)) {
                    this.isBreathing[i] = false;
                    this.breathTicks[i] = 0;
                    this.breathCooldown = 15;
                    this.field_70170_p.func_72960_a((Entity)this, (byte)(60 + i));
                }
                int n = i;
                this.breathTicks[n] = this.breathTicks[n] + 1;
            } else {
                this.breathTicks[i] = 0;
            }
            if (striking && this.strikingProgress[i] < 10.0f) {
                int n = i;
                this.strikingProgress[n] = this.strikingProgress[n] + 2.5f;
            } else if (!striking && this.strikingProgress[i] > 0.0f) {
                int n = i;
                this.strikingProgress[n] = this.strikingProgress[n] - 2.5f;
            }
            this.prevSpeakingProgress[i] = this.speakingProgress[i];
            if (this.speakingProgress[i] > 0.0f) {
                int n = i;
                this.speakingProgress[n] = this.speakingProgress[n] - 0.1f;
            }
            this.prevBreathProgress[i] = this.breathProgress[i];
            if (breathing && this.breathProgress[i] < 10.0f) {
                int n = i;
                this.breathProgress[n] = this.breathProgress[n] + 1.0f;
                continue;
            }
            if (breathing || !(this.breathProgress[i] > 0.0f)) continue;
            int n = i;
            this.breathProgress[n] = this.breathProgress[n] - 1.0f;
        }
        if (this.strikeCooldown > 0) {
            --this.strikeCooldown;
        }
        if (this.breathCooldown > 0) {
            --this.breathCooldown;
        }
        if (this.getHeadCount() == 1 && this.getSeveredHead() != -1) {
            this.setSeveredHead(-1);
        }
        if (this.getHeadCount() == 1 && !this.func_70027_ad()) {
            this.setHeadCount(2);
            this.setSeveredHead(1);
            this.onlyRegrowOneHeadNotTwo = true;
        }
        if (this.getSeveredHead() != -1 && this.getSeveredHead() < this.getHeadCount()) {
            this.setSeveredHead(MathHelper.func_76125_a((int)this.getSeveredHead(), (int)0, (int)(this.getHeadCount() - 1)));
            ++this.regrowHeadCooldown;
            if (this.regrowHeadCooldown >= 100) {
                this.headDamageTracker[this.getSeveredHead()] = 0.0f;
                this.setSeveredHead(-1);
                if (this.func_70027_ad()) {
                    this.setHeadCount(this.getHeadCount() - 1);
                } else {
                    this.func_184185_a(IafSoundRegistry.HYDRA_REGEN_HEAD, this.func_70599_aP(), this.func_70647_i());
                    if (!this.onlyRegrowOneHeadNotTwo) {
                        this.setHeadCount(this.getHeadCount() + 1);
                    }
                }
                this.onlyRegrowOneHeadNotTwo = false;
                this.regrowHeadCooldown = 0;
            }
        } else {
            this.regrowHeadCooldown = 0;
        }
    }

    public void resetParts() {
        this.clearParts();
        this.headBoxes = new EntityHydraHead[18];
        for (int i = 0; i < this.getHeadCount(); ++i) {
            float maxAngle = 5.0f;
            this.headBoxes[i] = new EntityHydraHead(this, 3.2f, ROTATE[this.getHeadCount() - 1][i] * 1.1f, 1.0f, 0.75f, 1.75f, 1.0f, i, false);
            this.headBoxes[9 + i] = new EntityHydraHead(this, 2.1f, ROTATE[this.getHeadCount() - 1][i] * 1.1f, 1.0f, 0.75f, 0.75f, 1.0f, i, true);
            this.headBoxes[i].func_82149_j((Entity)this);
            this.headBoxes[9 + i].func_82149_j((Entity)this);
            this.headBoxes[i].setParent((LivingEntity)this);
            this.headBoxes[9 + i].setParent((LivingEntity)this);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.prevHeadCount != this.getHeadCount()) {
            this.resetParts();
        }
        this.onUpdateParts();
        float partY = 1.0f - this.field_70721_aZ * 0.5f;
        for (int i = 0; i < this.getHeadCount(); ++i) {
            this.headBoxes[i].func_70107_b(this.headBoxes[i].func_226277_ct_(), this.func_226278_cu_() + (double)partY, this.headBoxes[i].func_226281_cx_());
            this.headBoxes[i].setParent((LivingEntity)this);
            if (!this.headBoxes[i].shouldContinuePersisting()) {
                this.field_70170_p.func_217376_c((Entity)this.headBoxes[i]);
            }
            this.headBoxes[9 + i].func_70107_b(this.headBoxes[9 + i].func_226277_ct_(), this.func_226278_cu_() + (double)partY, this.headBoxes[9 + i].func_226281_cx_());
            this.headBoxes[9 + i].setParent((LivingEntity)this);
            if (this.headBoxes[9 + i].shouldContinuePersisting()) continue;
            this.field_70170_p.func_217376_c((Entity)this.headBoxes[9 + i]);
        }
        if (this.getHeadCount() > 1 && !this.func_70027_ad() && this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % 30 == 0) {
            int level = this.getHeadCount() - 1;
            if (this.getSeveredHead() != -1) {
                --level;
            }
            this.func_195064_c(new EffectInstance(Effects.field_76428_l, 30, level, false, false));
        }
        if (this.func_70027_ad()) {
            this.func_195063_d(Effects.field_76428_l);
        }
        this.prevHeadCount = this.getHeadCount();
    }

    public void onUpdateParts() {
    }

    private void clearParts() {
        for (EntityHydraHead entity : this.headBoxes) {
            if (entity == null) continue;
            entity.func_70106_y();
        }
    }

    public void func_70106_y() {
        this.clearParts();
        super.func_70106_y();
    }

    protected void func_184581_c(DamageSource source) {
        this.speakingProgress[this.field_70146_Z.nextInt((int)this.getHeadCount())] = 1.0f;
        super.func_184581_c(source);
    }

    public void func_70642_aH() {
        this.speakingProgress[this.field_70146_Z.nextInt((int)this.getHeadCount())] = 1.0f;
        super.func_70642_aH();
    }

    public int func_70627_aG() {
        return 100 / this.getHeadCount();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74768_a("HeadCount", this.getHeadCount());
        compound.func_74768_a("SeveredHead", this.getSeveredHead());
        for (int i = 0; i < 9; ++i) {
            compound.func_74776_a("HeadDamage" + i, this.headDamageTracker[i]);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.setHeadCount(compound.func_74762_e("HeadCount"));
        this.setSeveredHead(compound.func_74762_e("SeveredHead"));
        for (int i = 0; i < 9; ++i) {
            this.headDamageTracker[i] = compound.func_74760_g("HeadDamage" + i);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(HEAD_COUNT, (Object)3);
        this.field_70180_af.func_187214_a(SEVERED_HEAD, (Object)-1);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)IafConfig.generateHydraChance);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(1.0);
        this.func_110148_a(LivingEntity.SWIM_SPEED).func_111128_a(2.0);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        int headIndex;
        if (this.lastHitHead > this.getHeadCount()) {
            this.lastHitHead = this.getHeadCount() - 1;
        }
        int n = headIndex = this.lastHitHead;
        this.headDamageTracker[n] = this.headDamageTracker[n] + amount;
        if (this.headDamageTracker[headIndex] > this.headDamageThreshold && (this.getSeveredHead() == -1 || this.getSeveredHead() >= this.getHeadCount())) {
            this.headDamageTracker[headIndex] = 0.0f;
            this.regrowHeadCooldown = 0;
            this.setSeveredHead(headIndex);
            this.func_184185_a(SoundEvents.field_187684_cg, this.func_70599_aP(), this.func_70647_i());
        }
        if (this.func_110143_aJ() <= amount + 5.0f && this.getHeadCount() > 1 && !source.func_76357_e()) {
            amount = 0.0f;
        }
        return super.func_70097_a(source, amount);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setVariant(this.field_70146_Z.nextInt(3));
        return data;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[0];
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return true;
    }

    public boolean func_104002_bU() {
        return true;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public int getHeadCount() {
        return MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(HEAD_COUNT)), (int)1, (int)9);
    }

    public void setHeadCount(int count) {
        this.field_70180_af.func_187227_b(HEAD_COUNT, (Object)MathHelper.func_76125_a((int)count, (int)1, (int)9));
    }

    public int getSeveredHead() {
        return MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(SEVERED_HEAD)), (int)-1, (int)9);
    }

    public void setSeveredHead(int count) {
        this.field_70180_af.func_187227_b(SEVERED_HEAD, (Object)MathHelper.func_76125_a((int)count, (int)-1, (int)9));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id >= 40 && id <= 48) {
            int index = id - 40;
            this.isStriking[MathHelper.func_76125_a((int)index, (int)0, (int)8)] = true;
        } else if (id >= 50 && id <= 58) {
            int index = id - 50;
            this.isBreathing[MathHelper.func_76125_a((int)index, (int)0, (int)8)] = true;
        } else if (id >= 60 && id <= 68) {
            int index = id - 60;
            this.isBreathing[MathHelper.func_76125_a((int)index, (int)0, (int)8)] = false;
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        return potioneffectIn.func_188419_a() != Effects.field_76436_u && super.func_70687_e(potioneffectIn);
    }

    public void onHitHead(float damage, int headIndex) {
        this.lastHitHead = headIndex;
    }

    public void triggerHeadFlags(int index) {
        this.lastHitHead = index;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return IafSoundRegistry.HYDRA_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return IafSoundRegistry.HYDRA_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return IafSoundRegistry.HYDRA_DIE;
    }
}

