/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.server.entity.EntityPropertiesHandler;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.api.event.DragonFireDamageWorldEvent;
import com.github.alexthe666.iceandfire.block.BlockCharedPath;
import com.github.alexthe666.iceandfire.block.BlockFallingReturningState;
import com.github.alexthe666.iceandfire.block.BlockReturningState;
import com.github.alexthe666.iceandfire.block.IDragonProof;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.props.FrozenEntityProperties;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityDragonforgeInput;
import com.github.alexthe666.iceandfire.entity.util.BlockLaunchExplosion;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.misc.IafDamageRegistry;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SpreadableSnowyDirtBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class IafDragonDestructionManager {
    public static void destroyAreaFire(World world, BlockPos center, EntityDragonBase destroyer) {
        if (MinecraftForge.EVENT_BUS.post((Event)new DragonFireDamageWorldEvent(destroyer, center.func_177958_n(), center.func_177956_o(), center.func_177952_p()))) {
            return;
        }
        int stage = destroyer.getDragonStage();
        double damageRadius = 3.5;
        float dmgScale = (float)IafConfig.dragonAttackDamageFire;
        if (stage <= 3) {
            for (BlockPos pos : BlockPos.func_218281_b((BlockPos)center.func_177982_a(-1, -1, -1), (BlockPos)center.func_177982_a(1, 1, 1)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
                if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityDragonforgeInput) {
                    ((TileEntityDragonforgeInput)world.func_175625_s(pos)).onHitWithFlame();
                }
                if (IafConfig.dragonGriefing == 2 || !world.field_73012_v.nextBoolean() || world.func_180495_p(pos).func_177230_c() instanceof IDragonProof || !DragonUtils.canDragonBreak(world.func_180495_p(pos).func_177230_c())) continue;
                BlockState transformState = IafDragonDestructionManager.transformBlockFire(world.func_180495_p(pos));
                if (transformState.func_177230_c() != world.func_180495_p(pos).func_177230_c()) {
                    world.func_175656_a(pos, transformState);
                }
                if (!world.field_73012_v.nextBoolean() || !transformState.func_185904_a().func_76220_a() || !world.func_175623_d(pos.func_177984_a())) continue;
                world.func_175656_a(pos.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
            }
            for (LivingEntity LivingEntity2 : world.func_217357_a(LivingEntity.class, new AxisAlignedBB((double)center.func_177958_n() - damageRadius, (double)center.func_177956_o() - damageRadius, (double)center.func_177952_p() - damageRadius, (double)center.func_177958_n() + damageRadius, (double)center.func_177956_o() + damageRadius, (double)center.func_177952_p() + damageRadius))) {
                if (DragonUtils.onSameTeam((Entity)destroyer, (Entity)LivingEntity2) || destroyer.func_70028_i((Entity)LivingEntity2) || !destroyer.func_70685_l((Entity)LivingEntity2)) continue;
                LivingEntity2.func_70097_a(IafDamageRegistry.DRAGON_FIRE, (float)stage * dmgScale);
                LivingEntity2.func_70015_d(5 + stage * 5);
            }
        } else {
            int radius = stage == 4 ? 2 : 3;
            int j = radius + world.field_73012_v.nextInt(1);
            int k = radius + world.field_73012_v.nextInt(1);
            int l = radius + world.field_73012_v.nextInt(1);
            float f = (float)(j + k + l) * 0.333f + 0.5f;
            damageRadius = 2.5f + f * 1.2f;
            for (BlockPos blockpos : BlockPos.func_218281_b((BlockPos)center.func_177982_a(-j, -k, -l), (BlockPos)center.func_177982_a(j, k, l)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
                if (world.func_175625_s(blockpos) != null && world.func_175625_s(blockpos) instanceof TileEntityDragonforgeInput) {
                    ((TileEntityDragonforgeInput)world.func_175625_s(blockpos)).onHitWithFlame();
                }
                if (!(blockpos.func_177951_i((Vec3i)center) <= (double)(f * f)) || IafConfig.dragonGriefing == 2 || !(world.field_73012_v.nextFloat() > (float)blockpos.func_177951_i((Vec3i)center) / (f * f)) || world.func_180495_p(blockpos).func_177230_c() instanceof IDragonProof || !DragonUtils.canDragonBreak(world.func_180495_p(blockpos).func_177230_c())) continue;
                BlockState transformState = IafDragonDestructionManager.transformBlockFire(world.func_180495_p(blockpos));
                world.func_175656_a(blockpos, transformState);
                if (!world.field_73012_v.nextBoolean() || !transformState.func_185904_a().func_76220_a() || !world.func_175623_d(blockpos.func_177984_a())) continue;
                world.func_175656_a(blockpos.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
            }
            for (LivingEntity LivingEntity3 : world.func_217357_a(LivingEntity.class, new AxisAlignedBB((double)center.func_177958_n() - damageRadius, (double)center.func_177956_o() - damageRadius, (double)center.func_177952_p() - damageRadius, (double)center.func_177958_n() + damageRadius, (double)center.func_177956_o() + damageRadius, (double)center.func_177952_p() + damageRadius))) {
                if (DragonUtils.onSameTeam((Entity)destroyer, (Entity)LivingEntity3) || destroyer.func_70028_i((Entity)LivingEntity3) || !destroyer.func_70685_l((Entity)LivingEntity3)) continue;
                LivingEntity3.func_70097_a(IafDamageRegistry.DRAGON_FIRE, (float)stage * dmgScale);
                LivingEntity3.func_70015_d(5 + stage * 5);
            }
        }
    }

    public static void destroyAreaIce(World world, BlockPos center, EntityDragonBase destroyer) {
        if (MinecraftForge.EVENT_BUS.post((Event)new DragonFireDamageWorldEvent(destroyer, center.func_177958_n(), center.func_177956_o(), center.func_177952_p()))) {
            return;
        }
        int stage = destroyer.getDragonStage();
        double damageRadius = 3.5;
        float dmgScale = (float)IafConfig.dragonAttackDamageIce;
        if (stage <= 3) {
            for (BlockPos pos : BlockPos.func_218281_b((BlockPos)center.func_177982_a(-1, -1, -1), (BlockPos)center.func_177982_a(1, 1, 1)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
                if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityDragonforgeInput) {
                    ((TileEntityDragonforgeInput)world.func_175625_s(pos)).onHitWithFlame();
                }
                if (IafConfig.dragonGriefing == 2 || !world.field_73012_v.nextBoolean() || world.func_180495_p(pos).func_177230_c() instanceof IDragonProof || !DragonUtils.canDragonBreak(world.func_180495_p(pos).func_177230_c())) continue;
                BlockState transformState = IafDragonDestructionManager.transformBlockIce(world.func_180495_p(pos));
                if (transformState.func_177230_c() != world.func_180495_p(pos).func_177230_c()) {
                    world.func_175656_a(pos, transformState);
                }
                if (world.field_73012_v.nextInt(9) != 0 || !transformState.func_185904_a().func_76220_a() || !world.func_175623_d(pos.func_177984_a()) || !world.func_180495_p(pos.func_177977_b()).func_200132_m()) continue;
                world.func_175656_a(pos.func_177984_a(), IafBlockRegistry.DRAGON_ICE_SPIKES.func_176223_P());
            }
            for (LivingEntity LivingEntity2 : world.func_217357_a(LivingEntity.class, new AxisAlignedBB((double)center.func_177958_n() - damageRadius, (double)center.func_177956_o() - damageRadius, (double)center.func_177952_p() - damageRadius, (double)center.func_177958_n() + damageRadius, (double)center.func_177956_o() + damageRadius, (double)center.func_177952_p() + damageRadius))) {
                if (DragonUtils.onSameTeam((Entity)destroyer, (Entity)LivingEntity2) || destroyer.func_70028_i((Entity)LivingEntity2) || !destroyer.func_70685_l((Entity)LivingEntity2)) continue;
                LivingEntity2.func_70097_a(IafDamageRegistry.DRAGON_ICE, (float)stage * dmgScale);
                FrozenEntityProperties frozenProps = (FrozenEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)LivingEntity2, FrozenEntityProperties.class);
                if (frozenProps == null) continue;
                frozenProps.setFrozenFor(50 * stage);
            }
        } else {
            int radius = stage == 4 ? 2 : 3;
            int j = radius + world.field_73012_v.nextInt(1);
            int k = radius + world.field_73012_v.nextInt(1);
            int l = radius + world.field_73012_v.nextInt(1);
            float f = (float)(j + k + l) * 0.333f + 0.5f;
            damageRadius = 2.5f + f * 1.2f;
            for (BlockPos blockpos : BlockPos.func_218281_b((BlockPos)center.func_177982_a(-j, -k, -l), (BlockPos)center.func_177982_a(j, k, l)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
                if (world.func_175625_s(blockpos) != null && world.func_175625_s(blockpos) instanceof TileEntityDragonforgeInput) {
                    ((TileEntityDragonforgeInput)world.func_175625_s(blockpos)).onHitWithFlame();
                }
                if (!(blockpos.func_177951_i((Vec3i)center) <= (double)(f * f)) || IafConfig.dragonGriefing == 2 || !(world.field_73012_v.nextFloat() > (float)blockpos.func_177951_i((Vec3i)center) / (f * f)) || world.func_180495_p(blockpos).func_177230_c() instanceof IDragonProof || !DragonUtils.canDragonBreak(world.func_180495_p(blockpos).func_177230_c())) continue;
                BlockState transformState = IafDragonDestructionManager.transformBlockIce(world.func_180495_p(blockpos));
                world.func_175656_a(blockpos, transformState);
                if (world.field_73012_v.nextInt(9) != 0 || !transformState.func_185904_a().func_76220_a() || !world.func_175623_d(blockpos.func_177984_a()) || !world.func_180495_p(blockpos.func_177977_b()).func_200132_m()) continue;
                world.func_175656_a(blockpos.func_177984_a(), IafBlockRegistry.DRAGON_ICE_SPIKES.func_176223_P());
            }
            for (LivingEntity LivingEntity3 : world.func_217357_a(LivingEntity.class, new AxisAlignedBB((double)center.func_177958_n() - damageRadius, (double)center.func_177956_o() - damageRadius, (double)center.func_177952_p() - damageRadius, (double)center.func_177958_n() + damageRadius, (double)center.func_177956_o() + damageRadius, (double)center.func_177952_p() + damageRadius))) {
                if (DragonUtils.onSameTeam((Entity)destroyer, (Entity)LivingEntity3) || destroyer.func_70028_i((Entity)LivingEntity3) || !destroyer.func_70685_l((Entity)LivingEntity3)) continue;
                LivingEntity3.func_70097_a(IafDamageRegistry.DRAGON_ICE, (float)stage * dmgScale);
                FrozenEntityProperties frozenProps = (FrozenEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)LivingEntity3, FrozenEntityProperties.class);
                if (frozenProps == null) continue;
                frozenProps.setFrozenFor(50 * stage);
            }
        }
    }

    public static void destroyAreaFireCharge(World world, BlockPos center, EntityDragonBase destroyer) {
        if (destroyer != null) {
            if (MinecraftForge.EVENT_BUS.post((Event)new DragonFireDamageWorldEvent(destroyer, center.func_177958_n(), center.func_177956_o(), center.func_177952_p()))) {
                return;
            }
            int stage = destroyer.getDragonStage();
            if (stage <= 3) {
                for (BlockPos pos : BlockPos.func_218281_b((BlockPos)center.func_177982_a(-2, -2, -2), (BlockPos)center.func_177982_a(2, 2, 2)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
                    if (!((double)world.field_73012_v.nextFloat() > pos.func_177951_i((Vec3i)center)) || world.func_180495_p(pos).func_177230_c() instanceof IDragonProof || !DragonUtils.canDragonBreak(world.func_180495_p(pos).func_177230_c())) continue;
                    world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                }
                for (BlockPos pos : BlockPos.func_218281_b((BlockPos)center.func_177982_a(-2, -2, -2), (BlockPos)center.func_177982_a(2, 2, 2)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
                    if (!world.field_73012_v.nextBoolean() || world.func_180495_p(pos).func_177230_c() instanceof IDragonProof || !DragonUtils.canDragonBreak(world.func_180495_p(pos).func_177230_c())) continue;
                    BlockState transformState = IafDragonDestructionManager.transformBlockFire(world.func_180495_p(pos));
                    world.func_175656_a(pos, transformState);
                    if (!world.field_73012_v.nextBoolean() || !transformState.func_185904_a().func_76220_a() || !world.func_175623_d(pos.func_177984_a())) continue;
                    world.func_175656_a(pos.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
                }
                for (LivingEntity LivingEntity2 : world.func_217357_a(LivingEntity.class, new AxisAlignedBB((double)center.func_177958_n() - 2.0, (double)center.func_177956_o() - 2.0, (double)center.func_177952_p() - 2.0, (double)center.func_177958_n() + 2.0, (double)center.func_177956_o() + 2.0, (double)center.func_177952_p() + 2.0))) {
                    if (destroyer.func_184191_r((Entity)LivingEntity2) || destroyer.func_70028_i((Entity)LivingEntity2) || !destroyer.func_70685_l((Entity)LivingEntity2)) continue;
                    LivingEntity2.func_70097_a(IafDamageRegistry.DRAGON_ICE, (float)Math.max(1, stage - 1) * 2.0f);
                    LivingEntity2.func_70015_d(15);
                }
            } else {
                int radius = stage == 4 ? 2 : 3;
                int j = radius + world.field_73012_v.nextInt(2);
                int k = radius + world.field_73012_v.nextInt(2);
                int l = radius + world.field_73012_v.nextInt(2);
                float f = (float)(j + k + l) * 0.333f + 0.5f;
                for (BlockPos blockpos : BlockPos.func_218281_b((BlockPos)center.func_177982_a(-j, -k, -l), (BlockPos)center.func_177982_a(j, k, l)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
                    if (!(blockpos.func_177951_i((Vec3i)center) <= (double)(f * f)) || !(world.field_73012_v.nextFloat() > (float)blockpos.func_177951_i((Vec3i)center) / (f * f)) || world.func_180495_p(blockpos).func_177230_c() instanceof IDragonProof || !DragonUtils.canDragonBreak(world.func_180495_p(blockpos).func_177230_c())) continue;
                    world.func_175656_a(blockpos, Blocks.field_150350_a.func_176223_P());
                }
                for (BlockPos blockpos : BlockPos.func_218281_b((BlockPos)center.func_177982_a(-(++j), -(++k), -(++l)), (BlockPos)center.func_177982_a(j, k, l)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
                    if (!(blockpos.func_177951_i((Vec3i)center) <= (double)(f * f)) || world.func_180495_p(blockpos).func_177230_c() instanceof IDragonProof || !DragonUtils.canDragonBreak(world.func_180495_p(blockpos).func_177230_c())) continue;
                    BlockState transformState = IafDragonDestructionManager.transformBlockFire(world.func_180495_p(blockpos));
                    world.func_175656_a(blockpos, transformState);
                    if (!world.field_73012_v.nextBoolean() || !transformState.func_185904_a().func_76220_a() || !world.func_175623_d(blockpos.func_177984_a())) continue;
                    world.func_175656_a(blockpos.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
                }
                for (LivingEntity LivingEntity3 : world.func_217357_a(LivingEntity.class, new AxisAlignedBB((double)center.func_177958_n() - (double)j, (double)center.func_177956_o() - (double)k, (double)center.func_177952_p() - (double)l, (double)center.func_177958_n() + (double)j, (double)center.func_177956_o() + (double)k, (double)center.func_177952_p() + (double)l))) {
                    if (destroyer.func_184191_r((Entity)LivingEntity3) || destroyer.func_70028_i((Entity)LivingEntity3) || !destroyer.func_70685_l((Entity)LivingEntity3)) continue;
                    LivingEntity3.func_70097_a(IafDamageRegistry.DRAGON_ICE, (float)Math.max(1, stage - 1) * 2.0f);
                    LivingEntity3.func_70015_d(15);
                }
            }
            if (IafConfig.explosiveDragonBreath) {
                BlockLaunchExplosion explosion = new BlockLaunchExplosion(world, (MobEntity)destroyer, center.func_177958_n(), center.func_177956_o(), center.func_177952_p(), Math.min(2, stage - 2));
                explosion.func_77278_a();
                explosion.func_77279_a(true);
            }
        }
    }

    public static void destroyAreaIceCharge(World world, BlockPos center, EntityDragonBase destroyer) {
        if (destroyer != null) {
            if (MinecraftForge.EVENT_BUS.post((Event)new DragonFireDamageWorldEvent(destroyer, center.func_177958_n(), center.func_177956_o(), center.func_177952_p()))) {
                return;
            }
            int stage = destroyer.getDragonStage();
            if (stage <= 3) {
                for (BlockPos pos : BlockPos.func_218281_b((BlockPos)center.func_177982_a(-2, -2, -2), (BlockPos)center.func_177982_a(2, 2, 2)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
                    if (!((double)world.field_73012_v.nextFloat() > pos.func_177951_i((Vec3i)center)) || world.func_180495_p(pos).func_177230_c() instanceof IDragonProof || !DragonUtils.canDragonBreak(world.func_180495_p(pos).func_177230_c())) continue;
                    world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                }
                for (BlockPos pos : BlockPos.func_218281_b((BlockPos)center.func_177982_a(-2, -2, -2), (BlockPos)center.func_177982_a(2, 2, 2)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
                    if (!world.field_73012_v.nextBoolean() || world.func_180495_p(pos).func_177230_c() instanceof IDragonProof || !DragonUtils.canDragonBreak(world.func_180495_p(pos).func_177230_c())) continue;
                    BlockState transformState = IafDragonDestructionManager.transformBlockIce(world.func_180495_p(pos));
                    world.func_175656_a(pos, transformState);
                    if (!world.field_73012_v.nextBoolean() || !transformState.func_200132_m() || !world.func_175623_d(pos.func_177984_a()) || !world.func_180495_p(pos.func_177977_b()).func_200132_m()) continue;
                    world.func_175656_a(pos.func_177984_a(), IafBlockRegistry.DRAGON_ICE_SPIKES.func_176223_P());
                }
                for (LivingEntity LivingEntity2 : world.func_217357_a(LivingEntity.class, new AxisAlignedBB((double)center.func_177958_n() - 2.0, (double)center.func_177956_o() - 2.0, (double)center.func_177952_p() - 2.0, (double)center.func_177958_n() + 2.0, (double)center.func_177956_o() + 2.0, (double)center.func_177952_p() + 2.0))) {
                    if (destroyer.func_184191_r((Entity)LivingEntity2) || destroyer.func_70028_i((Entity)LivingEntity2) || !destroyer.func_70685_l((Entity)LivingEntity2)) continue;
                    LivingEntity2.func_70097_a(IafDamageRegistry.DRAGON_ICE, (float)Math.max(1, stage - 1) * 2.0f);
                    FrozenEntityProperties frozenProps = (FrozenEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)LivingEntity2, FrozenEntityProperties.class);
                    if (frozenProps == null) continue;
                    frozenProps.setFrozenFor(400);
                }
            } else {
                int radius = stage == 4 ? 2 : 3;
                int j = radius + world.field_73012_v.nextInt(2);
                int k = radius + world.field_73012_v.nextInt(2);
                int l = radius + world.field_73012_v.nextInt(2);
                float f = (float)(j + k + l) * 0.333f + 0.5f;
                for (BlockPos blockpos : BlockPos.func_218281_b((BlockPos)center.func_177982_a(-j, -k, -l), (BlockPos)center.func_177982_a(j, k, l)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
                    if (!(blockpos.func_177951_i((Vec3i)center) <= (double)(f * f)) || !(world.field_73012_v.nextFloat() > (float)blockpos.func_177951_i((Vec3i)center) / (f * f)) || world.func_180495_p(blockpos).func_177230_c() instanceof IDragonProof || !DragonUtils.canDragonBreak(world.func_180495_p(blockpos).func_177230_c())) continue;
                    world.func_175656_a(blockpos, Blocks.field_150350_a.func_176223_P());
                }
                for (BlockPos blockpos : BlockPos.func_218281_b((BlockPos)center.func_177982_a(-(++j), -(++k), -(++l)), (BlockPos)center.func_177982_a(j, k, l)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
                    if (!(blockpos.func_177951_i((Vec3i)center) <= (double)(f * f)) || world.func_180495_p(blockpos).func_177230_c() instanceof IDragonProof || !DragonUtils.canDragonBreak(world.func_180495_p(blockpos).func_177230_c())) continue;
                    BlockState transformState = IafDragonDestructionManager.transformBlockIce(world.func_180495_p(blockpos));
                    world.func_175656_a(blockpos, transformState);
                    if (!world.field_73012_v.nextBoolean() || !transformState.func_200132_m() || !world.func_175623_d(blockpos.func_177984_a()) || !world.func_180495_p(blockpos.func_177977_b()).func_200132_m()) continue;
                    world.func_175656_a(blockpos.func_177984_a(), IafBlockRegistry.DRAGON_ICE_SPIKES.func_176223_P());
                }
                for (LivingEntity LivingEntity3 : world.func_217357_a(LivingEntity.class, new AxisAlignedBB((double)center.func_177958_n() - (double)j, (double)center.func_177956_o() - (double)k, (double)center.func_177952_p() - (double)l, (double)center.func_177958_n() + (double)j, (double)center.func_177956_o() + (double)k, (double)center.func_177952_p() + (double)l))) {
                    if (destroyer.func_184191_r((Entity)LivingEntity3) || destroyer.func_70028_i((Entity)LivingEntity3) || !destroyer.func_70685_l((Entity)LivingEntity3)) continue;
                    LivingEntity3.func_70097_a(IafDamageRegistry.DRAGON_ICE, (float)Math.max(1, stage - 1) * 2.0f);
                    FrozenEntityProperties frozenProps = (FrozenEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)LivingEntity3, FrozenEntityProperties.class);
                    if (frozenProps == null) continue;
                    frozenProps.setFrozenFor(400);
                }
            }
            if (IafConfig.explosiveDragonBreath) {
                BlockLaunchExplosion explosion = new BlockLaunchExplosion(world, (MobEntity)destroyer, center.func_177958_n(), center.func_177956_o(), center.func_177952_p(), Math.min(2, stage - 2));
                explosion.func_77278_a();
                explosion.func_77279_a(true);
            }
        }
    }

    public static void destroyAreaLightning(World world, BlockPos center, EntityDragonBase destroyer) {
        if (MinecraftForge.EVENT_BUS.post((Event)new DragonFireDamageWorldEvent(destroyer, center.func_177958_n(), center.func_177956_o(), center.func_177952_p()))) {
            return;
        }
        int stage = destroyer.getDragonStage();
        double damageRadius = 3.5;
        float dmgScale = (float)IafConfig.dragonAttackDamageLightning;
        if (stage <= 3) {
            for (BlockPos pos : BlockPos.func_218281_b((BlockPos)center.func_177982_a(-1, -1, -1), (BlockPos)center.func_177982_a(1, 1, 1)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
                BlockState transformState;
                if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityDragonforgeInput) {
                    ((TileEntityDragonforgeInput)world.func_175625_s(pos)).onHitWithFlame();
                }
                if (IafConfig.dragonGriefing == 2 || !world.field_73012_v.nextBoolean() || world.func_180495_p(pos).func_177230_c() instanceof IDragonProof || !DragonUtils.canDragonBreak(world.func_180495_p(pos).func_177230_c()) || (transformState = IafDragonDestructionManager.transformBlockLightning(world.func_180495_p(pos))).func_177230_c() == world.func_180495_p(pos).func_177230_c()) continue;
                world.func_175656_a(pos, transformState);
            }
            for (LivingEntity LivingEntity2 : world.func_217357_a(LivingEntity.class, new AxisAlignedBB((double)center.func_177958_n() - damageRadius, (double)center.func_177956_o() - damageRadius, (double)center.func_177952_p() - damageRadius, (double)center.func_177958_n() + damageRadius, (double)center.func_177956_o() + damageRadius, (double)center.func_177952_p() + damageRadius))) {
                if (DragonUtils.onSameTeam((Entity)destroyer, (Entity)LivingEntity2) || destroyer.func_70028_i((Entity)LivingEntity2) || !destroyer.func_70685_l((Entity)LivingEntity2)) continue;
                LivingEntity2.func_70097_a(IafDamageRegistry.DRAGON_LIGHTNING, (float)stage * dmgScale);
                double d1 = destroyer.func_226277_ct_() - LivingEntity2.func_226277_ct_();
                double d0 = destroyer.func_226281_cx_() - LivingEntity2.func_226281_cx_();
                LivingEntity2.func_70653_a((Entity)destroyer, 0.3f, d1, d0);
            }
        } else {
            int radius = stage == 4 ? 2 : 3;
            int j = radius + world.field_73012_v.nextInt(1);
            int k = radius + world.field_73012_v.nextInt(1);
            int l = radius + world.field_73012_v.nextInt(1);
            float f = (float)(j + k + l) * 0.333f + 0.5f;
            damageRadius = 2.5f + f * 1.2f;
            for (BlockPos blockpos : BlockPos.func_218281_b((BlockPos)center.func_177982_a(-j, -k, -l), (BlockPos)center.func_177982_a(j, k, l)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
                if (world.func_175625_s(blockpos) != null && world.func_175625_s(blockpos) instanceof TileEntityDragonforgeInput) {
                    ((TileEntityDragonforgeInput)world.func_175625_s(blockpos)).onHitWithFlame();
                }
                if (!(blockpos.func_177951_i((Vec3i)center) <= (double)(f * f)) || IafConfig.dragonGriefing == 2 || !(world.field_73012_v.nextFloat() > (float)blockpos.func_177951_i((Vec3i)center) / (f * f)) || world.func_180495_p(blockpos).func_177230_c() instanceof IDragonProof || !DragonUtils.canDragonBreak(world.func_180495_p(blockpos).func_177230_c())) continue;
                BlockState transformState = IafDragonDestructionManager.transformBlockLightning(world.func_180495_p(blockpos));
                world.func_175656_a(blockpos, transformState);
            }
            for (LivingEntity LivingEntity3 : world.func_217357_a(LivingEntity.class, new AxisAlignedBB((double)center.func_177958_n() - damageRadius, (double)center.func_177956_o() - damageRadius, (double)center.func_177952_p() - damageRadius, (double)center.func_177958_n() + damageRadius, (double)center.func_177956_o() + damageRadius, (double)center.func_177952_p() + damageRadius))) {
                if (DragonUtils.onSameTeam((Entity)destroyer, (Entity)LivingEntity3) || destroyer.func_70028_i((Entity)LivingEntity3) || !destroyer.func_70685_l((Entity)LivingEntity3)) continue;
                LivingEntity3.func_70097_a(IafDamageRegistry.DRAGON_LIGHTNING, (float)stage * dmgScale);
                double d1 = destroyer.func_226277_ct_() - LivingEntity3.func_226277_ct_();
                double d0 = destroyer.func_226281_cx_() - LivingEntity3.func_226281_cx_();
                LivingEntity3.func_70653_a((Entity)destroyer, 0.3f, d1, d0);
            }
        }
    }

    public static void destroyAreaLightningCharge(World world, BlockPos center, EntityDragonBase destroyer) {
        if (destroyer != null) {
            if (MinecraftForge.EVENT_BUS.post((Event)new DragonFireDamageWorldEvent(destroyer, center.func_177958_n(), center.func_177956_o(), center.func_177952_p()))) {
                return;
            }
            int stage = destroyer.getDragonStage();
            if (stage <= 3) {
                for (BlockPos pos : BlockPos.func_218281_b((BlockPos)center.func_177982_a(-2, -2, -2), (BlockPos)center.func_177982_a(2, 2, 2)).map(BlockPos::func_185334_h).collect(Collectors.toList())) {
                    if (!((double)(world.field_73012_v.nextFloat() * 7.0f) > Math.sqrt(center.func_177951_i((Vec3i)pos))) || world.func_180495_p(pos).func_177230_c() instanceof IDragonProof || !DragonUtils.canDragonBreak(world.func_180495_p(pos).func_177230_c())) continue;
                    world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                }
                for (BlockPos pos : BlockPos.func_218281_b((BlockPos)center.func_177982_a(-3, -3, -3), (BlockPos)center.func_177982_a(3, 3, 3)).map(BlockPos::func_185334_h).collect(Collectors.toList())) {
                    if (!((double)(world.field_73012_v.nextFloat() * 7.0f) > Math.sqrt(center.func_177951_i((Vec3i)pos))) || world.func_180495_p(pos).func_177230_c() instanceof IDragonProof || !DragonUtils.canDragonBreak(world.func_180495_p(pos).func_177230_c())) continue;
                    BlockState transformState = IafDragonDestructionManager.transformBlockLightning(world.func_180495_p(pos));
                    world.func_175656_a(pos, transformState);
                }
                for (LivingEntity LivingEntity2 : world.func_217357_a(LivingEntity.class, new AxisAlignedBB((double)center.func_177958_n() - 2.0, (double)center.func_177956_o() - 2.0, (double)center.func_177952_p() - 2.0, (double)center.func_177958_n() + 2.0, (double)center.func_177956_o() + 2.0, (double)center.func_177952_p() + 2.0))) {
                    if (destroyer.func_184191_r((Entity)LivingEntity2) || destroyer.func_70028_i((Entity)LivingEntity2) || !destroyer.func_70685_l((Entity)LivingEntity2)) continue;
                    LivingEntity2.func_70097_a(IafDamageRegistry.DRAGON_LIGHTNING, (float)Math.max(1, stage - 1) * 2.0f);
                    double d1 = destroyer.func_226277_ct_() - LivingEntity2.func_226277_ct_();
                    double d0 = destroyer.func_226281_cx_() - LivingEntity2.func_226281_cx_();
                    LivingEntity2.func_70653_a((Entity)destroyer, 0.9f, d1, d0);
                }
            } else {
                int radius = stage == 4 ? 2 : 3;
                int j = radius + world.field_73012_v.nextInt(2);
                int k = radius + world.field_73012_v.nextInt(2);
                int l = radius + world.field_73012_v.nextInt(2);
                float f = (float)(j + k + l) * 0.333f + 0.5f;
                for (BlockPos blockpos : BlockPos.func_218281_b((BlockPos)center.func_177982_a(-j, -k, -l), (BlockPos)center.func_177982_a(j, k, l)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
                    if (!(blockpos.func_177951_i((Vec3i)center) <= (double)(f * f)) || !(world.field_73012_v.nextFloat() > (float)blockpos.func_177951_i((Vec3i)center) / (f * f)) || world.func_180495_p(blockpos).func_177230_c() instanceof IDragonProof || !DragonUtils.canDragonBreak(world.func_180495_p(blockpos).func_177230_c())) continue;
                    world.func_175656_a(blockpos, Blocks.field_150350_a.func_176223_P());
                }
                for (BlockPos blockpos : BlockPos.func_218281_b((BlockPos)center.func_177982_a(-(++j), -(++k), -(++l)), (BlockPos)center.func_177982_a(j, k, l)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
                    if (!(blockpos.func_177951_i((Vec3i)center) <= (double)(f * f)) || world.func_180495_p(blockpos).func_177230_c() instanceof IDragonProof || !DragonUtils.canDragonBreak(world.func_180495_p(blockpos).func_177230_c())) continue;
                    BlockState transformState = IafDragonDestructionManager.transformBlockLightning(world.func_180495_p(blockpos));
                    world.func_175656_a(blockpos, transformState);
                }
                for (LivingEntity LivingEntity3 : world.func_217357_a(LivingEntity.class, new AxisAlignedBB((double)center.func_177958_n() - (double)j, (double)center.func_177956_o() - (double)k, (double)center.func_177952_p() - (double)l, (double)center.func_177958_n() + (double)j, (double)center.func_177956_o() + (double)k, (double)center.func_177952_p() + (double)l))) {
                    if (destroyer.func_184191_r((Entity)LivingEntity3) || destroyer.func_70028_i((Entity)LivingEntity3) || !destroyer.func_70685_l((Entity)LivingEntity3)) continue;
                    LivingEntity3.func_70097_a(IafDamageRegistry.DRAGON_LIGHTNING, (float)Math.max(1, stage - 1) * 2.0f);
                    double d1 = destroyer.func_226277_ct_() - LivingEntity3.func_226277_ct_();
                    double d0 = destroyer.func_226281_cx_() - LivingEntity3.func_226281_cx_();
                    LivingEntity3.func_70653_a((Entity)destroyer, 0.9f, d1, d0);
                }
            }
            if (IafConfig.explosiveDragonBreath) {
                BlockLaunchExplosion explosion = new BlockLaunchExplosion(world, (MobEntity)destroyer, center.func_177958_n(), center.func_177956_o(), center.func_177952_p(), Math.min(2, stage - 2));
                explosion.func_77278_a();
                explosion.func_77279_a(true);
            }
        }
    }

    public static BlockState transformBlockFire(BlockState in) {
        if (in.func_177230_c() instanceof SpreadableSnowyDirtBlock) {
            return (BlockState)IafBlockRegistry.CHARRED_GRASS.func_176223_P().func_206870_a((IProperty)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_185904_a() == Material.field_151578_c && in.func_177230_c() == Blocks.field_150346_d) {
            return (BlockState)IafBlockRegistry.CHARRED_DIRT.func_176223_P().func_206870_a((IProperty)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_185904_a() == Material.field_151595_p && in.func_177230_c() == Blocks.field_150351_n) {
            return (BlockState)IafBlockRegistry.CHARRED_GRAVEL.func_176223_P().func_206870_a((IProperty)BlockFallingReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_185904_a() == Material.field_151576_e && (in.func_177230_c() == Blocks.field_150347_e || in.func_177230_c().func_149739_a().contains("cobblestone"))) {
            return (BlockState)IafBlockRegistry.CHARRED_COBBLESTONE.func_176223_P().func_206870_a((IProperty)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_185904_a() == Material.field_151576_e && in.func_177230_c() != IafBlockRegistry.CHARRED_COBBLESTONE) {
            return (BlockState)IafBlockRegistry.CHARRED_STONE.func_176223_P().func_206870_a((IProperty)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_177230_c() == Blocks.field_185774_da) {
            return (BlockState)IafBlockRegistry.CHARRED_GRASS_PATH.func_176223_P().func_206870_a((IProperty)BlockCharedPath.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_185904_a() == Material.field_151575_d) {
            return IafBlockRegistry.ASH.func_176223_P();
        }
        if (in.func_185904_a() == Material.field_151584_j || in.func_185904_a() == Material.field_151585_k || in.func_177230_c() == Blocks.field_150433_aE) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return in;
    }

    public static BlockState transformBlockIce(BlockState in) {
        if (in.func_177230_c() instanceof SpreadableSnowyDirtBlock) {
            return (BlockState)IafBlockRegistry.FROZEN_GRASS.func_176223_P().func_206870_a((IProperty)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_185904_a() == Material.field_151578_c && in.func_177230_c() == Blocks.field_150346_d || in.func_185904_a() == Material.field_151596_z) {
            return (BlockState)IafBlockRegistry.FROZEN_DIRT.func_176223_P().func_206870_a((IProperty)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_185904_a() == Material.field_151595_p && in.func_177230_c() == Blocks.field_150351_n) {
            return (BlockState)IafBlockRegistry.FROZEN_GRAVEL.func_176223_P().func_206870_a((IProperty)BlockFallingReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_185904_a() == Material.field_151595_p && in.func_177230_c() != Blocks.field_150351_n) {
            return in;
        }
        if (in.func_185904_a() == Material.field_151576_e && (in.func_177230_c() == Blocks.field_150347_e || in.func_177230_c().func_149739_a().contains("cobblestone"))) {
            return (BlockState)IafBlockRegistry.FROZEN_COBBLESTONE.func_176223_P().func_206870_a((IProperty)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_185904_a() == Material.field_151576_e && in.func_177230_c() != IafBlockRegistry.FROZEN_COBBLESTONE) {
            return (BlockState)IafBlockRegistry.FROZEN_STONE.func_176223_P().func_206870_a((IProperty)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_177230_c() == Blocks.field_185774_da) {
            return (BlockState)IafBlockRegistry.FROZEN_GRASS_PATH.func_176223_P().func_206870_a((IProperty)BlockCharedPath.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_185904_a() == Material.field_151575_d) {
            return IafBlockRegistry.FROZEN_SPLINTERS.func_176223_P();
        }
        if (in.func_185904_a() == Material.field_151586_h) {
            return Blocks.field_150432_aD.func_176223_P();
        }
        if (in.func_185904_a() == Material.field_151584_j || in.func_185904_a() == Material.field_151585_k || in.func_177230_c() == Blocks.field_150433_aE) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return in;
    }

    public static BlockState transformBlockLightning(BlockState in) {
        if (in.func_177230_c() instanceof SpreadableSnowyDirtBlock) {
            return (BlockState)IafBlockRegistry.CRACKLED_GRASS.func_176223_P().func_206870_a((IProperty)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_185904_a() == Material.field_151578_c && in.func_177230_c() == Blocks.field_150346_d) {
            return (BlockState)IafBlockRegistry.CRACKLED_DIRT.func_176223_P().func_206870_a((IProperty)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_185904_a() == Material.field_151595_p && in.func_177230_c() == Blocks.field_150351_n) {
            return (BlockState)IafBlockRegistry.CRACKLED_GRAVEL.func_176223_P().func_206870_a((IProperty)BlockFallingReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_185904_a() == Material.field_151576_e && (in.func_177230_c() == Blocks.field_150347_e || in.func_177230_c().func_149739_a().contains("cobblestone"))) {
            return (BlockState)IafBlockRegistry.CRACKLED_COBBLESTONE.func_176223_P().func_206870_a((IProperty)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_185904_a() == Material.field_151576_e && in.func_177230_c() != IafBlockRegistry.CRACKLED_COBBLESTONE) {
            return (BlockState)IafBlockRegistry.CRACKLED_STONE.func_176223_P().func_206870_a((IProperty)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_177230_c() == Blocks.field_185774_da) {
            return (BlockState)IafBlockRegistry.CRACKLED_GRASS_PATH.func_176223_P().func_206870_a((IProperty)BlockCharedPath.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_185904_a() == Material.field_151575_d) {
            return IafBlockRegistry.ASH.func_176223_P();
        }
        if (in.func_185904_a() == Material.field_151584_j || in.func_185904_a() == Material.field_151585_k || in.func_177230_c() == Blocks.field_150433_aE) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return in;
    }
}

