/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.Vec3d;

public class DragonAIWander
extends Goal {
    private EntityDragonBase dragon;
    private double xPosition;
    private double yPosition;
    private double zPosition;
    private double speed;
    private int executionChance;
    private boolean mustUpdate;

    public DragonAIWander(EntityDragonBase creatureIn, double speedIn) {
        this(creatureIn, speedIn, 20);
    }

    public DragonAIWander(EntityDragonBase creatureIn, double speedIn, int chance) {
        this.dragon = creatureIn;
        this.speed = speedIn;
        this.executionChance = chance;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (!this.dragon.canMove()) {
            return false;
        }
        if (this.dragon.func_184179_bs() != null) {
            return false;
        }
        if (this.dragon.isFlying() || this.dragon.isHovering()) {
            return false;
        }
        if (!this.mustUpdate && this.dragon.func_70681_au().nextInt(this.executionChance) != 0) {
            return false;
        }
        Vec3d vec3d = RandomPositionGenerator.func_75463_a((CreatureEntity)this.dragon, (int)10, (int)7);
        if (vec3d == null) {
            return false;
        }
        this.xPosition = vec3d.field_72450_a;
        this.yPosition = vec3d.field_72448_b;
        this.zPosition = vec3d.field_72449_c;
        this.mustUpdate = false;
        return true;
    }

    public boolean func_75253_b() {
        return !this.dragon.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        this.dragon.func_70661_as().func_75492_a(this.xPosition, this.yPosition, this.zPosition, this.speed);
    }

    public void makeUpdate() {
        this.mustUpdate = true;
    }

    public void setExecutionChance(int newchance) {
        this.executionChance = newchance;
    }
}

