/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.api.event.GenericGriefEvent;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexBase;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexWorker;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class MyrmexAIForage
extends Goal {
    private static final int RADIUS = 8;
    private final EntityMyrmexWorker myrmex;
    private final BlockSorter targetSorter;
    private BlockPos targetBlock = null;
    private int wanderRadius = 16;

    public MyrmexAIForage(EntityMyrmexWorker myrmex) {
        this.myrmex = myrmex;
        this.targetSorter = new BlockSorter();
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (!this.myrmex.canMove() || this.myrmex.holdingSomething() || !this.myrmex.func_70661_as().func_75500_f() || !this.myrmex.canSeeSky() || this.myrmex.shouldEnterHive() || !this.myrmex.keepSearching) {
            return false;
        }
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.func_218281_b((BlockPos)this.myrmex.func_180425_c().func_177982_a(-8, -4, -8), (BlockPos)this.myrmex.func_180425_c().func_177982_a(8, 4, 8)).map(BlockPos::func_185334_h).collect(Collectors.toList())) {
            if (MinecraftForge.EVENT_BUS.post((Event)new GenericGriefEvent((LivingEntity)this.myrmex, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) || !EntityMyrmexBase.isEdibleBlock(this.myrmex.field_70170_p.func_180495_p(pos))) continue;
            allBlocks.add(pos);
            this.myrmex.keepSearching = false;
        }
        if (allBlocks.isEmpty()) {
            this.myrmex.keepSearching = true;
            this.wanderRadius += 8;
            Vec3d vec = RandomPositionGenerator.func_75463_a((CreatureEntity)this.myrmex, (int)this.wanderRadius, (int)7);
            if (vec != null) {
                this.targetBlock = new BlockPos(vec);
            }
            return this.targetBlock != null;
        }
        allBlocks.sort(this.targetSorter);
        this.targetBlock = (BlockPos)allBlocks.get(0);
        return this.targetBlock != null;
    }

    public boolean func_75253_b() {
        if (this.targetBlock == null) {
            return false;
        }
        if (this.myrmex.shouldEnterHive()) {
            this.myrmex.keepSearching = false;
            return false;
        }
        return this.myrmex.func_70661_as().func_75500_f();
    }

    public void func_75246_d() {
        if (this.myrmex.keepSearching) {
            if (this.targetBlock != null) {
                if (this.myrmex.func_70661_as().func_75500_f()) {
                    this.myrmex.func_70661_as().func_75492_a((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o(), (double)this.targetBlock.func_177952_p() + 0.5, 1.0);
                }
                if (this.myrmex.func_70092_e((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o() + 0.5, (double)this.targetBlock.func_177952_p() + 0.5) < 4.0) {
                    this.func_75251_c();
                }
            }
        } else if (this.targetBlock != null) {
            double distance;
            this.myrmex.func_70661_as().func_75492_a((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o(), (double)this.targetBlock.func_177952_p() + 0.5, 1.0);
            BlockState block = this.myrmex.field_70170_p.func_180495_p(this.targetBlock);
            if (EntityMyrmexBase.isEdibleBlock(block) && (distance = this.getDistance(this.targetBlock)) < 6.0) {
                block.func_177230_c();
                List drops = Block.func_220070_a((BlockState)block, (ServerWorld)((ServerWorld)this.myrmex.field_70170_p), (BlockPos)this.targetBlock, (TileEntity)this.myrmex.field_70170_p.func_175625_s(this.targetBlock));
                if (!drops.isEmpty()) {
                    this.myrmex.field_70170_p.func_175655_b(this.targetBlock, false);
                    ItemStack heldStack = ((ItemStack)drops.get(0)).func_77946_l();
                    heldStack.func_190920_e(1);
                    ((ItemStack)drops.get(0)).func_190918_g(1);
                    this.myrmex.func_184611_a(Hand.MAIN_HAND, heldStack);
                    for (ItemStack stack : drops) {
                        ItemEntity itemEntity = new ItemEntity(this.myrmex.field_70170_p, (double)this.targetBlock.func_177958_n() + this.myrmex.func_70681_au().nextDouble(), (double)this.targetBlock.func_177956_o() + this.myrmex.func_70681_au().nextDouble(), (double)this.targetBlock.func_177952_p() + this.myrmex.func_70681_au().nextDouble(), stack);
                        itemEntity.func_174869_p();
                        if (this.myrmex.field_70170_p.field_72995_K) continue;
                        this.myrmex.field_70170_p.func_217376_c((Entity)itemEntity);
                    }
                    this.targetBlock = null;
                    this.func_75251_c();
                    this.myrmex.keepSearching = false;
                    this.wanderRadius = 8;
                    return;
                }
            }
        }
    }

    public void func_75251_c() {
        this.targetBlock = null;
        this.myrmex.keepSearching = true;
    }

    private double getDistance(BlockPos pos) {
        double deltaX = this.myrmex.func_226277_ct_() - ((double)pos.func_177958_n() + 0.5);
        double deltaY = this.myrmex.func_226278_cu_() + (double)this.myrmex.func_70047_e() - ((double)pos.func_177956_o() + 0.5);
        double deltaZ = this.myrmex.func_226281_cx_() - ((double)pos.func_177952_p() + 0.5);
        return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
    }

    public class BlockSorter
    implements Comparator<BlockPos> {
        @Override
        public int compare(BlockPos pos1, BlockPos pos2) {
            double distance1 = MyrmexAIForage.this.getDistance(pos1);
            double distance2 = MyrmexAIForage.this.getDistance(pos2);
            return Double.compare(distance1, distance2);
        }
    }
}

