/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.entity.EntityPixie;
import com.github.alexthe666.iceandfire.entity.ai.DragonAITargetItems;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.util.math.AxisAlignedBB;

public class PixieAIPickupItem<T extends ItemEntity>
extends TargetGoal {
    protected final DragonAITargetItems.Sorter theNearestAttackableTargetSorter;
    protected final Predicate<? super ItemEntity> targetEntitySelector;
    protected ItemEntity targetEntity;

    public PixieAIPickupItem(EntityPixie creature, boolean checkSight) {
        this(creature, checkSight, false);
    }

    public PixieAIPickupItem(EntityPixie creature, boolean checkSight, boolean onlyNearby) {
        this(creature, 20, checkSight, onlyNearby, null);
    }

    public PixieAIPickupItem(final EntityPixie creature, int chance, boolean checkSight, boolean onlyNearby, @Nullable Predicate<? super T> targetSelector) {
        super((MobEntity)creature, checkSight, onlyNearby);
        this.theNearestAttackableTargetSorter = new DragonAITargetItems.Sorter((Entity)creature);
        this.targetEntitySelector = new Predicate<ItemEntity>(){

            public boolean apply(@Nullable ItemEntity item) {
                return item instanceof ItemEntity && !item.func_92059_d().func_190926_b() && (item.func_92059_d().func_77973_b() == Items.field_222070_lD && !creature.func_70909_n() || item.func_92059_d().func_77973_b() == Items.field_151102_aT && creature.func_70909_n() && creature.func_110143_aJ() < creature.func_110138_aP());
            }
        };
    }

    public boolean func_75250_a() {
        List list = this.field_75299_d.field_70170_p.func_175647_a(ItemEntity.class, this.getTargetableArea(this.func_111175_f()), this.targetEntitySelector);
        if (list.isEmpty()) {
            return false;
        }
        Collections.sort(list, this.theNearestAttackableTargetSorter);
        this.targetEntity = (ItemEntity)list.get(0);
        return true;
    }

    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, targetDistance, targetDistance);
    }

    public void func_75249_e() {
        this.field_75299_d.func_70605_aq().func_75642_a(this.targetEntity.func_226277_ct_(), this.targetEntity.func_226278_cu_(), this.targetEntity.func_226281_cx_(), 0.25);
        if (this.field_75299_d.func_70638_az() == null) {
            this.field_75299_d.func_70671_ap().func_75650_a(this.targetEntity.func_226277_ct_(), this.targetEntity.func_226278_cu_(), this.targetEntity.func_226281_cx_(), 180.0f, 20.0f);
        }
        super.func_75249_e();
    }

    public void func_75246_d() {
        super.func_75246_d();
        if (this.targetEntity == null || this.targetEntity != null && !this.targetEntity.func_70089_S()) {
            this.func_75251_c();
        }
        if (this.targetEntity != null && this.targetEntity.func_70089_S() && this.field_75299_d.func_70068_e((Entity)this.targetEntity) < 1.0) {
            EntityPixie pixie = (EntityPixie)this.field_75299_d;
            if (this.targetEntity.func_92059_d() != null && this.targetEntity.func_92059_d().func_77973_b() != null && this.targetEntity.func_92059_d().func_77973_b() == Items.field_151102_aT) {
                pixie.func_70691_i(5.0f);
            }
            if (this.targetEntity.func_92059_d() != null && this.targetEntity.func_92059_d().func_77973_b() != null && this.targetEntity.func_92059_d().func_77973_b() == Items.field_222070_lD && !pixie.func_70909_n() && this.targetEntity.func_200214_m() != null && this.field_75299_d.field_70170_p.func_217371_b(this.targetEntity.func_200214_m()) != null) {
                PlayerEntity owner = this.field_75299_d.field_70170_p.func_217371_b(this.targetEntity.func_200214_m());
                pixie.func_70903_f(true);
                pixie.func_184754_b(owner.func_110124_au());
                pixie.func_70904_g(true);
            }
            this.targetEntity.func_92059_d().func_190918_g(1);
            pixie.func_184185_a(IafSoundRegistry.PIXIE_TAUNT, 1.0f, 1.0f);
            this.func_75251_c();
        }
    }

    public boolean func_75253_b() {
        return true;
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity theEntity;

        public Sorter(Entity theEntityIn) {
            this.theEntity = theEntityIn;
        }

        @Override
        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d1;
            double d0 = this.theEntity.func_70068_e(p_compare_1_);
            return d0 < (d1 = this.theEntity.func_70068_e(p_compare_2_)) ? -1 : (d0 > d1 ? 1 : 0);
        }
    }
}

