/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.entity.EntitySeaSerpent;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SeaSerpentAIAttackMelee
extends Goal {
    protected final int attackInterval = 20;
    protected EntitySeaSerpent attacker;
    protected int attackTick;
    World world;
    double speedTowardsTarget;
    boolean longMemory;
    Path path;
    private int delayCounter;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;

    public SeaSerpentAIAttackMelee(EntitySeaSerpent amphithere, double speedIn, boolean useLongMemory) {
        this.attacker = amphithere;
        this.world = amphithere.field_70170_p;
        this.speedTowardsTarget = speedIn;
        this.longMemory = useLongMemory;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        LivingEntity LivingEntity2 = this.attacker.func_70638_az();
        if (LivingEntity2 == null || !this.attacker.field_70122_E) {
            return false;
        }
        if (!LivingEntity2.func_70089_S()) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.delayCounter <= 0) {
                this.path = this.attacker.func_70661_as().func_75494_a((Entity)LivingEntity2, 0);
                this.delayCounter = 4 + this.attacker.func_70681_au().nextInt(7);
                return this.path != null;
            }
            return true;
        }
        this.path = this.attacker.func_70661_as().func_75494_a((Entity)LivingEntity2, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(LivingEntity2) >= this.attacker.func_70092_e(LivingEntity2.func_226277_ct_(), LivingEntity2.func_174813_aQ().field_72338_b, LivingEntity2.func_226281_cx_());
    }

    public boolean func_75253_b() {
        LivingEntity LivingEntity2 = this.attacker.func_70638_az();
        if (LivingEntity2 == null) {
            return false;
        }
        if (!LivingEntity2.func_70089_S()) {
            return false;
        }
        if (!this.longMemory) {
            return !this.attacker.func_70661_as().func_75500_f();
        }
        if (!this.attacker.func_213389_a(new BlockPos((Entity)LivingEntity2))) {
            return false;
        }
        return !(LivingEntity2 instanceof PlayerEntity) || !LivingEntity2.func_175149_v() && !((PlayerEntity)LivingEntity2).func_184812_l_();
    }

    public void func_75249_e() {
        if (this.attacker.func_70090_H()) {
            this.attacker.func_70605_aq().func_75642_a(this.targetX, this.targetY, this.targetZ, (double)0.1f);
        } else {
            this.attacker.func_70661_as().func_75484_a(this.path, this.speedTowardsTarget);
        }
        this.delayCounter = 0;
    }

    public void func_75251_c() {
        LivingEntity LivingEntity2 = this.attacker.func_70638_az();
        if (LivingEntity2 instanceof PlayerEntity && (LivingEntity2.func_175149_v() || ((PlayerEntity)LivingEntity2).func_184812_l_())) {
            this.attacker.func_70624_b(null);
        }
        this.attacker.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        LivingEntity LivingEntity2 = this.attacker.func_70638_az();
        if (LivingEntity2 != null) {
            if (this.attacker.func_70090_H()) {
                this.attacker.func_70605_aq().func_75642_a(LivingEntity2.func_226277_ct_(), LivingEntity2.func_226278_cu_() + (double)LivingEntity2.func_70047_e(), LivingEntity2.func_226281_cx_(), 0.1);
            }
            this.attacker.func_70671_ap().func_75651_a((Entity)LivingEntity2, 30.0f, 30.0f);
            double d0 = this.attacker.func_70092_e(LivingEntity2.func_226277_ct_(), LivingEntity2.func_174813_aQ().field_72338_b, LivingEntity2.func_226281_cx_());
            --this.delayCounter;
            if ((this.longMemory || this.attacker.func_70635_at().func_75522_a((Entity)LivingEntity2)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || LivingEntity2.func_70092_e(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.attacker.func_70681_au().nextFloat() < 0.05f)) {
                this.targetX = LivingEntity2.func_226277_ct_();
                this.targetY = LivingEntity2.func_174813_aQ().field_72338_b;
                this.targetZ = LivingEntity2.func_226281_cx_();
                this.delayCounter = 4 + this.attacker.func_70681_au().nextInt(7);
                if (this.canPenalize) {
                    PathPoint finalPathPoint;
                    this.delayCounter += this.failedPathFindingPenalty;
                    this.failedPathFindingPenalty = this.attacker.func_70661_as().func_75505_d() != null ? ((finalPathPoint = this.attacker.func_70661_as().func_75505_d().func_75870_c()) != null && LivingEntity2.func_70092_e((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                }
                if (d0 > 1024.0) {
                    this.delayCounter += 10;
                } else if (d0 > 256.0) {
                    this.delayCounter += 5;
                }
                if (!this.attacker.func_70661_as().func_75497_a((Entity)LivingEntity2, this.speedTowardsTarget)) {
                    this.delayCounter += 15;
                }
            }
            this.attackTick = Math.max(this.attackTick - 1, 0);
            this.checkAndPerformAttack(LivingEntity2, d0);
        }
    }

    protected void checkAndPerformAttack(LivingEntity enemy, double distToEnemySqr) {
        double d0 = this.getAttackReachSqr(enemy);
        if (distToEnemySqr <= d0) {
            this.attackTick = 20;
            this.attacker.func_184609_a(Hand.MAIN_HAND);
            this.attacker.func_70652_k((Entity)enemy);
        }
    }

    protected double getAttackReachSqr(LivingEntity attackTarget) {
        return this.attacker.func_213311_cf() * 2.0f * this.attacker.func_213311_cf() * 2.0f + attackTarget.func_213311_cf();
    }
}

