/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.props;

import com.github.alexthe666.citadel.server.entity.EntityProperties;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.message.MessageAddChainedEntity;
import com.github.alexthe666.iceandfire.message.MessageRemoveChainedEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;

public class ChainEntityProperties
extends EntityProperties<LivingEntity> {
    public List<Entity> connectedEntities = new ArrayList<Entity>();
    public boolean alreadyIgnoresCamera = false;
    public boolean wasJustDisconnected = false;
    private List<UUID> connectedEntityUUID = new ArrayList<UUID>();

    public int getTrackingTime() {
        return 20;
    }

    public void saveNBTData(CompoundNBT compound) {
        ListNBT nbttaglist = new ListNBT();
        for (UUID uuid : this.connectedEntityUUID) {
            CompoundNBT CompoundNBT2 = new CompoundNBT();
            CompoundNBT2.func_186854_a("UUID", uuid);
            nbttaglist.add((Object)CompoundNBT2);
        }
        compound.func_218657_a("ConnectedEntities", (INBT)nbttaglist);
    }

    public void loadNBTData(CompoundNBT compound) {
        ListNBT nbttaglist = compound.func_150295_c("ConnectedEntities", 10);
        this.connectedEntityUUID = new ArrayList<UUID>();
        for (int i = 0; i < nbttaglist.size(); ++i) {
            INBT cNbt = nbttaglist.get(i);
            if (!(cNbt instanceof CompoundNBT)) continue;
            this.connectedEntityUUID.add(((CompoundNBT)cNbt).func_186857_a("UUID"));
        }
        this.updateConnectedEntities(this.getEntity());
    }

    public void clearChained() {
        this.connectedEntities.clear();
        this.connectedEntityUUID.clear();
    }

    public boolean isChained() {
        return !this.connectedEntityUUID.isEmpty();
    }

    public void init() {
        this.updateConnectedEntities(this.getEntity());
        this.alreadyIgnoresCamera = ((LivingEntity)this.getEntity()).field_70158_ak;
    }

    public void addChain(Entity parent, Entity entity) {
        this.minimizeLists();
        if (!this.connectedEntityUUID.contains(entity.func_110124_au())) {
            this.connectedEntityUUID.add(entity.func_110124_au());
        }
        this.updateConnectedEntities(parent);
    }

    public void removeChain(Entity us, Entity entity) {
        this.minimizeLists();
        this.connectedEntityUUID.remove(entity.func_110124_au());
        this.connectedEntities.remove(entity);
        if (entity != null && !entity.field_70170_p.field_72995_K) {
            IceAndFire.sendMSGToAll(new MessageRemoveChainedEntity(us.func_145782_y(), entity.func_145782_y()));
        }
        this.wasJustDisconnected = true;
    }

    public List<Entity> getCurrentConnectedEntities() {
        return this.connectedEntities;
    }

    public void minimizeLists() {
        ArrayList<UUID> noDupesUUID = new ArrayList<UUID>();
        for (UUID uuid : this.connectedEntityUUID) {
            if (noDupesUUID.contains(uuid)) continue;
            noDupesUUID.add(uuid);
        }
        this.connectedEntityUUID = noDupesUUID;
        ArrayList<Entity> noDupesEntity = new ArrayList<Entity>();
        ArrayList<UUID> addedUUIDs = new ArrayList<UUID>();
        for (Entity entity : this.connectedEntities) {
            if (addedUUIDs.contains(entity.func_110124_au())) continue;
            addedUUIDs.add(entity.func_110124_au());
            noDupesEntity.add(entity);
        }
        this.connectedEntities = noDupesEntity;
    }

    public void updateConnectedEntities(Entity toUpdate) {
        this.connectedEntities.clear();
        ArrayList<UUID> addedUUIDs = new ArrayList<UUID>();
        if (toUpdate != null) {
            World world = toUpdate.field_70170_p;
            if (!this.connectedEntityUUID.isEmpty() && world != null && !world.field_72995_K) {
                this.minimizeLists();
                for (UUID uuid : this.connectedEntityUUID) {
                    Entity entity;
                    if (world.func_73046_m() == null || (entity = world.func_73046_m().func_71218_a(world.func_201675_m().func_186058_p()).func_217461_a(uuid)) == null || addedUUIDs.contains(entity.func_110124_au())) continue;
                    addedUUIDs.add(entity.func_110124_au());
                    IceAndFire.sendMSGToAll(new MessageAddChainedEntity(toUpdate.func_145782_y(), entity.func_145782_y()));
                    this.connectedEntities.add(entity);
                }
            }
        }
    }

    public String getID() {
        return "Ice And Fire - Chain Property Tracker";
    }

    public Class<LivingEntity> getEntityClass() {
        return LivingEntity.class;
    }

    public boolean isConnectedToEntity(Entity parent, Entity entity) {
        this.updateConnectedEntities(parent);
        return this.connectedEntities.contains(entity);
    }
}

