/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemDragonHorn
extends Item {
    public ItemDragonHorn() {
        super(new Item.Properties().func_200916_a(IceAndFire.TAB_ITEMS).func_200917_a(1));
        this.setRegistryName("iceandfire", "dragon_horn");
        this.func_185043_a(new ResourceLocation("iceorfire"), new IItemPropertyGetter(){

            @OnlyIn(value=Dist.CLIENT)
            public float call(ItemStack itemStack, @Nullable World world, @Nullable LivingEntity livingEntity) {
                return (float)ItemDragonHorn.getDragonType(itemStack) * 0.25f;
            }
        });
    }

    public static int getDragonType(ItemStack stack) {
        String id;
        if (stack.func_77978_p() != null && EntityType.func_220327_a((String)(id = stack.func_77978_p().func_74779_i("DragonHornEntityID"))).isPresent()) {
            EntityType entityType = (EntityType)EntityType.func_220327_a((String)id).get();
            if (entityType == IafEntityRegistry.FIRE_DRAGON) {
                return 1;
            }
            if (entityType == IafEntityRegistry.ICE_DRAGON) {
                return 2;
            }
            if (entityType == IafEntityRegistry.LIGHTNING_DRAGON) {
                return 3;
            }
        }
        return 0;
    }

    public void func_77622_d(ItemStack itemStack, World world, PlayerEntity player) {
        itemStack.func_77982_d(new CompoundNBT());
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        ItemStack trueStack = playerIn.func_184586_b(hand);
        if (!playerIn.field_70170_p.field_72995_K && target instanceof EntityDragonBase && ((EntityDragonBase)target).func_152114_e((LivingEntity)playerIn) && (trueStack.func_77978_p() == null || trueStack.func_77978_p() != null && trueStack.func_77978_p().func_74775_l("EntityTag").isEmpty())) {
            CompoundNBT entityTag = new CompoundNBT();
            target.func_213281_b(entityTag);
            CompoundNBT newTag = new CompoundNBT();
            newTag.func_74778_a("DragonHornEntityID", Registry.field_212629_r.func_177774_c((Object)target.func_200600_R()).toString());
            newTag.func_218657_a("EntityTag", (INBT)entityTag);
            trueStack.func_77982_d(newTag);
            playerIn.func_184609_a(hand);
            playerIn.field_70170_p.func_184133_a(playerIn, playerIn.func_180425_c(), SoundEvents.field_187941_ho, SoundCategory.NEUTRAL, 3.0f, 0.75f);
            target.func_70106_y();
            return true;
        }
        return false;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_196000_l() != Direction.UP) {
            return ActionResultType.FAIL;
        }
        ItemStack stack = context.func_195999_j().func_184586_b(context.func_221531_n());
        if (stack.func_77978_p() != null && !stack.func_77978_p().func_74779_i("DragonHornEntityID").isEmpty()) {
            World world = context.func_195991_k();
            String id = stack.func_77978_p().func_74779_i("DragonHornEntityID");
            EntityType type = EntityType.func_220327_a((String)id).orElse(null);
            if (type != null) {
                Entity entity = type.func_200721_a(world);
                if (entity instanceof EntityDragonBase) {
                    EntityDragonBase dragon = (EntityDragonBase)entity;
                    dragon.func_70037_a(stack.func_77978_p().func_74775_l("EntityTag"));
                }
                entity.func_70012_b((double)context.func_195995_a().func_177958_n() + 0.5, (double)(context.func_195995_a().func_177956_o() + 1), (double)context.func_195995_a().func_177952_p() + 0.5, context.func_195999_j().field_70177_z, 0.0f);
                if (world.func_217376_c(entity)) {
                    stack.func_77982_d(new CompoundNBT());
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        String id;
        CompoundNBT entityTag;
        if (stack.func_77978_p() != null && !(entityTag = stack.func_77978_p().func_74775_l("EntityTag")).isEmpty() && EntityType.func_220327_a((String)(id = stack.func_77978_p().func_74779_i("DragonHornEntityID"))).isPresent()) {
            ITextComponent component;
            EntityType type = (EntityType)EntityType.func_220327_a((String)id).get();
            tooltip.add(new TranslationTextComponent(type.func_210760_d(), new Object[0]).func_211708_a(this.getTextColorForEntityType(type)));
            String name = new TranslationTextComponent("dragon.unnamed", new Object[0]).getString();
            if (!entityTag.func_74779_i("CustomName").isEmpty() && (component = ITextComponent.Serializer.func_150699_a((String)entityTag.func_74779_i("CustomName"))) != null) {
                name = component.getString();
            }
            tooltip.add(new StringTextComponent(name).func_211708_a(TextFormatting.GRAY));
            String gender = new TranslationTextComponent("dragon.gender", new Object[0]).func_150254_d() + " " + new TranslationTextComponent(entityTag.func_74767_n("Gender") ? "dragon.gender.male" : "dragon.gender.female", new Object[0]).func_150254_d();
            tooltip.add(new StringTextComponent(gender).func_211708_a(TextFormatting.GRAY));
            int stagenumber = entityTag.func_74762_e("AgeTicks") / 24000;
            int stage1 = 0;
            stage1 = stagenumber >= 100 ? 5 : (stagenumber >= 75 ? 4 : (stagenumber >= 50 ? 3 : (stagenumber >= 25 ? 2 : 1)));
            String stage = new TranslationTextComponent("dragon.stage", new Object[0]).func_150254_d() + " " + stage1 + " " + new TranslationTextComponent("dragon.days.front", new Object[0]).func_150254_d() + stagenumber + " " + new TranslationTextComponent("dragon.days.back", new Object[0]).func_150254_d();
            tooltip.add(new StringTextComponent(stage).func_211708_a(TextFormatting.GRAY));
        }
    }

    private TextFormatting getTextColorForEntityType(EntityType type) {
        if (type == IafEntityRegistry.FIRE_DRAGON) {
            return TextFormatting.DARK_RED;
        }
        if (type == IafEntityRegistry.ICE_DRAGON) {
            return TextFormatting.BLUE;
        }
        if (type == IafEntityRegistry.LIGHTNING_DRAGON) {
            return TextFormatting.DARK_PURPLE;
        }
        return TextFormatting.GRAY;
    }
}

