/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexEgg;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.item.ICustomRendered;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemMyrmexEgg
extends Item
implements ICustomRendered {
    boolean isJungle;

    public ItemMyrmexEgg(boolean isJungle) {
        super(new Item.Properties().func_200916_a(IceAndFire.TAB_ITEMS).func_200917_a(1));
        this.isJungle = isJungle;
        this.setRegistryName("iceandfire", isJungle ? "myrmex_jungle_egg" : "myrmex_desert_egg");
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            for (int i = 0; i < 5; ++i) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                CompoundNBT tag = new CompoundNBT();
                tag.func_74768_a("EggOrdinal", i);
                stack.func_77982_d(tag);
                items.add((Object)stack);
            }
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        String caste;
        CompoundNBT tag = stack.func_77978_p();
        int eggOrdinal = 0;
        if (tag != null) {
            eggOrdinal = tag.func_74762_e("EggOrdinal");
        }
        switch (eggOrdinal) {
            default: {
                caste = "worker";
                break;
            }
            case 1: {
                caste = "soldier";
                break;
            }
            case 2: {
                caste = "royal";
                break;
            }
            case 3: {
                caste = "sentinel";
                break;
            }
            case 4: {
                caste = "queen";
            }
        }
        if (eggOrdinal == 4) {
            tooltip.add(new TranslationTextComponent("myrmex.caste_" + caste + ".name", new Object[0]).func_211708_a(TextFormatting.LIGHT_PURPLE));
        } else {
            tooltip.add(new TranslationTextComponent("myrmex.caste_" + caste + ".name", new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack itemstack = context.func_195999_j().func_184586_b(context.func_221531_n());
        BlockPos offset = context.func_195995_a().func_177972_a(context.func_196000_l());
        EntityMyrmexEgg egg = new EntityMyrmexEgg(IafEntityRegistry.MYRMEX_EGG, context.func_195991_k());
        CompoundNBT tag = itemstack.func_77978_p();
        int eggOrdinal = 0;
        if (tag != null) {
            eggOrdinal = tag.func_74762_e("EggOrdinal");
        }
        egg.setJungle(this.isJungle);
        egg.setMyrmexCaste(eggOrdinal);
        egg.func_70012_b((double)offset.func_177958_n() + 0.5, offset.func_177956_o(), (double)offset.func_177952_p() + 0.5, 0.0f, 0.0f);
        egg.onPlayerPlace(context.func_195999_j());
        if (!context.func_195991_k().field_72995_K) {
            context.func_195991_k().func_217376_c((Entity)egg);
        }
        itemstack.func_190918_g(1);
        return ActionResultType.SUCCESS;
    }

    public boolean func_77636_d(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        int eggOrdinal = 0;
        if (tag != null) {
            eggOrdinal = tag.func_74762_e("EggOrdinal");
        }
        return super.func_77636_d(stack) || eggOrdinal == 4;
    }
}

