/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.message;

import com.github.alexthe666.citadel.server.entity.EntityPropertiesHandler;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.props.StoneEntityProperties;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageStoneStatue {
    public int entityId;
    public boolean isStone;

    public MessageStoneStatue(int entityId, boolean isStone) {
        this.entityId = entityId;
        this.isStone = isStone;
    }

    public MessageStoneStatue() {
    }

    public static MessageStoneStatue read(PacketBuffer buf) {
        return new MessageStoneStatue(buf.readInt(), buf.readBoolean());
    }

    public static void write(MessageStoneStatue message, PacketBuffer buf) {
        buf.writeInt(message.entityId);
        buf.writeBoolean(message.isStone);
    }

    public static class Handler {
        public static void handle(MessageStoneStatue message, Supplier<NetworkEvent.Context> context) {
            Entity entity;
            context.get().setPacketHandled(true);
            ServerPlayerEntity player = context.get().getSender();
            if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                player = IceAndFire.PROXY.getClientSidePlayer();
            }
            if (player != null && (entity = player.field_70170_p.func_73045_a(message.entityId)) != null && entity instanceof LivingEntity) {
                StoneEntityProperties properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties(entity, StoneEntityProperties.class);
                properties.setStone(message.isStone);
            }
        }
    }
}

