/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.world.BiomeGlacier;
import com.github.alexthe666.iceandfire.world.SurfaceBuilderGlacier;
import com.github.alexthe666.iceandfire.world.gen.WorldGenCyclopsCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenFireDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenFireDragonRoosts;
import com.github.alexthe666.iceandfire.world.gen.WorldGenHydraCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenIceDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenIceDragonRoosts;
import com.github.alexthe666.iceandfire.world.gen.WorldGenLightningDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenLightningDragonRoosts;
import com.github.alexthe666.iceandfire.world.gen.WorldGenMobSpawn;
import com.github.alexthe666.iceandfire.world.gen.WorldGenMyrmexHive;
import com.github.alexthe666.iceandfire.world.gen.WorldGenPixieVillage;
import com.github.alexthe666.iceandfire.world.gen.WorldGenSirenIsland;
import com.github.alexthe666.iceandfire.world.structure.DreadMausoleumStructure;
import com.github.alexthe666.iceandfire.world.structure.GorgonTemplePiece;
import com.github.alexthe666.iceandfire.world.structure.GorgonTempleStructure;
import com.github.alexthe666.iceandfire.world.structure.GraveyardPiece;
import com.github.alexthe666.iceandfire.world.structure.GraveyardStructure;
import com.github.alexthe666.iceandfire.world.structure.MausoleumPiece;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;

public class IafWorldRegistry {
    public static final SurfaceBuilderGlacier GLACIER_SURFACE_BUILDER = new SurfaceBuilderGlacier(SurfaceBuilderConfig::func_215455_a);
    public static Biome GLACIER_BIOME = new BiomeGlacier();
    public static Feature<NoFeatureConfig> FIRE_DRAGON_ROOST;
    public static Feature<NoFeatureConfig> ICE_DRAGON_ROOST;
    public static Feature<NoFeatureConfig> LIGHTNING_DRAGON_ROOST;
    public static Feature<NoFeatureConfig> FIRE_DRAGON_CAVE;
    public static Feature<NoFeatureConfig> ICE_DRAGON_CAVE;
    public static Feature<NoFeatureConfig> LIGHTNING_DRAGON_CAVE;
    public static Feature<NoFeatureConfig> CYCLOPS_CAVE;
    public static Feature<NoFeatureConfig> PIXIE_VILLAGE;
    public static Feature<NoFeatureConfig> SIREN_ISLAND;
    public static Feature<NoFeatureConfig> HYDRA_CAVE;
    public static Feature<NoFeatureConfig> MYRMEX_HIVE_DESERT;
    public static Feature<NoFeatureConfig> MYRMEX_HIVE_JUNGLE;
    public static Feature<NoFeatureConfig> MOB_SPAWNS;
    public static IStructurePieceType MAUSOLEUM_PIECE;
    public static Structure<NoFeatureConfig> MAUSOLEUM;
    public static IStructurePieceType GORGON_PIECE;
    public static Structure<NoFeatureConfig> GORGON_TEMPLE;
    public static IStructurePieceType GRAVEYARD_PIECE;
    public static Structure<NoFeatureConfig> GRAVEYARD;

    public static void register() {
        FIRE_DRAGON_ROOST = (Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:fire_dragon_roost", (Object)((Object)new WorldGenFireDragonRoosts(NoFeatureConfig::func_214639_a)));
        ICE_DRAGON_ROOST = (Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:ice_dragon_roost", (Object)((Object)new WorldGenIceDragonRoosts(NoFeatureConfig::func_214639_a)));
        LIGHTNING_DRAGON_ROOST = (Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:lightning_dragon_roost", (Object)((Object)new WorldGenLightningDragonRoosts(NoFeatureConfig::func_214639_a)));
        FIRE_DRAGON_CAVE = (Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:fire_dragon_cave", (Object)((Object)new WorldGenFireDragonCave(NoFeatureConfig::func_214639_a)));
        ICE_DRAGON_CAVE = (Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:ice_dragon_cave", (Object)((Object)new WorldGenIceDragonCave(NoFeatureConfig::func_214639_a)));
        LIGHTNING_DRAGON_CAVE = (Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:lightning_dragon_cave", (Object)((Object)new WorldGenLightningDragonCave(NoFeatureConfig::func_214639_a)));
        CYCLOPS_CAVE = (Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:cyclops_cave", (Object)((Object)new WorldGenCyclopsCave(NoFeatureConfig::func_214639_a)));
        PIXIE_VILLAGE = (Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:pixie_village", (Object)((Object)new WorldGenPixieVillage(NoFeatureConfig::func_214639_a)));
        SIREN_ISLAND = (Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:siren_island", (Object)((Object)new WorldGenSirenIsland(NoFeatureConfig::func_214639_a)));
        HYDRA_CAVE = (Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:hydra_cave", (Object)((Object)new WorldGenHydraCave(NoFeatureConfig::func_214639_a)));
        MYRMEX_HIVE_DESERT = (Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:myrmex_hive_desert", (Object)((Object)new WorldGenMyrmexHive(false, false, NoFeatureConfig::func_214639_a)));
        MYRMEX_HIVE_JUNGLE = (Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:myrmex_hive_jungle", (Object)((Object)new WorldGenMyrmexHive(false, true, NoFeatureConfig::func_214639_a)));
        MOB_SPAWNS = (Feature)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:mob_spawns", (Object)((Object)new WorldGenMobSpawn(NoFeatureConfig::func_214639_a)));
        MAUSOLEUM_PIECE = (IStructurePieceType)Registry.func_218325_a((Registry)Registry.field_218362_C, (String)"iceandfire:mausoleum_piece", MausoleumPiece.Piece::new);
        MAUSOLEUM = (Structure)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:mausoleum", MAUSOLEUM);
        Registry.func_218325_a((Registry)Registry.field_218361_B, (String)"iceandfire:mausoleum", MAUSOLEUM);
        GORGON_PIECE = (IStructurePieceType)Registry.func_218325_a((Registry)Registry.field_218362_C, (String)"iceandfire:gorgon_piece", GorgonTemplePiece.Piece::new);
        GORGON_TEMPLE = (Structure)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:gorgon_temple", GORGON_TEMPLE);
        Registry.func_218325_a((Registry)Registry.field_218361_B, (String)"iceandfire:gorgon_temple", GORGON_TEMPLE);
        GRAVEYARD_PIECE = (IStructurePieceType)Registry.func_218325_a((Registry)Registry.field_218362_C, (String)"iceandfire:graveyard_piece", GraveyardPiece.Piece::new);
        GRAVEYARD = (Structure)Registry.func_218325_a((Registry)Registry.field_218379_q, (String)"iceandfire:graveyard", GRAVEYARD);
        Registry.func_218325_a((Registry)Registry.field_218361_B, (String)"iceandfire:graveyard", GRAVEYARD);
    }

    public static void setup() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OVERWORLD)) {
                biome.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, MOB_SPAWNS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                if (!(BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH))) {
                    biome.func_226711_a_(GRAVEYARD.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                    biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, GRAVEYARD.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
                }
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA)) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(IafBlockRegistry.FIRE_LILY.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(1).func_227322_d_()).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA)) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(IafBlockRegistry.LIGHTNING_LILY.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(1).func_227322_d_()).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
            }
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(IafBlockRegistry.FROST_LILY.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(1).func_227322_d_()).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
            }
            if (IafConfig.generateSilverOre) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, IafBlockRegistry.SILVER_ORE.func_176223_P(), 8)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(2, 0, 0, 32))));
            }
            if (IafConfig.generateCopperOre) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, IafBlockRegistry.COPPER_ORE.func_176223_P(), 5)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(10, 32, 32, 80))));
            }
            if (IafConfig.generateSapphireOre && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202294_an.func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_150348_b.func_176223_P(), IafBlockRegistry.SAPPHIRE_ORE.func_176223_P())).func_227228_a_(Placement.field_215004_C.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
            }
            if (IafConfig.generateAmythestOre && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA)) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202294_an.func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_150348_b.func_176223_P(), IafBlockRegistry.AMYTHEST_ORE.func_176223_P())).func_227228_a_(Placement.field_215004_C.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
            }
            if (!(BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN))) {
                if (IafConfig.generateDragonRoosts) {
                    if (biome.func_201851_b() == Biome.RainType.SNOW || (double)biome.func_185353_n() < 0.0) {
                        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, ICE_DRAGON_ROOST.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                    } else if (biome.func_201851_b() != Biome.RainType.SNOW && (double)biome.func_185353_n() >= 0.0 && (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MESA) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE))) {
                        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, LIGHTNING_DRAGON_ROOST.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                    } else if (biome.func_201851_b() != Biome.RainType.SNOW && (double)biome.func_185353_n() >= 0.0) {
                        biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, FIRE_DRAGON_ROOST.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                    }
                    if (biome.func_201851_b() == Biome.RainType.SNOW || (double)biome.func_185353_n() < 0.0) {
                        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, ICE_DRAGON_CAVE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                    } else if (biome.func_201851_b() != Biome.RainType.SNOW && (double)biome.func_185353_n() >= 0.0 && (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MESA) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE))) {
                        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, LIGHTNING_DRAGON_CAVE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                    } else if (biome.func_201851_b() != Biome.RainType.SNOW && (double)biome.func_185353_n() >= 0.0) {
                        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, FIRE_DRAGON_CAVE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                    }
                }
                if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) {
                    biome.func_226711_a_(GORGON_TEMPLE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                    biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, GORGON_TEMPLE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
                    biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, CYCLOPS_CAVE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                }
                if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                    biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, HYDRA_CAVE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                }
                if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY)) {
                    biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, PIXIE_VILLAGE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                }
                if (biome.func_201851_b() == Biome.RainType.SNOW || (double)biome.func_185353_n() < 0.0 && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                    biome.func_226711_a_(MAUSOLEUM.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                    biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, MAUSOLEUM.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
                }
                if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY)) {
                    biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, MYRMEX_HIVE_DESERT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                }
                if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) continue;
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, MYRMEX_HIVE_JUNGLE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                continue;
            }
            if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) continue;
            biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, SIREN_ISLAND.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }
    }

    public static boolean isFarEnoughFromSpawn(IWorld world, BlockPos pos) {
        BlockPos spawnRelative = new BlockPos(0, pos.func_177956_o(), 0);
        boolean spawnCheck = spawnRelative.func_177951_i((Vec3i)pos) > IafConfig.dangerousWorldGenDistanceLimit * IafConfig.dangerousWorldGenDistanceLimit;
        return spawnCheck;
    }

    public static boolean isDimensionListed(IWorld world) {
        ResourceLocation name = world.func_201675_m().func_186058_p().getRegistryName();
        if (name == null) {
            return false;
        }
        if (IafConfig.useDimensionBlackList) {
            for (String string : IafConfig.blacklistedDimensions) {
                if (!name.toString().equals(string)) continue;
                return false;
            }
            return true;
        }
        for (String string : IafConfig.whitelistedDimensions) {
            if (!name.toString().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDimensionListedForDragons(IWorld world) {
        ResourceLocation name = world.func_201675_m().func_186058_p().getRegistryName();
        if (name == null) {
            return false;
        }
        if (IafConfig.useDimensionBlackList) {
            for (String string : IafConfig.dragonBlacklistedDimensions) {
                if (!name.toString().equals(string)) continue;
                return false;
            }
            return true;
        }
        for (String string : IafConfig.dragonWhitelistedDimensions) {
            if (!name.toString().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFarEnoughFromDangerousGen(IWorld world, BlockPos pos) {
        return true;
    }

    static {
        MAUSOLEUM = new DreadMausoleumStructure(NoFeatureConfig::func_214639_a);
        GORGON_TEMPLE = new GorgonTempleStructure(NoFeatureConfig::func_214639_a);
        GRAVEYARD = new GraveyardStructure(NoFeatureConfig::func_214639_a);
        GLACIER_SURFACE_BUILDER.setRegistryName("iceandfire:glacier_surface");
    }
}

