/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.event.WorldGenUtils;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import com.github.alexthe666.iceandfire.world.gen.WorldGenIceDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenRoostArch;
import com.github.alexthe666.iceandfire.world.gen.WorldGenRoostBoulder;
import com.github.alexthe666.iceandfire.world.gen.WorldGenRoostGoldPile;
import com.github.alexthe666.iceandfire.world.gen.WorldGenRoostPile;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class WorldGenIceDragonRoosts
extends Feature<NoFeatureConfig> {
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private static boolean isMale;
    private BlockPos lastIceRoost = BlockPos.field_177992_a;

    public WorldGenIceDragonRoosts(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    private void transformState(IWorld world, BlockPos blockpos, BlockState state) {
        float hardness = state.func_177230_c().func_176195_g(state, (IBlockReader)world, blockpos);
        if (hardness != -1.0f) {
            if (state.func_177230_c() instanceof ContainerBlock) {
                return;
            }
            if (state.func_185904_a() == Material.field_151577_b) {
                world.func_180501_a(blockpos, IafBlockRegistry.FROZEN_GRASS.func_176223_P(), 2);
            } else if (state.func_185904_a() == Material.field_151578_c && state.func_177230_c() == Blocks.field_150346_d) {
                world.func_180501_a(blockpos, IafBlockRegistry.FROZEN_DIRT.func_176223_P(), 2);
            } else if (state.func_185904_a() == Material.field_151578_c && state.func_177230_c() == Blocks.field_150351_n) {
                world.func_180501_a(blockpos, IafBlockRegistry.FROZEN_GRAVEL.func_176223_P(), 2);
            } else if (state.func_185904_a() == Material.field_151576_e && (state.func_177230_c() == Blocks.field_150347_e || state.func_177230_c().func_149739_a().contains("cobblestone"))) {
                world.func_180501_a(blockpos, IafBlockRegistry.FROZEN_COBBLESTONE.func_176223_P(), 2);
            } else if (state.func_185904_a() == Material.field_151576_e && state.func_177230_c() != IafBlockRegistry.FROZEN_COBBLESTONE) {
                world.func_180501_a(blockpos, IafBlockRegistry.FROZEN_STONE.func_176223_P(), 2);
            } else if (state.func_177230_c() == Blocks.field_185774_da) {
                world.func_180501_a(blockpos, IafBlockRegistry.FROZEN_GRASS_PATH.func_176223_P(), 2);
            } else if (state.func_185904_a() == Material.field_151575_d) {
                world.func_180501_a(blockpos, IafBlockRegistry.FROZEN_SPLINTERS.func_176223_P(), 2);
            } else if (state.func_185904_a() == Material.field_151584_j || state.func_185904_a() == Material.field_151585_k) {
                world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 2);
            }
        }
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos position, NoFeatureConfig config) {
        int radius;
        if (!IafWorldRegistry.isDimensionListedForDragons(worldIn)) {
            return false;
        }
        if (!IafConfig.generateDragonRoosts || rand.nextInt(IafConfig.generateDragonRoostChance) != 0 || !IafWorldRegistry.isFarEnoughFromSpawn(worldIn, position)) {
            return false;
        }
        if (!worldIn.func_204610_c(worldIn.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, position).func_177977_b()).func_206888_e()) {
            return false;
        }
        position = worldIn.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, position);
        isMale = rand.nextBoolean();
        boolean boulders = false;
        int j = radius = 12 + rand.nextInt(8);
        int k = 2;
        int l = radius;
        float f = (float)(j + k + l) * 0.333f + 0.5f;
        for (Object blockpos : BlockPos.func_218281_b((BlockPos)position.func_177982_a(-j, k, -l), (BlockPos)position.func_177982_a(j, 0, l)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
            int yAdd = blockpos.func_177956_o() - position.func_177956_o();
            if (!(blockpos.func_177951_i((Vec3i)position) <= (double)(f * f)) || yAdd >= 2 + rand.nextInt(k) || worldIn.func_175623_d(blockpos.func_177977_b())) continue;
            worldIn.func_180501_a((BlockPos)blockpos, IafBlockRegistry.FROZEN_GRASS.func_176223_P(), 2);
        }
        for (Object blockpos : BlockPos.func_218281_b((BlockPos)position.func_177982_a(-j, k, -l), (BlockPos)position.func_177982_a(j, 0, l)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
            if (worldIn.func_180495_p((BlockPos)blockpos).func_177230_c() != IafBlockRegistry.FROZEN_GRASS || worldIn.func_175623_d(blockpos.func_177984_a())) continue;
            worldIn.func_180501_a((BlockPos)blockpos, IafBlockRegistry.FROZEN_DIRT.func_176223_P(), 2);
        }
        j = radius;
        k = radius / 5;
        l = radius;
        f = (float)(j + k + l) * 0.333f + 0.5f;
        for (Object blockpos : BlockPos.func_218281_b((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, 1, l)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
            if (blockpos.func_177951_i((Vec3i)position) < (double)(f * f)) {
                worldIn.func_180501_a((BlockPos)blockpos, rand.nextBoolean() ? IafBlockRegistry.FROZEN_GRAVEL.func_176223_P() : IafBlockRegistry.FROZEN_DIRT.func_176223_P(), 2);
            }
            if (blockpos.func_177951_i((Vec3i)position) != (double)(f * f)) continue;
            worldIn.func_180501_a((BlockPos)blockpos, rand.nextBoolean() ? IafBlockRegistry.FROZEN_COBBLESTONE.func_176223_P() : IafBlockRegistry.FROZEN_COBBLESTONE.func_176223_P(), 2);
        }
        j = radius -= 2;
        k = 2;
        l = radius;
        f = (float)(j + k + l) * 0.333f + 0.5f;
        BlockPos up = position.func_177981_b(k - 1);
        for (BlockPos blockpos : BlockPos.func_218281_b((BlockPos)up.func_177982_a(-j, -k + 2, -l), (BlockPos)up.func_177982_a(j, k, l)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
            if (!(blockpos.func_177951_i((Vec3i)position) <= (double)(f * f))) continue;
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 2);
        }
        j = radius += 15;
        k = radius / 5;
        l = radius;
        f = (float)(j + k + l) * 0.333f + 0.5f;
        for (Object blockpos : BlockPos.func_218281_b((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
            BlockPos height;
            if (!(blockpos.func_177951_i((Vec3i)position) <= (double)(f * f))) continue;
            double dist = blockpos.func_177951_i((Vec3i)position) / (double)(f * f);
            if (!worldIn.func_175623_d(position) && rand.nextDouble() > dist * 0.5) {
                this.transformState(worldIn, (BlockPos)blockpos, worldIn.func_180495_p((BlockPos)blockpos));
            }
            if (dist > 0.5 && rand.nextInt(1000) == 0) {
                height = worldIn.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, (BlockPos)blockpos);
                new WorldGenRoostBoulder(IafBlockRegistry.FROZEN_COBBLESTONE, rand.nextInt(3), true).generate(worldIn, rand, height);
            }
            if (rand.nextInt(1000) == 0) {
                height = worldIn.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, (BlockPos)blockpos);
                new WorldGenRoostPile(IafBlockRegistry.DRAGON_ICE).generate(worldIn, rand, height);
            }
            if (dist < 0.3 && rand.nextInt(isMale ? 200 : 300) == 0) {
                height = WorldGenUtils.degradeSurface(worldIn, worldIn.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, (BlockPos)blockpos)).func_177984_a();
                new WorldGenRoostGoldPile(IafBlockRegistry.SILVER_PILE).generate(worldIn, rand, height);
            }
            if (dist < 0.3 && rand.nextInt(isMale ? 500 : 700) == 0) {
                TileEntity tileentity1;
                height = WorldGenUtils.degradeSurface(worldIn, worldIn.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, (BlockPos)blockpos)).func_177984_a();
                worldIn.func_180501_a(height, (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)HORIZONTALS[new Random().nextInt(3)]), 2);
                if (worldIn.func_180495_p(height).func_177230_c() instanceof ChestBlock && (tileentity1 = worldIn.func_175625_s(height)) instanceof ChestTileEntity) {
                    ((ChestTileEntity)tileentity1).func_189404_a(WorldGenIceDragonCave.ICEDRAGON_CHEST, new Random().nextLong());
                }
            }
            if (rand.nextInt(5000) != 0) continue;
            height = worldIn.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, (BlockPos)blockpos);
            new WorldGenRoostArch(IafBlockRegistry.FROZEN_COBBLESTONE).generate(worldIn, rand, height);
        }
        EntityIceDragon dragon = (EntityIceDragon)IafEntityRegistry.ICE_DRAGON.func_200721_a(worldIn.func_201672_e());
        dragon.setGender(isMale);
        dragon.growDragon(40 + radius);
        dragon.setAgingDisabled(true);
        dragon.func_70606_j(dragon.func_110138_aP());
        dragon.setVariant(new Random().nextInt(4));
        dragon.func_70080_a((double)position.func_177958_n() + 0.5, (double)worldIn.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, position).func_177956_o() + 1.5, (double)position.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
        dragon.homePos = position;
        dragon.hasHomePosition = true;
        dragon.setHunger(50);
        worldIn.func_217376_c((Entity)dragon);
        return true;
    }
}

