/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.block.BlockGoldPile;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.util.MyrmexHive;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class WorldGenMyrmexDecoration {
    public static final ResourceLocation MYRMEX_GOLD_CHEST = new ResourceLocation("iceandfire", "chest/myrmex_loot_chest");
    public static final ResourceLocation DESERT_MYRMEX_FOOD_CHEST = new ResourceLocation("iceandfire", "chest/myrmex_desert_food_chest");
    public static final ResourceLocation JUNGLE_MYRMEX_FOOD_CHEST = new ResourceLocation("iceandfire", "chest/myrmex_jungle_food_chest");
    public static final ResourceLocation MYRMEX_TRASH_CHEST = new ResourceLocation("iceandfire", "chest/myrmex_trash_chest");
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public static void generateSkeleton(IWorld worldIn, BlockPos blockpos, BlockPos origin, int radius, Random rand) {
        if (worldIn.func_180495_p(blockpos.func_177977_b()).func_224755_d((IBlockReader)worldIn, blockpos.func_177977_b(), Direction.UP)) {
            Direction direction = Direction.func_176731_b((int)rand.nextInt(3));
            Direction.Axis oppositeAxis = direction.func_176740_k() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
            int maxRibHeight = rand.nextInt(2);
            for (int spine = 0; spine < 5 + rand.nextInt(2) * 2; ++spine) {
                BlockPos segment = blockpos.func_177967_a(direction, spine);
                if (origin.func_177951_i((Vec3i)segment) <= (double)(radius * radius)) {
                    worldIn.func_180501_a(segment, (BlockState)Blocks.field_189880_di.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)direction.func_176740_k()), 2);
                }
                if (spine % 2 == 0) continue;
                BlockPos rightRib = segment.func_177972_a(direction.func_176735_f());
                BlockPos leftRib = segment.func_177972_a(direction.func_176746_e());
                if (origin.func_177951_i((Vec3i)rightRib) <= (double)(radius * radius)) {
                    worldIn.func_180501_a(rightRib, (BlockState)Blocks.field_189880_di.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)oppositeAxis), 2);
                }
                if (origin.func_177951_i((Vec3i)leftRib) <= (double)(radius * radius)) {
                    worldIn.func_180501_a(leftRib, (BlockState)Blocks.field_189880_di.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)oppositeAxis), 2);
                }
                for (int ribHeight = 1; ribHeight < maxRibHeight + 2; ++ribHeight) {
                    if (origin.func_177951_i((Vec3i)rightRib.func_177981_b(ribHeight).func_177972_a(direction.func_176735_f())) <= (double)(radius * radius)) {
                        worldIn.func_180501_a(rightRib.func_177981_b(ribHeight).func_177972_a(direction.func_176735_f()), (BlockState)Blocks.field_189880_di.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y), 2);
                    }
                    if (!(origin.func_177951_i((Vec3i)leftRib.func_177981_b(ribHeight).func_177972_a(direction.func_176746_e())) <= (double)(radius * radius))) continue;
                    worldIn.func_180501_a(leftRib.func_177981_b(ribHeight).func_177972_a(direction.func_176746_e()), (BlockState)Blocks.field_189880_di.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y), 2);
                }
                if (origin.func_177951_i((Vec3i)rightRib.func_177981_b(maxRibHeight + 2)) <= (double)(radius * radius)) {
                    worldIn.func_180501_a(rightRib.func_177981_b(maxRibHeight + 2), (BlockState)Blocks.field_189880_di.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)oppositeAxis), 2);
                }
                if (!(origin.func_177951_i((Vec3i)leftRib.func_177981_b(maxRibHeight + 2)) <= (double)(radius * radius))) continue;
                worldIn.func_180501_a(leftRib.func_177981_b(maxRibHeight + 2), (BlockState)Blocks.field_189880_di.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)oppositeAxis), 2);
            }
        }
    }

    public static void generateLeaves(IWorld worldIn, BlockPos blockpos, BlockPos origin, int radius, Random rand) {
        if (worldIn.func_180495_p(blockpos.func_177977_b()).func_224755_d((IBlockReader)worldIn, blockpos.func_177977_b(), Direction.UP)) {
            BlockState leaf = (BlockState)Blocks.field_196642_W.func_176223_P().func_206870_a((IProperty)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true));
            for (BiomeDictionary.Type type : BiomeDictionary.getTypes((Biome)worldIn.func_226691_t_(blockpos))) {
                if (type == BiomeDictionary.Type.SANDY || type == BiomeDictionary.Type.SAVANNA || type == BiomeDictionary.Type.WASTELAND) {
                    leaf = (BlockState)Blocks.field_196642_W.func_176223_P().func_206870_a((IProperty)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true));
                    break;
                }
                if (type == BiomeDictionary.Type.JUNGLE) {
                    leaf = (BlockState)Blocks.field_196648_Z.func_176223_P().func_206870_a((IProperty)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true));
                    break;
                }
                if (type != BiomeDictionary.Type.CONIFEROUS) continue;
                leaf = (BlockState)Blocks.field_196645_X.func_176223_P().func_206870_a((IProperty)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true));
                break;
            }
            int i1 = 0;
            for (int i = 0; i1 >= 0 && i < 3; ++i) {
                int j = i1 + rand.nextInt(2);
                int k = i1 + rand.nextInt(2);
                int l = i1 + rand.nextInt(2);
                float f = (float)(j + k + l) * 0.333f + 0.5f;
                for (BlockPos pos : BlockPos.func_218281_b((BlockPos)blockpos.func_177982_a(-j, -k, -l), (BlockPos)blockpos.func_177982_a(j, k, l)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
                    if (!(pos.func_177951_i((Vec3i)blockpos) <= (double)(f * f)) || !worldIn.func_175623_d(pos)) continue;
                    worldIn.func_180501_a(pos, leaf, 4);
                }
                blockpos = blockpos.func_177982_a(-(i1 + 1) + rand.nextInt(2 + i1 * 2), 0 - rand.nextInt(2), -(i1 + 1) + rand.nextInt(2 + i1 * 2));
            }
        }
    }

    public static void generatePumpkins(IWorld worldIn, BlockPos blockpos, BlockPos origin, int radius, Random rand) {
        if (worldIn.func_180495_p(blockpos.func_177977_b()).func_224755_d((IBlockReader)worldIn, blockpos.func_177977_b(), Direction.UP)) {
            worldIn.func_180501_a(blockpos, BiomeDictionary.hasType((Biome)worldIn.func_226691_t_(blockpos), (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) ? Blocks.field_150440_ba.func_176223_P() : Blocks.field_150423_aK.func_176223_P(), 2);
        }
    }

    public static void generateCocoon(IWorld worldIn, BlockPos blockpos, Random rand, boolean jungle, ResourceLocation lootTable) {
        if (worldIn.func_180495_p(blockpos.func_177977_b()).func_224755_d((IBlockReader)worldIn, blockpos.func_177977_b(), Direction.UP)) {
            worldIn.func_180501_a(blockpos, jungle ? IafBlockRegistry.JUNGLE_MYRMEX_COCOON.func_176223_P() : IafBlockRegistry.DESERT_MYRMEX_COCOON.func_176223_P(), 3);
            if (worldIn.func_175625_s(blockpos) != null && worldIn.func_175625_s(blockpos) instanceof LockableLootTileEntity) {
                TileEntity tileentity1 = worldIn.func_175625_s(blockpos);
                ((LockableLootTileEntity)tileentity1).func_189404_a(lootTable, rand.nextLong());
            }
        }
    }

    public static void generateMushrooms(IWorld worldIn, BlockPos blockpos, BlockPos origin, int radius, Random rand) {
        if (worldIn.func_180495_p(blockpos.func_177977_b()).func_224755_d((IBlockReader)worldIn, blockpos.func_177977_b(), Direction.UP)) {
            worldIn.func_180501_a(blockpos, rand.nextBoolean() ? Blocks.field_150338_P.func_176223_P() : Blocks.field_150337_Q.func_176223_P(), 2);
        }
    }

    public static void generateGold(IWorld worldIn, BlockPos blockpos, BlockPos origin, int radius, Random rand) {
        BlockState gold = IafBlockRegistry.GOLD_PILE.func_176223_P();
        int choice = rand.nextInt(2);
        if (choice == 1) {
            gold = IafBlockRegistry.SILVER_PILE.func_176223_P();
        } else if (choice == 2) {
            gold = IafBlockRegistry.COPPER_PILE.func_176223_P();
        }
        if (worldIn.func_180495_p(blockpos.func_177977_b()).func_224755_d((IBlockReader)worldIn, blockpos.func_177977_b(), Direction.UP)) {
            worldIn.func_180501_a(blockpos, (BlockState)gold.func_206870_a((IProperty)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(8)), 3);
            worldIn.func_180501_a(MyrmexHive.getGroundedPos(worldIn, blockpos.func_177978_c()), (BlockState)gold.func_206870_a((IProperty)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
            worldIn.func_180501_a(MyrmexHive.getGroundedPos(worldIn, blockpos.func_177968_d()), (BlockState)gold.func_206870_a((IProperty)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
            worldIn.func_180501_a(MyrmexHive.getGroundedPos(worldIn, blockpos.func_177976_e()), (BlockState)gold.func_206870_a((IProperty)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
            worldIn.func_180501_a(MyrmexHive.getGroundedPos(worldIn, blockpos.func_177974_f()), (BlockState)gold.func_206870_a((IProperty)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
            if (rand.nextInt(3) == 0) {
                TileEntity tileentity1;
                worldIn.func_180501_a(blockpos.func_177984_a(), (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)HORIZONTALS[new Random().nextInt(3)]), 2);
                if (worldIn.func_180495_p(blockpos.func_177984_a()).func_177230_c() instanceof ChestBlock && (tileentity1 = worldIn.func_175625_s(blockpos.func_177984_a())) instanceof ChestTileEntity) {
                    ((ChestTileEntity)tileentity1).func_189404_a(MYRMEX_GOLD_CHEST, rand.nextLong());
                }
            }
        }
    }

    public static void generateTrashHeap(IWorld worldIn, BlockPos blockpos, BlockPos origin, int radius, Random rand) {
        if (worldIn.func_180495_p(blockpos.func_177977_b()).func_224755_d((IBlockReader)worldIn, blockpos.func_177977_b(), Direction.UP)) {
            Block blob = Blocks.field_150346_d;
            switch (rand.nextInt(3)) {
                case 0: {
                    blob = Blocks.field_150346_d;
                    break;
                }
                case 1: {
                    blob = Blocks.field_150354_m;
                    break;
                }
                case 2: {
                    blob = Blocks.field_150347_e;
                    break;
                }
                case 3: {
                    blob = Blocks.field_150351_n;
                }
            }
            int i1 = 0;
            for (int i = 0; i1 >= 0 && i < 3; ++i) {
                int j = i1 + rand.nextInt(2);
                int k = i1 + rand.nextInt(2);
                int l = i1 + rand.nextInt(2);
                float f = (float)(j + k + l) * 0.333f + 0.5f;
                for (BlockPos pos : BlockPos.func_218281_b((BlockPos)blockpos.func_177982_a(-j, -k, -l), (BlockPos)blockpos.func_177982_a(j, k, l)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
                    if (!(pos.func_177951_i((Vec3i)blockpos) <= (double)(f * f))) continue;
                    worldIn.func_180501_a(pos, blob.func_176223_P(), 4);
                }
                blockpos = blockpos.func_177982_a(-(i1 + 1) + rand.nextInt(2 + i1 * 2), 0 - rand.nextInt(2), -(i1 + 1) + rand.nextInt(2 + i1 * 2));
            }
        }
    }

    public static void generateTrashOre(IWorld worldIn, BlockPos blockpos, BlockPos origin, int radius, Random rand) {
        Block current = worldIn.func_180495_p(blockpos).func_177230_c();
        if (origin.func_177951_i((Vec3i)blockpos) <= (double)(radius * radius) && (current == Blocks.field_150346_d || current == Blocks.field_150354_m || current == Blocks.field_150347_e || current == Blocks.field_150351_n)) {
            Block ore = Blocks.field_150450_ax;
            if (rand.nextInt(3) == 0) {
                Block block = ore = rand.nextBoolean() ? Blocks.field_150352_o : IafBlockRegistry.SILVER_ORE;
                if (rand.nextInt(2) == 0) {
                    ore = IafBlockRegistry.COPPER_ORE;
                }
            } else if (rand.nextInt(3) == 0) {
                ore = Blocks.field_150482_ag;
            } else if (rand.nextInt(2) == 0) {
                Block block = ore = rand.nextBoolean() ? Blocks.field_150412_bA : IafBlockRegistry.SAPPHIRE_ORE;
                if (rand.nextInt(2) == 0) {
                    ore = IafBlockRegistry.AMYTHEST_ORE;
                }
            }
            worldIn.func_180501_a(blockpos, ore.func_176223_P(), 2);
        }
    }
}

