/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;

public class WorldGenRoostSpike {
    private Direction direction;

    public WorldGenRoostSpike(Direction direction) {
        this.direction = direction;
    }

    public boolean generate(IWorld worldIn, Random rand, BlockPos position) {
        int radius = 5;
        for (int i = 0; i < 5; ++i) {
            int j = Math.max(0, radius - (int)((float)i * 1.75f));
            int l = radius - i;
            int k = Math.max(0, radius - (int)((float)i * 1.5f));
            float f = (float)(j + l) * 0.333f + 0.5f;
            BlockPos up = position.func_177984_a().func_177967_a(this.direction, i);
            int xOrZero = this.direction.func_176740_k() == Direction.Axis.Z ? j : 0;
            int zOrZero = this.direction.func_176740_k() == Direction.Axis.Z ? 0 : k;
            for (BlockPos blockpos : BlockPos.func_218281_b((BlockPos)up.func_177982_a(-xOrZero, -l, -zOrZero), (BlockPos)up.func_177982_a(xOrZero, l, zOrZero)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
                if (!(blockpos.func_177951_i((Vec3i)position) <= (double)(f * f))) continue;
                int height = Math.max(blockpos.func_177956_o() - up.func_177956_o(), 0);
                if (i <= 0) {
                    if (!(rand.nextFloat() < (float)height * 0.3f)) continue;
                    worldIn.func_180501_a(blockpos, IafBlockRegistry.CRACKLED_STONE.func_176223_P(), 2);
                    continue;
                }
                worldIn.func_180501_a(blockpos, IafBlockRegistry.CRACKLED_STONE.func_176223_P(), 2);
            }
        }
        return true;
    }
}

