/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.EntitySiren;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class WorldGenSirenIsland
extends Feature<NoFeatureConfig> {
    public WorldGenSirenIsland(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    private int getRadius(int layer, int up) {
        return layer > up ? (int)((double)layer * 0.25) + up : layer;
    }

    private BlockState getStone(Random random) {
        int chance = random.nextInt(100);
        if (chance > 90) {
            return Blocks.field_150341_Y.func_176223_P();
        }
        if (chance > 70) {
            return Blocks.field_150351_n.func_176223_P();
        }
        if (chance > 45) {
            return Blocks.field_150347_e.func_176223_P();
        }
        return Blocks.field_150348_b.func_176223_P();
    }

    private void spawnSiren(IWorld worldIn, Random rand, BlockPos position) {
        EntitySiren siren = new EntitySiren(IafEntityRegistry.SIREN, worldIn.func_201672_e());
        siren.setSinging(true);
        siren.setHairColor(rand.nextInt(2));
        siren.setSingingPose(rand.nextInt(2));
        siren.func_70080_a((double)position.func_177958_n() + 0.5, position.func_177956_o() + 1, (double)position.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
        worldIn.func_217376_c((Entity)siren);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos position, NoFeatureConfig config) {
        BlockPos stonePos;
        float j;
        float i;
        if (!IafWorldRegistry.isDimensionListed(worldIn)) {
            return false;
        }
        if (!(IafConfig.generateSirenIslands && rand.nextInt(IafConfig.generateSirenChance) == 0 && IafWorldRegistry.isFarEnoughFromSpawn(worldIn, position) && IafWorldRegistry.isFarEnoughFromDangerousGen(worldIn, position))) {
            return false;
        }
        position = worldIn.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, position);
        int up = rand.nextInt(4) + 1;
        BlockPos center = position.func_177981_b(up);
        int layer = 0;
        int sirens = 0;
        int sirensMax = 1 + rand.nextInt(3);
        while (!worldIn.func_180495_p(center).func_200132_m() && center.func_177956_o() >= 0) {
            ++layer;
            i = 0.0f;
            while (i < (float)this.getRadius(layer, up)) {
                j = 0.0f;
                while ((double)j < Math.PI * 2 * (double)i + (double)rand.nextInt(2)) {
                    stonePos = new BlockPos(Math.floor((double)center.func_177958_n() + Math.sin(j) * (double)i + (double)rand.nextInt(2)), (double)center.func_177956_o(), Math.floor((double)center.func_177952_p() + Math.cos(j) * (double)i + (double)rand.nextInt(2)));
                    worldIn.func_180501_a(stonePos, this.getStone(rand), 3);
                    BlockPos upPos = stonePos.func_177984_a();
                    if (worldIn.func_175623_d(upPos) && worldIn.func_175623_d(upPos.func_177974_f()) && worldIn.func_175623_d(upPos.func_177978_c()) && worldIn.func_175623_d(upPos.func_177978_c().func_177974_f()) && rand.nextInt(3) == 0 && sirens < sirensMax) {
                        ++sirens;
                        this.spawnSiren(worldIn, rand, upPos.func_177978_c().func_177974_f());
                    }
                    j = (float)((double)j + 0.5);
                }
                i = (float)((double)i + 0.5);
            }
            center = center.func_177977_b();
        }
        ++layer;
        i = 0.0f;
        while (i < (float)this.getRadius(layer, up)) {
            j = 0.0f;
            while ((double)j < Math.PI * 2 * (double)i + (double)rand.nextInt(2)) {
                stonePos = new BlockPos(Math.floor((double)center.func_177958_n() + Math.sin(j) * (double)i + (double)rand.nextInt(2)), (double)center.func_177956_o(), Math.floor((double)center.func_177952_p() + Math.cos(j) * (double)i + (double)rand.nextInt(2)));
                while (!worldIn.func_180495_p(stonePos).func_200132_m() && stonePos.func_177956_o() >= 0) {
                    worldIn.func_180501_a(stonePos, this.getStone(rand), 3);
                    stonePos = stonePos.func_177977_b();
                }
                j = (float)((double)j + 0.5);
            }
            i = (float)((double)i + 0.5);
        }
        return true;
    }
}

