/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen.processor;

import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

public class DreadPortalProcessor
extends StructureProcessor {
    private float integrity = 1.0f;

    public DreadPortalProcessor(BlockPos position, PlacementSettings settings, Biome biome) {
    }

    public static BlockState getRandomCrackedBlock(@Nullable BlockState prev, Random random) {
        float rand = random.nextFloat();
        if ((double)rand < 0.3) {
            return IafBlockRegistry.DREAD_STONE_BRICKS.func_176223_P();
        }
        if ((double)rand < 0.6) {
            return IafBlockRegistry.DREAD_STONE_BRICKS_CRACKED.func_176223_P();
        }
        return IafBlockRegistry.DREAD_STONE_BRICKS_MOSSY.func_176223_P();
    }

    @Nullable
    public Template.BlockInfo func_215194_a(IWorldReader worldIn, BlockPos pos, Template.BlockInfo blockInfoIn, Template.BlockInfo blockInfoIn2, PlacementSettings settings) {
        Random random = settings.func_189947_a(pos);
        if (random.nextFloat() <= this.integrity) {
            if (blockInfoIn.field_186243_b.func_177230_c() == Blocks.field_150484_ah) {
                return new Template.BlockInfo(pos, IafBlockRegistry.DREAD_PORTAL.func_176223_P(), null);
            }
            if (blockInfoIn.field_186243_b.func_177230_c() == IafBlockRegistry.DREAD_STONE_BRICKS) {
                BlockState state = DreadPortalProcessor.getRandomCrackedBlock(null, random);
                return new Template.BlockInfo(pos, state, null);
            }
            return blockInfoIn;
        }
        return blockInfoIn;
    }

    protected IStructureProcessorType func_215192_a() {
        return IStructureProcessorType.field_214921_c;
    }

    protected <T> Dynamic<T> func_215193_a(DynamicOps<T> ops) {
        return new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("dread_portal_processor"), (Object)ops.createFloat(this.integrity))));
    }
}

