/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.common.block.entity;

import com.progwml6.ironchest.common.block.IronChestsTypes;
import com.progwml6.ironchest.common.network.InventoryTopStacksSyncPacket;
import com.progwml6.ironchest.common.network.IronChestNetwork;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public interface ICrystalChest {
    default public NonNullList<ItemStack> buildItemStackDataList() {
        if (this.getChestType().isTransparent()) {
            NonNullList sortList = NonNullList.m_122780_((int)this.getTopItems().size(), (Object)ItemStack.f_41583_);
            int pos = 0;
            for (ItemStack is : this.getTopItems()) {
                if (!is.m_41619_()) {
                    sortList.set(pos, (Object)is);
                } else {
                    sortList.set(pos, (Object)ItemStack.f_41583_);
                }
                ++pos;
            }
            return sortList;
        }
        return NonNullList.m_122780_((int)this.getTopItems().size(), (Object)ItemStack.f_41583_);
    }

    public IronChestsTypes getChestType();

    default public void sendTopStacksPacket() {
        NonNullList<ItemStack> stacks = this.buildItemStackDataList();
        if (this.getChestLevel() != null && this.getChestLevel() instanceof ServerLevel && !this.getChestLevel().f_46443_) {
            IronChestNetwork.getInstance().sendToClientsAround((Object)new InventoryTopStacksSyncPacket(stacks, this.getChestWorldPosition()), (ServerLevel)this.getChestLevel(), this.getChestWorldPosition());
        }
    }

    public NonNullList<ItemStack> getTopItems();

    @Nullable
    public Level getChestLevel();

    public BlockPos getChestWorldPosition();

    public void receiveMessageFromServer(NonNullList<ItemStack> var1);

    default public void sortTopStacks() {
        int i;
        if (!this.getChestType().isTransparent() || this.getChestLevel() != null && this.getChestLevel().f_46443_) {
            return;
        }
        NonNullList tempCopy = NonNullList.m_122780_((int)IronChestsTypes.CRYSTAL.size, (Object)ItemStack.f_41583_);
        boolean hasStuff = false;
        int compressedIdx = 0;
        block0: for (i = 0; i < IronChestsTypes.CRYSTAL.size; ++i) {
            ItemStack itemStack = (ItemStack)this.getCurrentItems().get(i);
            if (itemStack.m_41619_()) continue;
            for (int j = 0; j < compressedIdx; ++j) {
                ItemStack tempCopyStack = (ItemStack)tempCopy.get(j);
                if (!ItemStack.m_41746_((ItemStack)tempCopyStack, (ItemStack)itemStack)) continue;
                if (itemStack.m_41613_() == tempCopyStack.m_41613_()) continue block0;
                tempCopyStack.m_41769_(itemStack.m_41613_());
                continue block0;
            }
            tempCopy.set(compressedIdx, (Object)itemStack.m_41777_());
            ++compressedIdx;
            hasStuff = true;
        }
        if (!hasStuff && this.getHadStuff()) {
            this.setHadStuff(false);
            for (i = 0; i < this.getTopItems().size(); ++i) {
                this.getTopItems().set(i, (Object)ItemStack.f_41583_);
            }
            if (this.getChestLevel() != null) {
                BlockState blockState = this.getChestLevel().m_8055_(this.getChestWorldPosition());
                this.getChestLevel().m_7260_(this.getChestWorldPosition(), blockState, blockState, 3);
            }
            return;
        }
        this.setHadStuff(true);
        tempCopy.sort((stack1, stack2) -> {
            if (stack1.m_41619_()) {
                return 1;
            }
            if (stack2.m_41619_()) {
                return -1;
            }
            return stack2.m_41613_() - stack1.m_41613_();
        });
        int slot = 0;
        for (ItemStack itemStack : tempCopy) {
            if (itemStack.m_41619_() || itemStack.m_41613_() <= 0) continue;
            if (slot == this.getTopItems().size()) break;
            this.getTopItems().set(slot, (Object)itemStack);
            ++slot;
        }
        for (int i2 = slot; i2 < this.getTopItems().size(); ++i2) {
            this.getTopItems().set(i2, (Object)ItemStack.f_41583_);
        }
        if (this.getChestLevel() != null) {
            BlockState blockState = this.getChestLevel().m_8055_(this.getChestWorldPosition());
            this.getChestLevel().m_7260_(this.getChestWorldPosition(), blockState, blockState, 3);
        }
        this.sendTopStacksPacket();
    }

    public NonNullList<ItemStack> getCurrentItems();

    public void setHadStuff(boolean var1);

    public boolean getHadStuff();
}

