/*
 * Decompiled with CFR 0.152.
 */
package com.technovision.ironchest.blocks;

import com.technovision.ironchest.blocks.ExtraChestTypes;
import com.technovision.ironchest.blocks.blockentities.GenericIronChestBlockEntity;
import com.technovision.ironchest.blocks.blockentities.IronChestBlockEntity;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_10;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1451;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2618;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3445;
import net.minecraft.class_3468;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4732;
import net.minecraft.class_4838;
import net.minecraft.class_4970;

public class GenericIronChestBlock
extends class_2237
implements class_3737 {
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2754<class_2745> CHEST_TYPE = class_2741.field_12506;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    protected static final class_265 DOUBLE_NORTH_SHAPE = class_2248.method_9541((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final class_265 DOUBLE_SOUTH_SHAPE = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)16.0);
    protected static final class_265 DOUBLE_WEST_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final class_265 DOUBLE_EAST_SHAPE = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);
    protected static final class_265 SINGLE_SHAPE = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    protected final ExtraChestTypes type;
    private final Supplier<class_2591<? extends GenericIronChestBlockEntity>> entityTypeRetriever;

    public GenericIronChestBlock(FabricBlockSettings settings, ExtraChestTypes type, Supplier<class_2591<? extends GenericIronChestBlockEntity>> entityTypeRetriever) {
        super((class_4970.class_2251)settings);
        this.entityTypeRetriever = entityTypeRetriever;
        this.type = type;
        ((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.FALSE);
    }

    public ExtraChestTypes getType() {
        return this.type;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 newState, class_1936 world, class_2338 pos, class_2338 posFrom) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_8405().method_8676(pos, (Object)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, newState, world, pos, posFrom);
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350 direction = ctx.method_8042().method_10153();
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)direction)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return class_1703.method_7618((class_1263)((class_1263)world.method_8321(pos)));
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (state.method_11654(CHEST_TYPE) == class_2745.field_12569) {
            return SINGLE_SHAPE;
        }
        switch (GenericIronChestBlock.getFacing(state)) {
            default: {
                return DOUBLE_NORTH_SHAPE;
            }
            case field_11035: {
                return DOUBLE_SOUTH_SHAPE;
            }
            case field_11039: {
                return DOUBLE_WEST_SHAPE;
            }
            case field_11034: 
        }
        return DOUBLE_EAST_SHAPE;
    }

    public static class_2350 getFacing(class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        return state.method_11654(CHEST_TYPE) == class_2745.field_12574 ? direction.method_10170() : direction.method_10160();
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, CHEST_TYPE, WATERLOGGED});
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_3908 namedScreenHandlerFactory = state.method_26196(world, pos);
        if (namedScreenHandlerFactory != null) {
            player.method_17355(namedScreenHandlerFactory);
            player.method_7259(this.getOpenStat());
            class_4838.method_24733((class_1657)player, (boolean)true);
        }
        return class_1269.field_21466;
    }

    protected class_3445<class_2960> getOpenStat() {
        return class_3468.field_15419.method_14956((Object)class_3468.field_15395);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204())) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof class_1263) {
                class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)((class_1263)blockEntity));
                world.method_8455(pos, (class_2248)this);
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    public static boolean isChestBlocked(class_1936 world, class_2338 pos) {
        return GenericIronChestBlock.hasBlockOnTop((class_1922)world, pos) || GenericIronChestBlock.hasOcelotOnTop(world, pos);
    }

    private static boolean hasBlockOnTop(class_1922 world, class_2338 pos) {
        class_2338 blockPos = pos.method_10084();
        return world.method_8320(blockPos).method_26212(world, blockPos);
    }

    private static boolean hasOcelotOnTop(class_1936 world, class_2338 pos) {
        List list = world.method_18467(class_1451.class, new class_238((double)pos.method_10263(), (double)(pos.method_10264() + 1), (double)pos.method_10260(), (double)(pos.method_10263() + 1), (double)(pos.method_10264() + 2), (double)(pos.method_10260() + 1)));
        if (!list.isEmpty()) {
            for (class_1451 catEntity : list) {
                if (!catEntity.method_6172()) continue;
                return true;
            }
        }
        return false;
    }

    public class_2586 method_10123(class_1922 world) {
        return new IronChestBlockEntity();
    }

    public class_4732.class_4734<? extends GenericIronChestBlockEntity> getBlockEntitySource(class_2680 state, class_1937 world, class_2338 pos, boolean ignoreBlocked) {
        BiPredicate<Object, Object> biPredicate = ignoreBlocked ? (worldAccess, blockPos) -> false : (GenericIronChestBlock.isChestBlocked((class_1936)world, pos) ? (worldAccess, blockPos) -> true : (worldAccess, blockPos) -> false);
        return class_4732.method_24173(this.entityTypeRetriever.get(), GenericIronChestBlock::getMergerType, GenericIronChestBlock::getDirectionToAttached, (class_2753)FACING, (class_2680)state, (class_1936)world, (class_2338)pos, biPredicate);
    }

    public static class_4732.class_4733 getMergerType(class_2680 blockState) {
        return class_4732.class_4733.field_21783;
    }

    public static class_2350 getDirectionToAttached(class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        return direction.method_10160();
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        class_2586 blockEntity;
        if (itemStack.method_7938() && (blockEntity = world.method_8321(pos)) instanceof class_2595) {
            ((class_2595)blockEntity).method_17488(itemStack.method_7964());
        }
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Environment(value=EnvType.CLIENT)
    public static class_4732.class_3923<GenericIronChestBlockEntity, Float2FloatFunction> getAnimationProgressRetriever(final class_2618 chestAnimationProgress) {
        return new class_4732.class_3923<GenericIronChestBlockEntity, Float2FloatFunction>(){

            public Float2FloatFunction getFromBoth(GenericIronChestBlockEntity chestBlockEntity, GenericIronChestBlockEntity chestBlockEntity2) {
                return f -> Math.max(chestBlockEntity.method_11274(f), chestBlockEntity2.method_11274(f));
            }

            public Float2FloatFunction getFrom(GenericIronChestBlockEntity chestBlockEntity) {
                return chestBlockEntity::method_11274;
            }

            public Float2FloatFunction getFallback() {
                class_2618 var10000 = chestAnimationProgress;
                return arg_0 -> ((class_2618)var10000).method_11274(arg_0);
            }
        };
    }
}

