/*
 * Decompiled with CFR 0.152.
 */
package io.github.cyberanner.ironchests.items;

import io.github.cyberanner.ironchests.blocks.ChestTypes;

public enum UpgradeTypes {
    WOOD_TO_COPPER(ChestTypes.WOOD, ChestTypes.COPPER),
    WOOD_TO_CHRISTMAS(ChestTypes.WOOD, ChestTypes.CHRISTMAS),
    WOOD_TO_IRON(ChestTypes.WOOD, ChestTypes.IRON),
    WOOD_TO_GOLD(ChestTypes.WOOD, ChestTypes.GOLD),
    WOOD_TO_DIAMOND(ChestTypes.WOOD, ChestTypes.DIAMOND),
    WOOD_TO_EMERALD(ChestTypes.WOOD, ChestTypes.EMERALD),
    WOOD_TO_CRYSTAL(ChestTypes.WOOD, ChestTypes.CRYSTAL),
    WOOD_TO_OBSIDIAN(ChestTypes.WOOD, ChestTypes.OBSIDIAN),
    COPPER_TO_IRON(ChestTypes.COPPER, ChestTypes.IRON),
    COPPER_TO_GOLD(ChestTypes.COPPER, ChestTypes.GOLD),
    COPPER_TO_DIAMOND(ChestTypes.COPPER, ChestTypes.DIAMOND),
    COPPER_TO_EMERALD(ChestTypes.COPPER, ChestTypes.EMERALD),
    COPPER_TO_CRYSTAL(ChestTypes.COPPER, ChestTypes.CRYSTAL),
    COPPER_TO_OBSIDIAN(ChestTypes.COPPER, ChestTypes.OBSIDIAN),
    IRON_TO_GOLD(ChestTypes.IRON, ChestTypes.GOLD),
    IRON_TO_DIAMOND(ChestTypes.IRON, ChestTypes.DIAMOND),
    IRON_TO_EMERALD(ChestTypes.IRON, ChestTypes.EMERALD),
    IRON_TO_CRYSTAL(ChestTypes.IRON, ChestTypes.CRYSTAL),
    IRON_TO_OBSIDIAN(ChestTypes.IRON, ChestTypes.OBSIDIAN),
    GOLD_TO_DIAMOND(ChestTypes.GOLD, ChestTypes.DIAMOND),
    GOLD_TO_EMERALD(ChestTypes.GOLD, ChestTypes.EMERALD),
    GOLD_TO_CRYSTAL(ChestTypes.GOLD, ChestTypes.CRYSTAL),
    GOLD_TO_OBSIDIAN(ChestTypes.GOLD, ChestTypes.OBSIDIAN),
    DIAMOND_TO_CRYSTAL(ChestTypes.DIAMOND, ChestTypes.CRYSTAL),
    DIAMOND_TO_OBSIDIAN(ChestTypes.DIAMOND, ChestTypes.OBSIDIAN),
    EMERALD_TO_CRYSTAL(ChestTypes.EMERALD, ChestTypes.CRYSTAL),
    EMERALD_TO_OBSIDIAN(ChestTypes.EMERALD, ChestTypes.OBSIDIAN);

    public final ChestTypes source;
    public final ChestTypes target;

    private UpgradeTypes(ChestTypes source, ChestTypes target) {
        this.source = source;
        this.target = target;
    }

    public boolean canUpgrade(ChestTypes from) {
        return from == this.source;
    }

    public static String tooltip(UpgradeTypes type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case WOOD_TO_CHRISTMAS -> "item.ironchests.wood_christmas_upgrade.tooltip";
            case WOOD_TO_COPPER -> "item.ironchests.wood_copper_upgrade.tooltip";
            case WOOD_TO_IRON -> "item.ironchests.wood_iron_upgrade.tooltip";
            case WOOD_TO_GOLD -> "item.ironchests.wood_gold_upgrade.tooltip";
            case WOOD_TO_DIAMOND -> "item.ironchests.wood_diamond_upgrade.tooltip";
            case WOOD_TO_EMERALD -> "item.ironchests.wood_emerald_upgrade.tooltip";
            case WOOD_TO_CRYSTAL -> "item.ironchests.wood_crystal_upgrade.tooltip";
            case WOOD_TO_OBSIDIAN -> "item.ironchests.wood_obsidian_upgrade.tooltip";
            case COPPER_TO_IRON -> "item.ironchests.copper_iron_upgrade.tooltip";
            case COPPER_TO_GOLD -> "item.ironchests.copper_gold_upgrade.tooltip";
            case COPPER_TO_DIAMOND -> "item.ironchests.copper_diamond_upgrade.tooltip";
            case COPPER_TO_EMERALD -> "item.ironchests.copper_emerald_upgrade.tooltip";
            case COPPER_TO_CRYSTAL -> "item.ironchests.copper_crystal_upgrade.tooltip";
            case COPPER_TO_OBSIDIAN -> "item.ironchests.copper_obsidian_upgrade.tooltip";
            case IRON_TO_GOLD -> "item.ironchests.iron_gold_upgrade.tooltip";
            case IRON_TO_DIAMOND -> "item.ironchests.iron_diamond_upgrade.tooltip";
            case IRON_TO_EMERALD -> "item.ironchests.iron_emerald_upgrade.tooltip";
            case IRON_TO_CRYSTAL -> "item.ironchests.iron_crystal_upgrade.tooltip";
            case IRON_TO_OBSIDIAN -> "item.ironchests.iron_obsidian_upgrade.tooltip";
            case GOLD_TO_DIAMOND -> "item.ironchests.gold_diamond_upgrade.tooltip";
            case GOLD_TO_EMERALD -> "item.ironchests.gold_emerald_upgrade.tooltip";
            case GOLD_TO_CRYSTAL -> "item.ironchests.gold_crystal_upgrade.tooltip";
            case GOLD_TO_OBSIDIAN -> "item.ironchests.gold_obsidian_upgrade.tooltip";
            case DIAMOND_TO_CRYSTAL -> "item.ironchests.diamond_crystal_upgrade.tooltip";
            case DIAMOND_TO_OBSIDIAN -> "item.ironchests.diamond_obsidian_upgrade.tooltip";
            case EMERALD_TO_CRYSTAL -> "item.ironchests.emerald_crystal_upgrade.tooltip";
            case EMERALD_TO_OBSIDIAN -> "item.ironchests.emerald_obsidian_upgrade.tooltip";
        };
    }
}

