/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.lumberjack.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.UUID;
import net.doubledoordev.lumberjack.LumberjackConfig;
import net.doubledoordev.lumberjack.items.ItemLumberAxe;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EventHandler {
    private final HashMultimap<UUID, BlockPos> pointMap = HashMultimap.create();
    private final HashMultimap<UUID, BlockPos> nextMap = HashMultimap.create();

    @SubscribeEvent
    public static void onRegisterItem(RegistryEvent.Register<Item> event) {
        for (Tiers itemTier : Tiers.values()) {
            event.getRegistry().register((IForgeRegistryEntry)((Item)new ItemLumberAxe(itemTier, new Item.Properties().m_41491_(CreativeModeTab.f_40756_)).setRegistryName(itemTier.name().toLowerCase() + "_lumberaxe")));
        }
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.side != LogicalSide.SERVER) {
            return;
        }
        UUID uuid = event.player.m_142081_();
        if (!this.nextMap.containsKey((Object)uuid) || this.nextMap.get((Object)uuid).isEmpty()) {
            return;
        }
        int i = 0;
        for (BlockPos point : ImmutableSet.copyOf((Collection)this.nextMap.get((Object)uuid))) {
            ((ServerPlayer)event.player).f_8941_.m_9280_(point);
            this.nextMap.remove((Object)uuid, (Object)point);
            if (i++ <= (Integer)LumberjackConfig.GENERAL.tickLimit.get()) continue;
            break;
        }
        if (this.pointMap.get((Object)uuid).size() > (Integer)LumberjackConfig.GENERAL.totalLimit.get()) {
            this.nextMap.removeAll((Object)uuid);
        }
        if (!this.nextMap.containsKey((Object)uuid) || !this.nextMap.get((Object)uuid).isEmpty()) {
            this.pointMap.removeAll((Object)uuid);
        }
    }

    @SubscribeEvent
    public void breakEvent(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        ItemStack itemStack = player.m_21205_();
        if (itemStack == ItemStack.f_41583_ || !(itemStack.m_41720_() instanceof ItemLumberAxe)) {
            return;
        }
        Tag destroyConnectedTag = BlockTags.m_13115_().m_7689_(new ResourceLocation("lumberjack", "destroy_connected"));
        Tag ignoreConnectedTag = BlockTags.m_13115_().m_7689_(new ResourceLocation("lumberjack", "ignore_connected"));
        UUID uuid = player.m_142081_();
        BlockState state = event.getState();
        if (!this.shalCut(state, (Tag<Block>)destroyConnectedTag, (Tag<Block>)ignoreConnectedTag)) {
            return;
        }
        this.pointMap.put((Object)uuid, (Object)event.getPos());
        for (int offsetX = -1; offsetX <= 1; ++offsetX) {
            for (int offsetZ = -1; offsetZ <= 1; ++offsetZ) {
                for (int offsetY = -1; offsetY <= 1; ++offsetY) {
                    boolean isLeaves;
                    BlockPos newPoint = event.getPos().m_142082_(offsetX, offsetY, offsetZ);
                    if (this.nextMap.containsEntry((Object)uuid, (Object)newPoint) || this.pointMap.containsEntry((Object)uuid, (Object)newPoint)) continue;
                    BlockState newBlockState = event.getWorld().m_8055_(newPoint);
                    boolean bl = isLeaves = (Boolean)LumberjackConfig.GENERAL.leaves.get() != false && newBlockState.m_60767_() == Material.f_76274_;
                    if ((ignoreConnectedTag.m_8110_((Object)newBlockState.m_60734_()) || (Integer)LumberjackConfig.GENERAL.mode.get() != 0 || !isLeaves && newBlockState.m_60734_() != state.m_60734_()) && ((Integer)LumberjackConfig.GENERAL.mode.get() != 1 || !isLeaves && !this.shalCut(newBlockState, (Tag<Block>)destroyConnectedTag, (Tag<Block>)ignoreConnectedTag))) continue;
                    this.nextMap.put((Object)uuid, (Object)newPoint);
                }
            }
        }
    }

    private boolean shalCut(BlockState state, Tag<Block> destroyTag, Tag<Block> ignoreTag) {
        Block block = state.m_60734_();
        if (ignoreTag.m_8110_((Object)block)) {
            return false;
        }
        Material material = state.m_60767_();
        if (((Boolean)LumberjackConfig.GENERAL.useMaterials.get()).booleanValue() && (material == Material.f_76320_ || material == Material.f_76321_)) {
            return true;
        }
        if (((Boolean)LumberjackConfig.GENERAL.leaves.get()).booleanValue() && material == Material.f_76274_) {
            return true;
        }
        return destroyTag.m_8110_((Object)block);
    }
}

