/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.lumberjack.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.doubledoordev.lumberjack.LumberjackConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;

public class ItemLumberAxe
extends AxeItem {
    private final Multimap<Attribute, AttributeModifier> attributeMap;
    int baseDurability;

    public ItemLumberAxe(Tiers itemTier, Item.Properties builder) {
        super((Tier)itemTier, itemTier.m_6631_(), itemTier.m_6624_(), builder);
        this.baseDurability = itemTier.m_6609_();
        ImmutableMultimap.Builder attibuteBuilder = ImmutableMultimap.builder();
        attibuteBuilder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (Double)LumberjackConfig.GENERAL.damageMultiplier.get() * (double)itemTier.m_6631_(), AttributeModifier.Operation.ADDITION));
        attibuteBuilder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", ((Double)LumberjackConfig.GENERAL.speed.get()).doubleValue(), AttributeModifier.Operation.ADDITION));
        this.attributeMap = attibuteBuilder.build();
    }

    public int getMaxDamage(ItemStack stack) {
        return (int)((double)this.baseDurability * (Double)LumberjackConfig.GENERAL.durabilityMultiplier.get());
    }

    @ParametersAreNonnullByDefault
    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        return stack != ItemStack.f_41583_ && (Material.f_76274_.equals(state.m_60767_()) || super.m_6813_(stack, level, state, pos, entityLiving));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.attributeMap : super.m_7167_(equipmentSlot);
    }
}

