/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.lumberjack.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Locale;
import java.util.UUID;
import net.doubledoordev.lumberjack.LumberjackConfig;
import net.doubledoordev.lumberjack.items.ItemLumberAxe;
import net.doubledoordev.lumberjack.util.TagKeys;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EventHandler {
    public static final DeferredRegister<Item> ITEMS_DEFERRED = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"lumberjack");
    private final HashMultimap<UUID, BlockPos> pointMap = HashMultimap.create();
    private final HashMultimap<UUID, BlockPos> nextMap = HashMultimap.create();

    public EventHandler() {
        for (Tiers itemTier : Tiers.values()) {
            ITEMS_DEFERRED.register(itemTier.name().toLowerCase(Locale.ROOT) + "_lumberaxe", () -> new ItemLumberAxe(itemTier, new Item.Properties().m_41491_(CreativeModeTab.f_40756_)));
        }
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.side != LogicalSide.SERVER) {
            return;
        }
        UUID uuid = event.player.m_20148_();
        if (!this.nextMap.containsKey((Object)uuid) || this.nextMap.get((Object)uuid).isEmpty()) {
            return;
        }
        int i = 0;
        for (BlockPos point : ImmutableSet.copyOf((Collection)this.nextMap.get((Object)uuid))) {
            ((ServerPlayer)event.player).f_8941_.m_9280_(point);
            this.nextMap.remove((Object)uuid, (Object)point);
            if (i++ <= (Integer)LumberjackConfig.GENERAL.tickLimit.get()) continue;
            break;
        }
        if (this.pointMap.get((Object)uuid).size() > (Integer)LumberjackConfig.GENERAL.totalLimit.get()) {
            this.nextMap.removeAll((Object)uuid);
        }
        if (!this.nextMap.containsKey((Object)uuid) || !this.nextMap.get((Object)uuid).isEmpty()) {
            this.pointMap.removeAll((Object)uuid);
        }
    }

    @SubscribeEvent
    public void breakEvent(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        ItemStack itemStack = player.m_21205_();
        if (itemStack == ItemStack.f_41583_ || !(itemStack.m_41720_() instanceof ItemLumberAxe)) {
            return;
        }
        TagKey<Block> destroyConnectedTag = TagKeys.DESTROY_CONNECTED;
        TagKey<Block> ignoreConnectedTag = TagKeys.IGNORE_CONNECTED;
        UUID uuid = player.m_20148_();
        BlockState state = event.getState();
        if (!this.shalCut(state, destroyConnectedTag, ignoreConnectedTag)) {
            return;
        }
        this.pointMap.put((Object)uuid, (Object)event.getPos());
        for (int offsetX = -1; offsetX <= 1; ++offsetX) {
            for (int offsetZ = -1; offsetZ <= 1; ++offsetZ) {
                for (int offsetY = -1; offsetY <= 1; ++offsetY) {
                    boolean isLeaves;
                    BlockPos newPoint = event.getPos().m_7918_(offsetX, offsetY, offsetZ);
                    if (this.nextMap.containsEntry((Object)uuid, (Object)newPoint) || this.pointMap.containsEntry((Object)uuid, (Object)newPoint)) continue;
                    BlockState newBlockState = event.getLevel().m_8055_(newPoint);
                    boolean bl = isLeaves = (Boolean)LumberjackConfig.GENERAL.leaves.get() != false && newBlockState.m_60767_() == Material.f_76274_;
                    if ((newBlockState.m_204336_(ignoreConnectedTag) || (Integer)LumberjackConfig.GENERAL.mode.get() != 0 || !isLeaves && newBlockState.m_60734_() != state.m_60734_()) && ((Integer)LumberjackConfig.GENERAL.mode.get() != 1 || !isLeaves && !this.shalCut(newBlockState, destroyConnectedTag, ignoreConnectedTag))) continue;
                    this.nextMap.put((Object)uuid, (Object)newPoint);
                }
            }
        }
    }

    private boolean shalCut(BlockState state, TagKey<Block> destroyTag, TagKey<Block> ignoreTag) {
        if (state.m_204336_(ignoreTag)) {
            return false;
        }
        Material material = state.m_60767_();
        if (((Boolean)LumberjackConfig.GENERAL.useMaterials.get()).booleanValue() && (material == Material.f_76320_ || material == Material.f_76321_)) {
            return true;
        }
        if (((Boolean)LumberjackConfig.GENERAL.leaves.get()).booleanValue() && material == Material.f_76274_) {
            return true;
        }
        return state.m_204336_(destroyTag);
    }
}

