/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.menucompanions;

import com.fuzs.menucompanions.client.handler.MenuEntityHandler;
import com.fuzs.menucompanions.client.storage.MenuEntityProvider;
import com.fuzs.menucompanions.config.ConfigManager;
import com.fuzs.menucompanions.config.JSONConfigUtil;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="menucompanions")
public class MenuCompanions {
    public static final String MODID = "menucompanions";
    public static final String NAME = "Menu Companions";
    public static final Logger LOGGER = LogManager.getLogger((String)"Menu Companions");
    public static final String JSON_CONFIG_NAME = "mobs.json";
    private final MenuEntityHandler handler = new MenuEntityHandler();

    public MenuCompanions() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onLoadComplete);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ConfigManager::onModConfig);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> new DistExecutor.SafeRunnable(){

            public void run() {
                JSONConfigUtil.load(MenuCompanions.JSON_CONFIG_NAME, MenuCompanions.MODID, MenuEntityProvider::serialize, MenuEntityProvider::deserialize);
                ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
                MenuCompanions.this.handler.setup(builder);
                ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, builder.build(), ConfigManager.configNameForFolder(ModConfig.Type.CLIENT, MenuCompanions.MODID));
                FMLJavaModLoadingContext.get().getModEventBus().addListener(x$0 -> MenuCompanions.this.onClientSetup(x$0));
            }
        });
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (remote, isServer) -> true));
    }

    private void onClientSetup(FMLClientSetupEvent evt) {
        this.handler.load();
    }

    private void onLoadComplete(FMLLoadCompleteEvent evt) {
        JSONConfigUtil.load(JSON_CONFIG_NAME, MODID, MenuEntityProvider::serialize, MenuEntityProvider::deserialize);
        this.handler.createSides();
        ConfigManager.sync();
    }
}

