/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.menucompanions.client.gui;

import com.fuzs.menucompanions.MenuCompanions;
import com.fuzs.menucompanions.client.handler.MenuEntityHandler;
import com.fuzs.menucompanions.client.particle.MenuParticleManager;
import com.fuzs.menucompanions.client.storage.EntityMenuEntry;
import com.fuzs.menucompanions.client.world.MenuClientWorld;
import com.fuzs.menucompanions.mixin.ActiveRenderInfoAccessorMixin;
import com.fuzs.menucompanions.mixin.LivingEntityAccessorMixin;
import com.fuzs.menucompanions.mixin.MobEntityAccessorMixin;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.world.World;

public class EntityMenuContainer {
    private final Minecraft mc;
    private final MenuClientWorld world;
    public final MenuParticleManager particleManager;
    private boolean enabled;
    private boolean valid;
    private boolean firstRender;
    private Entity entity;
    private Entity[] selfAndPassengers;
    private boolean tick;
    private boolean walking;
    private float scale;
    private int xOffset;
    private int yOffset;
    private boolean nameplate;
    private boolean particles;

    public EntityMenuContainer(Minecraft mc, MenuClientWorld world) {
        this.mc = mc;
        this.world = world;
        this.particleManager = new MenuParticleManager(mc, world);
    }

    public void createEntity(@Nonnull Entity entity, @Nonnull EntityMenuEntry entry, MenuEntityHandler.MenuSide side) {
        this.entity = entity;
        this.selfAndPassengers = (Entity[])entity.func_226276_cg_().toArray(Entity[]::new);
        this.tick = entry.isTick();
        this.walking = entry.isWalking();
        this.scale = entry.getScale(entity);
        this.xOffset = (side == MenuEntityHandler.MenuSide.RIGHT ? -1 : 1) * entry.getXOffset();
        this.yOffset = -entry.getYOffset();
        this.nameplate = entry.showNameplate();
        this.particles = entry.showParticles();
        this.enabled = true;
        this.valid = true;
        this.firstRender = true;
        this.particleManager.clearEffects();
    }

    public void tick() {
        if (!this.enabled || this.entity == null) {
            return;
        }
        this.world.setActiveContainer(this);
        if (this.particles) {
            this.particleManager.tick();
        }
        for (Entity entity : this.selfAndPassengers) {
            ++entity.field_70173_aa;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (entity instanceof PlayerEntity) {
                    this.updateLimbSwing(livingEntity, this.walking ? 0.6f : 0.0f);
                    if (livingEntity.field_70737_aN > 0) {
                        --livingEntity.field_70737_aN;
                    }
                } else if (this.walking) {
                    this.updateLimbSwing(livingEntity, 0.6f);
                }
                if (this.tick) {
                    this.tick = MenuEntityHandler.runOrElse(entity, safeEntity -> ((LivingEntity)safeEntity).func_70636_d(), safeEntity -> {});
                }
            }
            if (!entity.func_184218_aH()) continue;
            Objects.requireNonNull(entity.func_184187_bx()).func_184232_k(entity);
        }
    }

    private void updateLimbSwing(LivingEntity livingEntity, float amount) {
        livingEntity.field_184618_aE = livingEntity.field_70721_aZ;
        livingEntity.field_70721_aZ += (MathHelper.func_76131_a((float)amount, (float)0.0f, (float)1.0f) - livingEntity.field_70721_aZ) * 0.4f;
        livingEntity.field_184619_aG += livingEntity.field_70721_aZ;
    }

    public void render(int posX, int posY, float scale, float mouseX, float mouseY, float partialTicks) {
        if (!this.enabled || this.entity == null) {
            return;
        }
        ActiveRenderInfo activerenderinfo = this.mc.field_71460_t.func_215316_n();
        this.mc.func_175598_ae().func_229088_a_((World)this.world, activerenderinfo, this.entity);
        ((ActiveRenderInfoAccessorMixin)activerenderinfo).callSetPosition(Vector3d.field_186680_a);
        ((ActiveRenderInfoAccessorMixin)activerenderinfo).callSetDirection(0.0f, 0.0f);
        scale *= this.scale;
        posY += this.yOffset;
        posY = (int)((float)posY - Math.max(0.0f, 0.9f - this.entity.func_213302_cg() / 2.0f) * 30.0f);
        mouseX += (float)(posX += this.xOffset);
        mouseY += (float)posY;
        mouseY -= this.entity.func_70047_e() / 1.62f * 50.0f * this.scale;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)posX, (float)posY, (float)50.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227862_a_(scale, scale, scale);
        Quaternion quaternionZ = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        Quaternion quaternionX = Vector3f.field_229179_b_.func_229187_a_((float)Math.atan(mouseY / 40.0f) * 20.0f);
        quaternionZ.func_195890_a(quaternionX);
        matrixstack.func_227863_a_(quaternionZ);
        this.renderParticles(matrixstack, partialTicks);
        for (Entity entity : this.selfAndPassengers) {
            Vector3d posVec = entity.func_213303_ch().func_178788_d(this.entity.func_213303_ch());
            double eyeVec = entity.func_226280_cw_() - this.entity.func_226280_cw_();
            EntityMenuContainer.setRotationAngles(entity, mouseX, mouseY - (float)eyeVec / 1.62f * 50.0f * this.scale);
            if (this.firstRender) {
                EntityMenuContainer.setRotationAngles(entity, mouseX, mouseY + (float)posVec.func_82617_b() * scale);
            }
            this.valid = MenuEntityHandler.runOrElse(entity, renderEntity -> EntityMenuContainer.drawEntityOnScreen(matrixstack, posVec.func_82615_a(), posVec.func_82617_b(), posVec.func_82616_c(), partialTicks, renderEntity, (irendertypebuffer, packedLightIn) -> {
                if (this.nameplate) {
                    matrixstack.func_227860_a_();
                    float downscale = 1.0f / this.scale;
                    matrixstack.func_227862_a_(downscale, downscale, downscale);
                    EntityMenuContainer.renderName(matrixstack, irendertypebuffer, packedLightIn, entity, (entity.func_213302_cg() + 0.5f) * this.scale);
                    matrixstack.func_227865_b_();
                }
            }), renderEntity -> MenuEntityHandler.addToBlacklist(renderEntity.func_200600_R()));
        }
        this.firstRender = false;
        RenderSystem.popMatrix();
    }

    private void renderParticles(MatrixStack matrixstack, float partialTicks) {
        if (this.particles) {
            try {
                matrixstack.func_227860_a_();
                this.particleManager.renderParticles(matrixstack, this.mc.field_71460_t.func_228384_l_(), this.mc.field_71460_t.func_215316_n(), partialTicks);
                matrixstack.func_227865_b_();
            }
            catch (Exception e) {
                MenuCompanions.LOGGER.warn("Exception rendering particle, skipping until reload");
                this.particles = false;
            }
        }
    }

    public void playLivingSound(SoundHandler handler, float volume, boolean hurtPlayer) {
        if (!this.enabled || this.entity == null) {
            return;
        }
        this.world.setActiveContainer(this);
        List entities = Stream.of(this.selfAndPassengers).filter(entity -> entity instanceof LivingEntity).collect(Collectors.toList());
        if (entities.isEmpty()) {
            return;
        }
        Collections.shuffle(entities);
        LivingEntity livingEntity = (LivingEntity)entities.get((int)((double)entities.size() * Math.random()));
        if (livingEntity instanceof MobEntity) {
            SoundEvent ambientSound = ((MobEntityAccessorMixin)livingEntity).callGetAmbientSound();
            this.playLivingSound(handler, livingEntity, ambientSound, volume);
        }
        if (hurtPlayer && livingEntity instanceof PlayerEntity && livingEntity.field_70737_aN == 0) {
            livingEntity.field_70737_aN = 10;
            livingEntity.field_70721_aZ = 1.5f;
            for (int i = 0; i < 2; ++i) {
                double posX = livingEntity.func_226277_ct_() + this.world.field_73012_v.nextGaussian() * 0.2;
                double posY = livingEntity.func_226283_e_(0.5);
                double posZ = livingEntity.func_226281_cx_() - 0.3 + this.world.field_73012_v.nextGaussian() * 0.2;
                double xSpeed = this.world.field_73012_v.nextGaussian() * 0.02;
                double zSpeed = this.world.field_73012_v.nextGaussian() * 0.02;
                this.world.func_195594_a((IParticleData)ParticleTypes.field_197615_h, posX, posY, posZ, xSpeed, 0.0, zSpeed);
            }
            SoundEvent hurtSound = ((LivingEntityAccessorMixin)livingEntity).callGetHurtSound(DamageSource.field_76377_j);
            this.playLivingSound(handler, livingEntity, hurtSound, volume);
        }
    }

    private void playLivingSound(SoundHandler handler, LivingEntity livingEntity, SoundEvent soundEvent, float volume) {
        if (soundEvent != null && !livingEntity.func_174814_R()) {
            float soundVolume = ((LivingEntityAccessorMixin)livingEntity).callGetSoundVolume() * volume;
            float soundPitch = ((LivingEntityAccessorMixin)livingEntity).callGetSoundPitch();
            handler.func_147682_a((ISound)new SimpleSound(soundEvent.func_187503_a(), livingEntity.func_184176_by(), soundVolume, soundPitch, false, 0, ISound.AttenuationType.NONE, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), true));
        }
    }

    public boolean isInvalid() {
        return !this.valid;
    }

    public boolean setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            return true;
        }
        return false;
    }

    private static void setRotationAngles(Entity entity, float mouseX, float mouseY) {
        entity.field_70126_B = entity.field_70177_z;
        entity.field_70127_C = entity.field_70125_A;
        entity.field_70177_z = 180.0f + (float)Math.atan(mouseX / 40.0f) * 40.0f;
        entity.field_70125_A = -((float)Math.atan(mouseY / 40.0f)) * 20.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.field_70760_ar = livingEntity.field_70761_aq;
            livingEntity.field_70758_at = livingEntity.field_70759_as;
            livingEntity.field_70761_aq = 180.0f + (float)Math.atan(mouseX / 40.0f) * 20.0f;
            livingEntity.field_70759_as = entity.field_70177_z;
        }
    }

    private static void drawEntityOnScreen(MatrixStack matrixstack, double posX, double posY, double posZ, float partialTicks, Entity entity, BiConsumer<IRenderTypeBuffer, Integer> renderName) {
        matrixstack.func_227860_a_();
        matrixstack.func_227861_a_(posX, posY, posZ);
        EntityRendererManager entityrenderermanager = Minecraft.func_71410_x().func_175598_ae();
        entityrenderermanager.func_178633_a(false);
        IRenderTypeBuffer.Impl irendertypebuffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderSystem.runAsFancy(() -> {
            entityrenderermanager.func_229084_a_(entity, 0.0, 0.0, 0.0, 0.0f, partialTicks, matrixstack, (IRenderTypeBuffer)irendertypebuffer, 0xF000F0);
            renderName.accept((IRenderTypeBuffer)irendertypebuffer, 0xF000F0);
        });
        irendertypebuffer.func_228461_a_();
        entityrenderermanager.func_178633_a(true);
        matrixstack.func_227865_b_();
    }

    private static void renderName(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, Entity entityIn, float renderHeight) {
        ITextComponent displayNameIn = entityIn.func_145748_c_();
        float renderOffset = "deadmau5".equals(displayNameIn.getString()) ? -10.0f : 0.0f;
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, (double)renderHeight, 0.0);
        matrixStackIn.func_227862_a_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
        float backgroundOpacity = Minecraft.func_71410_x().field_71474_y.func_216840_a(0.25f);
        int alpha = (int)(backgroundOpacity * 255.0f) << 24;
        FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
        int textWidth = -fontrenderer.func_238414_a_((ITextProperties)displayNameIn) / 2;
        fontrenderer.func_238416_a_((ITextProperties)displayNameIn, (float)textWidth, renderOffset, 0x20FFFFFF, false, matrix4f, bufferIn, true, alpha, packedLightIn);
        fontrenderer.func_238416_a_((ITextProperties)displayNameIn, (float)textWidth, renderOffset, -1, false, matrix4f, bufferIn, false, 0, packedLightIn);
        matrixStackIn.func_227865_b_();
    }
}

