/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.menucompanions.client.handler;

import com.fuzs.menucompanions.MenuCompanions;
import com.fuzs.menucompanions.client.gui.EntityMenuContainer;
import com.fuzs.menucompanions.client.storage.EntityMenuEntry;
import com.fuzs.menucompanions.client.storage.MenuEntityProvider;
import com.fuzs.menucompanions.client.world.MenuClientWorld;
import com.fuzs.menucompanions.config.ConfigManager;
import com.fuzs.menucompanions.config.EntryCollectionBuilder;
import com.fuzs.menucompanions.config.JSONConfigUtil;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.server.IDynamicRegistries;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;

public class MenuEntityHandler {
    private static final ResourceLocation RELOAD_TEXTURES = new ResourceLocation("menucompanions", "textures/gui/reload.png");
    private final Minecraft mc = Minecraft.func_71410_x();
    private final List<Consumer<? extends Event>> events = Lists.newArrayList();
    private ReloadMode reloadMode;
    private MenuSide menuSide;
    private final int[] offsets = new int[4];
    private boolean playSounds;
    private double volume;
    private boolean hurtPlayer;
    private static Set<EntityType<?>> blacklist;
    private static ForgeConfigSpec.ConfigValue<List<String>> blacklistSpec;
    private MenuClientWorld renderWorld;
    private final EntityMenuContainer[] sides = new EntityMenuContainer[2];
    private final int size = 60;

    public void setup(ForgeConfigSpec.Builder builder) {
        this.addListener(this::onGuiInit);
        this.addListener(this::onGuiOpen);
        this.addListener(this::onDrawScreen);
        this.addListener(this::onClientTick);
        this.addListener(this::onRenderNameplate);
        this.setupConfig(builder);
    }

    private <T extends Event> void addListener(Consumer<T> consumer) {
        this.events.add(consumer);
    }

    public void load() {
        this.events.forEach(arg_0 -> ((IEventBus)MinecraftForge.EVENT_BUS).addListener(arg_0));
    }

    private void setupConfig(ForgeConfigSpec.Builder builder) {
        ConfigManager.registerEntry(ModConfig.Type.CLIENT, builder.comment("When to show reload button on main menu. By default requires the control key to be pressed.").defineEnum("Reload Button", (Enum)ReloadMode.RIGHT_CONTROL), v -> {
            this.reloadMode = v;
        });
        ConfigManager.registerEntry(ModConfig.Type.CLIENT, builder.comment("Which side entities can be shown at.").defineEnum("Entity Side", (Enum)MenuSide.BOTH), v -> {
            this.menuSide = v;
            Optional.ofNullable(this.sides[0]).ifPresent(container -> {
                if (container.setEnabled(this.menuSide != MenuSide.RIGHT)) {
                    this.setMenuSide(MenuSide.LEFT);
                }
            });
            Optional.ofNullable(this.sides[1]).ifPresent(container -> {
                if (container.setEnabled(this.menuSide != MenuSide.LEFT)) {
                    this.setMenuSide(MenuSide.RIGHT);
                }
            });
        });
        ConfigManager.registerEntry(ModConfig.Type.CLIENT, builder.comment("Offset on x-axis from original position on left side.").defineInRange("Left X-Offset", 0, Integer.MIN_VALUE, Integer.MAX_VALUE), v -> {
            this.offsets[0] = v;
        });
        ConfigManager.registerEntry(ModConfig.Type.CLIENT, builder.comment("Offset on y-axis from original position on left side.").defineInRange("Left Y-Offset", 0, Integer.MIN_VALUE, Integer.MAX_VALUE), v -> {
            this.offsets[1] = v;
        });
        ConfigManager.registerEntry(ModConfig.Type.CLIENT, builder.comment("Offset on x-axis from original position on right side.").defineInRange("Right X-Offset", 0, Integer.MIN_VALUE, Integer.MAX_VALUE), v -> {
            this.offsets[2] = v;
        });
        ConfigManager.registerEntry(ModConfig.Type.CLIENT, builder.comment("Offset on y-axis from original position on right side.").defineInRange("Right Y-Offset", 0, Integer.MIN_VALUE, Integer.MAX_VALUE), v -> {
            this.offsets[3] = v;
        });
        ConfigManager.registerEntry(ModConfig.Type.CLIENT, builder.comment("Play ambient sounds when clicking on menu mobs.").define("Play Sounds", true), v -> {
            this.playSounds = v;
        });
        ConfigManager.registerEntry(ModConfig.Type.CLIENT, builder.comment("Volume of ambient sounds.").defineInRange("Sound Volume", 0.5, 0.0, 1.0), v -> {
            this.volume = v;
        });
        ConfigManager.registerEntry(ModConfig.Type.CLIENT, builder.comment("Hurt player when clicked.").define("Hurt Player", true), v -> {
            this.hurtPlayer = v;
        });
        blacklistSpec = builder.comment("Blacklist for excluding entities. Entries will be added automatically when problematic entities are detected.").define("Blacklist", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:ender_dragon", "minecraft:minecart", "minecraft:furnace_minecart", "minecraft:chest_minecart", "minecraft:spawner_minecart", "minecraft:hopper_minecart", "minecraft:command_block_minecart", "minecraft:tnt_minecart", "minecraft:evoker_fangs", "minecraft:falling_block", "minecraft:area_effect_cloud", "minecraft:item", "minecraft:fishing_bobber"}));
        ConfigManager.registerEntry(ModConfig.Type.CLIENT, blacklistSpec, v -> {
            blacklist = new EntryCollectionBuilder(ForgeRegistries.ENTITIES, MenuCompanions.LOGGER).buildEntrySet((List<String>)v);
        });
    }

    public void createSides() {
        try {
            GameProfile profileIn = this.mc.func_110432_I().func_148256_e();
            ClientPlayNetHandler clientPlayNetHandler = new ClientPlayNetHandler(this.mc, null, null, profileIn);
            ClientWorld.ClientWorldInfo worldInfo = new ClientWorld.ClientWorldInfo(Difficulty.HARD, false, false);
            RegistryKey registrykey = DimensionType.field_236000_d_;
            DimensionType dimensiontype = (DimensionType)IDynamicRegistries.func_239770_b_().func_230520_a_().func_230516_a_(registrykey);
            this.renderWorld = new MenuClientWorld(clientPlayNetHandler, worldInfo, (RegistryKey<World>)World.field_234919_h_, (RegistryKey<DimensionType>)registrykey, dimensiontype, () -> ((Minecraft)this.mc).func_213239_aq(), this.mc.field_71438_f);
        }
        catch (Exception e) {
            MenuCompanions.LOGGER.error("Unable to create rendering world: {}", (Object)e.getMessage());
            this.events.forEach(arg_0 -> ((IEventBus)MinecraftForge.EVENT_BUS).unregister(arg_0));
            return;
        }
        this.sides[0] = new EntityMenuContainer(this.mc, this.renderWorld);
        this.sides[1] = new EntityMenuContainer(this.mc, this.renderWorld);
    }

    private void onGuiInit(final GuiScreenEvent.InitGuiEvent.Post evt) {
        if (evt.getGui() instanceof MainMenuScreen) {
            evt.addWidget((Widget)new ImageButton(0, 0, 20, 20, 0, 0, 20, RELOAD_TEXTURES, 32, 64, button -> {
                JSONConfigUtil.load("mobs.json", "menucompanions", MenuEntityProvider::serialize, MenuEntityProvider::deserialize);
                MenuCompanions.LOGGER.info("Reloaded config file at {}", (Object)"mobs.json");
                this.setMenuSide(MenuSide.LEFT);
                this.setMenuSide(MenuSide.RIGHT);
            }, (ITextComponent)new TranslationTextComponent("narrator.button.reload")){

                public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
                    this.field_230694_p_ = MenuEntityHandler.this.reloadMode.requiresControl() && Screen.func_231172_r_() || MenuEntityHandler.this.reloadMode.isAlways();
                    this.field_230690_l_ = evt.getGui().field_230708_k_ / 2 + (MenuEntityHandler.this.reloadMode.isLeft() ? -148 : 128);
                    this.field_230691_m_ = evt.getGui().field_230709_l_ / 4 + 48 + 72 + 12;
                    super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
                }
            });
            evt.addWidget((Widget)new Button(0, 0, this.size, 80, StringTextComponent.field_240750_d_, button -> {}){

                public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
                    this.field_230693_o_ = MenuEntityHandler.this.playSounds;
                    this.field_230690_l_ = (evt.getGui().field_230708_k_ / 2 - 96) / 2 - 60 / 2 + MenuEntityHandler.this.offsets[0];
                    this.field_230691_m_ = evt.getGui().field_230709_l_ / 4 + 48 - MenuEntityHandler.this.offsets[1];
                }

                public void func_230988_a_(@Nonnull SoundHandler handler) {
                    MenuEntityHandler.this.sides[0].playLivingSound(handler, (float)MenuEntityHandler.this.volume, MenuEntityHandler.this.hurtPlayer);
                }
            });
            evt.addWidget((Widget)new Button(0, 0, this.size, 80, StringTextComponent.field_240750_d_, button -> {}){

                public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
                    this.field_230693_o_ = MenuEntityHandler.this.playSounds;
                    this.field_230690_l_ = evt.getGui().field_230708_k_ - ((evt.getGui().field_230708_k_ / 2 - 96) / 2 + MenuEntityHandler.this.offsets[2] + 60 / 2);
                    this.field_230691_m_ = evt.getGui().field_230709_l_ / 4 + 48 - MenuEntityHandler.this.offsets[3];
                }

                public void func_230988_a_(@Nonnull SoundHandler handler) {
                    MenuEntityHandler.this.sides[1].playLivingSound(handler, (float)MenuEntityHandler.this.volume, MenuEntityHandler.this.hurtPlayer);
                }
            });
        }
    }

    private void onGuiOpen(GuiOpenEvent evt) {
        if (evt.getGui() instanceof MainMenuScreen) {
            this.setMenuSide(MenuSide.LEFT);
            this.setMenuSide(MenuSide.RIGHT);
        }
    }

    private void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post evt) {
        if (evt.getGui() instanceof MainMenuScreen) {
            for (int i = 0; i < this.sides.length; ++i) {
                EntityMenuContainer container = this.sides[i];
                int xOffset = (evt.getGui().field_230708_k_ / 2 - 96) / 2 + this.offsets[i * 2];
                int posX = i == 0 ? xOffset : evt.getGui().field_230708_k_ - xOffset;
                int posY = evt.getGui().field_230709_l_ / 4 + 116 - this.offsets[i * 2 + 1];
                this.getClass();
                container.render(posX, posY, 60.0f / 2.0f, -evt.getMouseX(), -evt.getMouseY(), evt.getRenderPartialTicks());
            }
            this.runCleanup();
        }
    }

    private void onClientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END && this.mc.field_71462_r instanceof MainMenuScreen) {
            Stream.of(this.sides).forEach(EntityMenuContainer::tick);
            this.runCleanup();
        }
    }

    private void onRenderNameplate(RenderNameplateEvent evt) {
        if (this.mc.field_71462_r instanceof MainMenuScreen) {
            evt.setResult(Event.Result.DENY);
        }
    }

    private void setMenuSide(@Nonnull MenuSide side) {
        if (this.menuSide == side.inverse()) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            EntityMenuEntry entry = MenuEntityProvider.getRandomEntry(side);
            if (entry == null) {
                this.sides[side.ordinal()].setEnabled(false);
                return;
            }
            Entity entity = entry.create(this.renderWorld);
            if (entity == null) continue;
            this.sides[side.ordinal()].createEntity(entity, entry, side);
            return;
        }
    }

    private void runCleanup() {
        for (int i = 0; i < this.sides.length; ++i) {
            if (!this.sides[i].isInvalid()) continue;
            this.setMenuSide(MenuSide.values()[i]);
        }
    }

    public static boolean runOrElse(Entity entity, Consumer<Entity> action, Consumer<Entity> orElse) {
        try {
            action.accept(entity);
        }
        catch (Exception e) {
            MenuCompanions.LOGGER.error("Unable to handle Entity {}", (Object)entity.func_145748_c_().getString(), (Object)e);
            orElse.accept(entity);
            return false;
        }
        return true;
    }

    public static boolean isAllowed(EntityType<?> type) {
        return blacklist == null || !blacklist.contains(type);
    }

    public static void addToBlacklist(String type) {
        ResourceLocation key = ResourceLocation.func_208304_a((String)type);
        if (key == null || !ForgeRegistries.ENTITIES.containsKey(key)) {
            return;
        }
        MenuEntityHandler.addToBlacklist((EntityType)Objects.requireNonNull(ForgeRegistries.ENTITIES.getValue(key)));
    }

    public static void addToBlacklist(EntityType<?> type) {
        if (blacklistSpec == null) {
            return;
        }
        if (MenuEntityHandler.isAllowed(type)) {
            blacklistSpec.set(Stream.of((Collection)blacklistSpec.get(), Collections.singleton(Objects.requireNonNull(ForgeRegistries.ENTITIES.getKey(type)).toString())).flatMap(Collection::stream).collect(Collectors.toList()));
        }
    }

    private static enum ReloadMode {
        NEVER(0),
        RIGHT_CONTROL(2),
        RIGHT_ALWAYS(4),
        LEFT_CONTROL(3),
        LEFT_ALWAYS(5);

        private final int data;

        private ReloadMode(int data) {
            this.data = data;
        }

        public boolean isLeft() {
            return (this.data & 1) == 1;
        }

        public boolean requiresControl() {
            return (this.data & 2) == 2;
        }

        public boolean isAlways() {
            return (this.data & 4) == 4;
        }
    }

    public static enum MenuSide {
        LEFT,
        RIGHT,
        BOTH;


        public MenuSide inverse() {
            return MenuSide.values()[(this.ordinal() + 1) % 2];
        }
    }
}

