/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.menucompanions.client.particle;

import com.fuzs.menucompanions.mixin.ParticleManagerAccessorMixin;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@OnlyIn(value=Dist.CLIENT)
public class MenuParticleManager {
    private final ClientWorld world;
    private final TextureManager renderer;
    private final ParticleManagerAccessorMixin particles;
    private final Map<IParticleRenderType, Queue<Particle>> byType = Maps.newIdentityHashMap();
    private final Queue<Particle> queue = Queues.newArrayDeque();

    public MenuParticleManager(Minecraft mc, ClientWorld world) {
        this.world = world;
        this.renderer = mc.field_71446_o;
        this.particles = (ParticleManagerAccessorMixin)mc.field_71452_i;
    }

    public void addParticle(IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        Particle particle = this.makeParticle(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
        if (particle != null) {
            this.addEffect(particle);
        }
    }

    @Nullable
    private <T extends IParticleData> Particle makeParticle(T particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        IParticleFactory<T> iparticlefactory = this.getParticleFactory(particleData);
        return iparticlefactory == null ? null : iparticlefactory.func_199234_a(particleData, this.world, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    private <T extends IParticleData> IParticleFactory<T> getParticleFactory(T particleData) {
        return this.particles.getFactories().get(ForgeRegistries.PARTICLE_TYPES.getKey((IForgeRegistryEntry)particleData.func_197554_b()));
    }

    public void addEffect(Particle effect) {
        this.queue.add(effect);
    }

    public void tick() {
        this.byType.forEach((p_228347_1_, p_228347_2_) -> {
            this.world.func_217381_Z().func_76320_a(p_228347_1_.toString());
            this.tickParticleList((Collection<Particle>)p_228347_2_);
            this.world.func_217381_Z().func_76319_b();
        });
        if (!this.queue.isEmpty()) {
            Particle particle;
            while ((particle = this.queue.poll()) != null) {
                this.byType.computeIfAbsent(particle.func_217558_b(), p_228346_0_ -> EvictingQueue.create((int)16384)).add(particle);
            }
        }
    }

    private void tickParticleList(Collection<Particle> particlesIn) {
        if (!particlesIn.isEmpty()) {
            Iterator<Particle> iterator = particlesIn.iterator();
            while (iterator.hasNext()) {
                Particle particle = iterator.next();
                this.tickParticle(particle);
                if (particle.func_187113_k()) continue;
                iterator.remove();
            }
        }
    }

    private void tickParticle(Particle particle) {
        try {
            particle.func_189213_a();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Ticking Particle");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Particle being ticked");
            crashreportcategory.func_189529_a("Particle", () -> ((Particle)particle).toString());
            crashreportcategory.func_189529_a("Particle Type", particle.func_217558_b()::toString);
            throw new ReportedException(crashreport);
        }
    }

    public void renderParticles(MatrixStack matrixStackIn, LightTexture lightTextureIn, ActiveRenderInfo activeRenderInfoIn, float partialTicks) {
        lightTextureIn.func_205109_c();
        Runnable enable = () -> {
            RenderSystem.enableAlphaTest();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.enableDepthTest();
            RenderSystem.enableFog();
            RenderSystem.activeTexture((int)33986);
            RenderSystem.enableTexture();
            RenderSystem.activeTexture((int)33984);
        };
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)matrixStackIn.func_227866_c_().func_227870_a_());
        for (IParticleRenderType iparticlerendertype : this.byType.keySet()) {
            if (iparticlerendertype == IParticleRenderType.field_217606_f) continue;
            enable.run();
            Iterable iterable = this.byType.get(iparticlerendertype);
            if (iterable == null) continue;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            iparticlerendertype.func_217600_a(bufferbuilder, this.renderer);
            for (Particle particle : iterable) {
                try {
                    particle.func_225606_a_((IVertexBuilder)bufferbuilder, activeRenderInfoIn, partialTicks);
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Rendering Particle");
                    CrashReportCategory crashreportcategory = crashreport.func_85058_a("Particle being rendered");
                    crashreportcategory.func_189529_a("Particle", () -> ((Particle)particle).toString());
                    crashreportcategory.func_189529_a("Particle Type", iparticlerendertype::toString);
                    throw new ReportedException(crashreport);
                }
            }
            iparticlerendertype.func_217599_a(tessellator);
        }
        RenderSystem.popMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableBlend();
        RenderSystem.defaultAlphaFunc();
        lightTextureIn.func_205108_b();
        RenderSystem.disableFog();
    }

    public void clearEffects() {
        this.byType.clear();
        this.queue.clear();
    }
}

