/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.menucompanions.client.storage;

import com.fuzs.menucompanions.client.handler.MenuEntityHandler;
import com.fuzs.menucompanions.client.util.CreateEntityUtil;
import com.fuzs.menucompanions.client.util.IEntrySerializer;
import com.fuzs.menucompanions.client.world.MenuClientWorld;
import com.fuzs.menucompanions.mixin.EntityAccessorMixin;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.IWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityMenuEntry {
    public static final String DISPLAY_NAME = "display";
    public static final String DATA_NAME = "data";
    public static final String PLAYER_NAME = "player";
    public static final String MODEL_NAME = "model";
    @Nullable
    private final EntityType<?> type;
    protected final CompoundNBT compound;
    private final byte data;
    private final float scale;
    private final int xOffset;
    private final int yOffset;
    private final boolean nameplate;
    private final boolean particles;
    private final int weight;
    private final MenuEntityHandler.MenuSide side;

    public EntityMenuEntry(@Nullable EntityType<?> type, CompoundNBT compound, byte data, float scale, int xOffset, int yOffset, boolean nameplate, boolean particles, int weight, MenuEntityHandler.MenuSide side) {
        this.type = type;
        this.compound = compound;
        this.data = data;
        this.scale = scale;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.nameplate = nameplate;
        this.particles = particles;
        this.weight = weight;
        this.side = side;
    }

    private boolean isTypeSet() {
        return this.type != null;
    }

    public float getScale(Entity entity) {
        if (this.isTypeSet()) {
            return this.scale;
        }
        return EntityMenuEntry.getScale(entity.func_213311_cf(), entity.func_213302_cg());
    }

    public static float getScale(float width, float height) {
        float minWidth = 0.5f;
        float maxWidth = 3.0f;
        float midWidth = 1.75f;
        float minHeight = 0.33333334f;
        float maxHeight = 1.3333334f;
        float midHeight = 0.8333334f;
        width /= 0.6f;
        height /= 1.8f;
        if (Math.abs(width / 1.75f - 1.0f) < Math.abs(height / 0.8333334f - 1.0f)) {
            if (height < 0.33333334f) {
                return 0.33333334f / height;
            }
            if (height > 1.3333334f) {
                return 1.3333334f / height;
            }
        } else {
            if (width < 0.5f) {
                return 0.5f / width;
            }
            if (width > 3.0f) {
                return 3.0f / width;
            }
        }
        return 1.0f;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public boolean showNameplate() {
        return this.nameplate;
    }

    public boolean showParticles() {
        return this.particles;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isSide(MenuEntityHandler.MenuSide side) {
        return this.side == MenuEntityHandler.MenuSide.BOTH || this.side == side;
    }

    public boolean isTick() {
        return this.readProperty(PropertyFlags.TICK);
    }

    public boolean isWalking() {
        return this.readProperty(PropertyFlags.WALKING);
    }

    @Nullable
    public Entity create(MenuClientWorld worldIn) {
        return CreateEntityUtil.loadEntity(this.getEntityType(), this.compound, worldIn, entity -> {
            entity.func_230245_c_(this.readProperty(PropertyFlags.ON_GROUND));
            ((EntityAccessorMixin)entity).setInWater(this.readProperty(PropertyFlags.IN_WATER));
            if (entity instanceof MobEntity && this.readProperty(PropertyFlags.AGGRESSIVE)) {
                ((MobEntity)entity).func_213395_q(true);
            }
            CreateEntityUtil.onInitialSpawn(entity, (IWorld)worldIn, this.compound.isEmpty());
            return entity;
        });
    }

    private EntityType<?> getEntityType() {
        if (this.type != null) {
            return this.type;
        }
        List types = ForgeRegistries.ENTITIES.getValues().stream().filter(type -> type.func_220339_d() != EntityClassification.MISC).collect(Collectors.toList());
        Collections.shuffle(types);
        return (EntityType)types.stream().findFirst().get();
    }

    public JsonElement serialize() {
        JsonObject jsonobject = new JsonObject();
        IEntrySerializer.serializeEntityType(jsonobject, this.type);
        jsonobject.addProperty("weight", (Number)this.weight);
        jsonobject.add(DISPLAY_NAME, (JsonElement)this.serializeDisplay());
        jsonobject.add(DATA_NAME, (JsonElement)this.serializeData());
        return jsonobject;
    }

    private JsonObject serializeDisplay() {
        JsonObject jsonobject = new JsonObject();
        if (this.isTypeSet()) {
            jsonobject.addProperty("scale", (Number)Float.valueOf(this.scale));
            jsonobject.addProperty("x_offset", (Number)this.xOffset);
            jsonobject.addProperty("y_offset", (Number)this.yOffset);
        }
        jsonobject.addProperty("nameplate", Boolean.valueOf(this.nameplate));
        jsonobject.addProperty("particles", Boolean.valueOf(this.particles));
        IEntrySerializer.serializeEnum(jsonobject, "side", this.side);
        return jsonobject;
    }

    private JsonObject serializeData() {
        JsonObject jsonobject = new JsonObject();
        if (this.isTypeSet()) {
            jsonobject.addProperty("nbt", IEntrySerializer.serializeNBT(this.compound));
        }
        IEntrySerializer.serializeEnumProperties(jsonobject, PropertyFlags.class, this.data, PropertyFlags::toString, PropertyFlags::getPropertyMask);
        return jsonobject;
    }

    protected boolean readProperty(PropertyFlags property) {
        return (this.data & property.getPropertyMask()) == property.getPropertyMask();
    }

    public static enum PropertyFlags {
        TICK("tick"),
        ON_GROUND("on_ground"),
        IN_WATER("in_water"),
        AGGRESSIVE("aggressive"),
        WALKING("walking");

        private final int identifier = 1 << this.ordinal();
        private final String name;

        private PropertyFlags(String name) {
            this.name = name;
        }

        public int getPropertyMask() {
            return this.identifier;
        }

        public String toString() {
            return this.name;
        }
    }
}

